/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraph {
    GlobalOptimizer.InputAbc abc;

    CallGraph(GlobalOptimizer.InputAbc abc) {
        this.abc = abc;
    }

    public List<Method> traverseDepthFirstUnique() {
        ArrayList<Method> traversed_methods = new ArrayList<Method>();
        for (Type t2 : this.abc.scripts) {
            this.searchType(t2, traversed_methods);
        }
        return traversed_methods;
    }

    private void searchType(Type t2, List<Method> traversed_methods) {
        this.searchMethod(t2.init, traversed_methods);
        for (Binding b12 : t2.defs.values()) {
            if (b12.method == null) continue;
            this.searchMethod(b12.method, traversed_methods);
        }
    }

    private void searchMethod(Method m2, List<Method> traversed_methods) {
        if (traversed_methods.contains(m2)) {
            return;
        }
        traversed_methods.add(m2);
        for (Block b3 : Algorithms.dfs(m2.entry.to)) {
            for (Expr e2 : b3.exprs) {
                switch (e2.op) {
                    case 88: {
                        this.searchType(e2.c, traversed_methods);
                        this.searchType(e2.c.itype, traversed_methods);
                        break;
                    }
                    case 64: {
                        Method f2 = e2.m;
                        this.searchMethod(f2, traversed_methods);
                        break;
                    }
                }
            }
        }
    }
}

