/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class OCSPServiceLocator
extends X509V3Extension
implements Cloneable,
Serializable,
OCSPSingleExtension {
    private X500Name a;
    private AuthorityInfoAccess b;
    ASN1Template c;

    public OCSPServiceLocator() {
        this.extensionTypeFlag = 122;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.OCSP_SERVICE_LOCATOR_OID);
        this.extensionTypeString = "OCSPServiceLocator";
        this.a = null;
        this.b = null;
    }

    public OCSPServiceLocator(X500Name x500Name, AuthorityInfoAccess authorityInfoAccess) throws CertificateException {
        if (x500Name == null || authorityInfoAccess == null) {
            throw new CertificateException("Missing values");
        }
        this.extensionTypeFlag = 122;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.OCSP_SERVICE_LOCATOR_OID);
        this.extensionTypeString = "OCSPServiceLocator";
        try {
            this.a = (X500Name)x500Name.clone();
            this.b = (AuthorityInfoAccess)authorityInfoAccess.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException(cloneNotSupportedException.getMessage());
        }
    }

    public int derEncodeValueInit() {
        if (this.a == null) {
            return 0;
        }
        int n2 = this.a.getDERLen(0);
        byte[] byArray = new byte[n2];
        try {
            this.a.getDEREncoding(byArray, 0, byArray.length);
        }
        catch (NameException nameException) {
            return 0;
        }
        try {
            EncodedContainer encodedContainer;
            Object object;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EncodedContainer encodedContainer2 = new EncodedContainer(65280, true, 0, byArray, 0, byArray.length);
            if (this.b != null) {
                object = this.a(this.b);
                encodedContainer = new EncodedContainer(65536, true, 0, (byte[])object, 0, ((byte[])object).length);
            } else {
                encodedContainer = new EncodedContainer(65536, false, 0, null, 0, 0);
            }
            object = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer2, encodedContainer, object};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private EncodedContainer a(int n2, Vector vector, Vector vector2) throws CertificateException {
        EncodedContainer encodedContainer = null;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        byte[] byArray = (byte[])vector.elementAt(n2);
        try {
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
            GeneralName generalName = (GeneralName)vector2.elementAt(n2);
            byte[] byArray2 = new byte[generalName.getDERLen(0)];
            int n3 = generalName.getDEREncoding(byArray2, 0, 0);
            EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer2, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n4 = aSN1Template.derEncodeInit();
            byte[] byArray3 = new byte[n4];
            n4 = aSN1Template.derEncode(byArray3, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, byArray3, 0, n4);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode Access Description");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not encode Access Description ");
        }
        return encodedContainer;
    }

    private byte[] a(AuthorityInfoAccess authorityInfoAccess) {
        Object object;
        Vector<GeneralName> vector = new Vector<GeneralName>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n2 = authorityInfoAccess.getAccessDescriptionCount();
        if (n2 == 0) {
            return null;
        }
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                object = authorityInfoAccess.getAccessMethod(i2);
                byte[] byArray = new byte[((byte[])object).length];
                System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                vector2.addElement(byArray);
                vector.addElement(authorityInfoAccess.getAccessLocation(i2));
            }
        }
        catch (CertificateException certificateException) {
            return null;
        }
        try {
            Vector<Object> vector3 = new Vector<Object>();
            object = new OfContainer(0, true, 0, 12288, new EncodedContainer(12288));
            vector3.addElement(object);
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                EncodedContainer encodedContainer = this.a(i3, vector2, vector);
                ((OfContainer)object).addContainer(encodedContainer);
            }
            Object[] objectArray = new ASN1Container[vector3.size()];
            vector3.copyInto(objectArray);
            ASN1Template aSN1Template = new ASN1Template((ASN1Container[])objectArray);
            int n3 = aSN1Template.derEncodeInit();
            byte[] byArray = new byte[n3];
            aSN1Template.derEncode(byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.c.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{genTimeContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode ArchiveCutoff extension.");
        }
    }

    public X500Name getIssuer() {
        return this.a;
    }

    public AuthorityInfoAccess getLocator() {
        return this.b;
    }

    public void setIssuer(X500Name x500Name) throws CloneNotSupportedException {
        if (x500Name == null) {
            throw new CloneNotSupportedException("Missing value");
        }
        try {
            this.a = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneNotSupportedException(cloneNotSupportedException.getMessage());
        }
    }

    public void setLocator(AuthorityInfoAccess authorityInfoAccess) throws CloneNotSupportedException {
        if (authorityInfoAccess == null) {
            throw new CloneNotSupportedException("Missing value");
        }
        try {
            this.b = (AuthorityInfoAccess)authorityInfoAccess.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneNotSupportedException(cloneNotSupportedException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPServiceLocator oCSPServiceLocator = new OCSPServiceLocator();
        if (this.a != null) {
            oCSPServiceLocator.a = (X500Name)this.a.clone();
        }
        if (this.b != null) {
            oCSPServiceLocator.b = (AuthorityInfoAccess)this.b.clone();
        }
        if (this.c != null) {
            oCSPServiceLocator.derEncodeValueInit();
        }
        super.copyValues(oCSPServiceLocator);
        return oCSPServiceLocator;
    }
}

