/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class IssuingDistributionPoint
extends X509V3Extension
implements Cloneable,
Serializable,
CRLExtension {
    public static final int REASON_FLAGS_BITS = 7;
    public static final int REASON_FLAGS_MASK = -33554432;
    public static final int UNUSED = Integer.MIN_VALUE;
    public static final int KEY_COMPROMISE = 0x40000000;
    public static final int CA_COMPROMISE = 0x20000000;
    public static final int AFFILIATION_CHANGED = 0x10000000;
    public static final int SUPERSEDED = 0x8000000;
    public static final int CESSATION_OF_OPERATION = 0x4000000;
    public static final int CERTIFICATE_HOLD = 0x2000000;
    private static final int a = 0x810000;
    private static final int b = 8519681;
    private static final int c = 0x820002;
    private static final int d = 8454147;
    private static final int e = 8519684;
    private static final int f = 0x800000;
    private static final int g = 0x800001;
    ASN1Template h;
    private GeneralNames i = null;
    private RDN j = null;
    private int k = -1;
    private boolean l = false;
    private boolean m = false;
    private boolean n = false;

    public IssuingDistributionPoint() {
        this.extensionTypeFlag = 28;
        this.criticality = false;
        this.setStandardOID(28);
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(RDN rDN, boolean bl2, boolean bl3, int n2, boolean bl4, boolean bl5) {
        this.extensionTypeFlag = 28;
        this.criticality = bl5;
        this.setStandardOID(28);
        this.j = rDN;
        this.l = bl2;
        this.m = bl3;
        this.k = n2;
        this.n = bl4;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(GeneralNames generalNames, boolean bl2, boolean bl3, int n2, boolean bl4, boolean bl5) {
        this.extensionTypeFlag = 28;
        this.criticality = bl5;
        this.setStandardOID(28);
        this.i = generalNames;
        this.l = bl2;
        this.m = bl3;
        this.k = n2;
        this.n = bl4;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            ChoiceContainer choiceContainer = new ChoiceContainer(0x810000);
            EncodedContainer encodedContainer = new EncodedContainer(0x803000);
            EncodedContainer encodedContainer2 = new EncodedContainer(8401153);
            BooleanContainer booleanContainer = new BooleanContainer(8519681);
            BooleanContainer booleanContainer2 = new BooleanContainer(0x820002);
            BitStringContainer bitStringContainer = new BitStringContainer(8454147);
            BooleanContainer booleanContainer3 = new BooleanContainer(8519684);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, encodedContainer2, endContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                this.i = new GeneralNames(encodedContainer.data, encodedContainer.dataOffset, 0x800000);
            } else if (encodedContainer2.dataPresent) {
                this.j = new RDN(encodedContainer2.data, encodedContainer2.dataOffset, 0x800001);
            } else {
                this.i = null;
                this.j = null;
            }
            this.l = booleanContainer.dataPresent ? booleanContainer.value : false;
            this.m = booleanContainer2.dataPresent ? booleanContainer2.value : false;
            if (bitStringContainer.dataPresent) {
                if (bitStringContainer.dataLen > 4) {
                    throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
                }
                if (bitStringContainer.dataLen == 0) {
                    this.k = 0;
                } else {
                    int n3 = 0;
                    int n4 = bitStringContainer.dataOffset;
                    int n5 = 24;
                    while (n4 < bitStringContainer.dataOffset + bitStringContainer.dataLen) {
                        n3 |= (bitStringContainer.data[n4] & 0xFF) << n5;
                        ++n4;
                        n5 -= 8;
                    }
                    this.k = n3 &= 0xFE000000;
                }
            } else {
                this.k = -1;
            }
            this.n = booleanContainer3.dataPresent ? booleanContainer3.value : false;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not create new GeneralNames object.");
        }
    }

    public void setIssuingDistributionPointName(GeneralNames generalNames) {
        this.i = generalNames;
        this.j = null;
    }

    public void setIssuingDistributionPointName(RDN rDN) {
        this.j = rDN;
        this.i = null;
    }

    public void setUserCerts(boolean bl2) {
        this.l = bl2;
    }

    public void setCACerts(boolean bl2) {
        this.m = bl2;
    }

    public void setReasonFlags(int n2) {
        this.k = n2;
    }

    public void setIndirectCRL(boolean bl2) {
        this.n = bl2;
    }

    public Object getDistributionPointName() {
        if (this.j != null) {
            return this.j;
        }
        return this.i;
    }

    public boolean getUserCerts() {
        return this.l;
    }

    public boolean getCACerts() {
        return this.m;
    }

    public int getReasonFlags() {
        return this.k;
    }

    public boolean getIndirectCRL() {
        return this.n;
    }

    public int derEncodeValueInit() {
        try {
            int n2 = 0;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            ChoiceContainer choiceContainer = null;
            BitStringContainer bitStringContainer = null;
            EncodedContainer encodedContainer = null;
            BooleanContainer booleanContainer = null;
            BooleanContainer booleanContainer2 = null;
            BooleanContainer booleanContainer3 = null;
            EndContainer endContainer = new EndContainer();
            if (this.i != null || this.j != null) {
                choiceContainer = new ChoiceContainer(0x810000, 0);
                encodedContainer = this.a();
                n2 = 1;
            }
            if (this.k != -1) {
                bitStringContainer = new BitStringContainer(8454147, true, 0, this.k, 7, true);
                n2 = n2 == 0 ? 2 : 3;
            }
            booleanContainer = this.l ? new BooleanContainer(8519681, true, 0, true) : new BooleanContainer(8519681, false, 0, false);
            booleanContainer2 = this.m ? new BooleanContainer(0x820002, true, 0, true) : new BooleanContainer(0x820002, false, 0, false);
            booleanContainer3 = this.n ? new BooleanContainer(8519684, true, 0, true) : new BooleanContainer(8519684, false, 0, false);
            switch (n2) {
                case 0: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, booleanContainer2, booleanContainer3, endContainer};
                    this.h = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 1: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, endContainer, booleanContainer, booleanContainer2, booleanContainer3, endContainer};
                    this.h = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 2: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, endContainer};
                    this.h = new ASN1Template(aSN1ContainerArray);
                    break;
                }
                case 3: {
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, endContainer, booleanContainer, booleanContainer2, bitStringContainer, booleanContainer3, endContainer};
                    this.h = new ASN1Template(aSN1ContainerArray);
                }
            }
        }
        catch (CertificateException certificateException) {
            return 0;
        }
        try {
            return this.h.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private EncodedContainer a() throws CertificateException {
        EncodedContainer encodedContainer = null;
        int n2 = 0;
        byte[] byArray = null;
        try {
            if (this.i != null) {
                n2 = this.i.getDERLen(0x800000);
                byArray = new byte[n2];
                n2 = this.i.getDEREncoding(byArray, 0, 0x800000);
                encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            } else if (this.j != null) {
                n2 = this.j.getDERLen(0x800001);
                byArray = new byte[n2];
                n2 = this.j.getDEREncoding(byArray, 0, 0x800001);
                encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n2);
            }
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Can't encode DistributionPointNames" + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Can't encode DistributionPointNames" + nameException.getMessage());
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.h == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.h.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IssuingDistributionPoint issuingDistributionPoint = new IssuingDistributionPoint();
        if (this.i != null) {
            issuingDistributionPoint.i = (GeneralNames)this.i.clone();
        }
        if (this.j != null) {
            issuingDistributionPoint.j = (RDN)this.j.clone();
        }
        issuingDistributionPoint.k = this.k;
        issuingDistributionPoint.l = this.l;
        issuingDistributionPoint.m = this.m;
        issuingDistributionPoint.n = this.n;
        if (this.h != null) {
            issuingDistributionPoint.derEncodeValueInit();
        }
        super.copyValues(issuingDistributionPoint);
        return issuingDistributionPoint;
    }

    protected void reset() {
        super.reset();
        this.i = null;
        this.j = null;
        this.k = 0;
        this.l = false;
        this.m = false;
        this.n = false;
        this.h = null;
    }
}

