/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCFOutputStream;
import com.adobe.ucf.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Packager
implements ISigner {
    private static final char[] PROHIBITED_FILENAME_CHARACTERS = new char[]{'\\', ':', '*', '?', '\"', '<', '>', '|'};
    protected static final boolean IS_META_INF = true;
    private SortedMap<String, File> m_sources = new TreeMap<String, File>(String.CASE_INSENSITIVE_ORDER);
    private File m_output;
    private File m_tempFile;
    private UCFOutputStream m_stream;
    private Set<File> m_filesForCleanup;

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        if (this.m_output != null) {
            throw new IllegalStateException("output already set");
        }
        if (output.exists() && !output.canWrite()) {
            throw new IOException("cannot overwrite an existing, read-only file");
        }
        this.m_output = output;
    }

    @Override
    public void setPrivateKey(PrivateKey key) {
        this.m_stream.setPrivateKey(key);
    }

    @Override
    public void setAlsoIncludeOldStyleTimestamp() {
        this.m_stream.setAlsoIncludeOldStyleTimestamp();
    }

    @Override
    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.m_stream.setCertificateChain(certchain);
    }

    @Override
    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_stream.setSignerCertificate(cert);
    }

    @Override
    public void setTimestampURL(String url) {
        this.m_stream.setTimestampURL(url);
    }

    public void addSourceWithRoot(File source, File root) {
        this.addSourceWithPath(source, root.toURI().relativize(source.toURI()).getPath());
    }

    protected void addFileWithPath(File source, String path, boolean isMetaInf) {
        if (!source.isFile()) {
            throw new IllegalArgumentException("File does not exist: " + source.getPath());
        }
        if (source.getName().matches("^\\s.*")) {
            throw new IllegalArgumentException("Filename contains leading whitespace");
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("absolute path");
        }
        for (char c2 : PROHIBITED_FILENAME_CHARACTERS) {
            if (!path.contains(new Character(c2).toString())) continue;
            throw new IllegalArgumentException("Filename contains restricted character '" + c2 + "'");
        }
        for (char lowAscii = '\u0000'; lowAscii <= '\u001f'; lowAscii = (char)(lowAscii + '\u0001')) {
            if (!path.contains(new Character(lowAscii).toString())) continue;
            throw new IllegalArgumentException("Filename contains restricted low-ascii character " + lowAscii);
        }
        if (!isMetaInf && path.toUpperCase().startsWith("META-INF/")) {
            throw new IllegalArgumentException("Paths beginning with META-INF/ are reserved");
        }
        if (path.equals("mimetype")) {
            throw new IllegalArgumentException("The path \"mimetype\" is reserved");
        }
        if (this.m_sources.containsKey(path)) {
            File other = (File)this.m_sources.get(path);
            throw new IllegalArgumentException("Files \"" + other.getPath() + "\" and \"" + source.getPath() + "\" have conflicting package paths");
        }
        this.m_sources.put(path, source);
    }

    public void addSourceWithPath(File source, String path) {
        this.addFileWithPath(source, path, false);
    }

    public void addSourceFileOrDir(File file, File root) {
        this.addFileOrDir(file, root, null, false);
    }

    protected void addFileOrDir(File file, File root, String prefixPath, boolean allowMetaFiles) {
        String originalPath = file.getPath();
        if (!file.isAbsolute()) {
            file = new File(root, file.getPath());
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("no such file " + file.getPath());
        }
        if ((file = new File(file.toURI().normalize().getPath())).isHidden()) {
            return;
        }
        if (file.isFile()) {
            String relativizedPath;
            String basePath = "";
            if (prefixPath != null && prefixPath.length() > 0) {
                basePath = prefixPath + "/";
            }
            if ((relativizedPath = root.toURI().relativize(file.toURI()).getPath()).startsWith("/")) {
                throw new IllegalArgumentException("File " + originalPath + " is not relative to directory " + root.getPath());
            }
            try {
                this.addFileWithPath(file, basePath + relativizedPath, allowMetaFiles);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(e2.getLocalizedMessage() + ": " + file.getPath());
            }
            return;
        }
        File[] dirContents = file.listFiles();
        for (int idx = 0; idx < dirContents.length; ++idx) {
            this.addFileOrDir(dirContents[idx], root, prefixPath, allowMetaFiles);
        }
    }

    public void close() {
        try {
            if (this.m_stream != null) {
                this.m_stream.close();
            }
            this.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initTempFile(String prefix) throws IOException {
        this.m_tempFile = File.createTempFile(prefix, null, this.m_output.getAbsoluteFile().getParentFile());
        this.getStream().setOutput(this.m_tempFile);
        this.addFileForCleanup(this.m_tempFile);
    }

    protected void initTempFolder(String prefix) throws IOException {
        this.m_tempFile = File.createTempFile(prefix, null, this.m_output.getAbsoluteFile().getParentFile());
        this.m_tempFile.delete();
        this.m_tempFile.mkdir();
        this.addFileForCleanup(this.m_tempFile);
    }

    protected void renameOutput() throws IOException {
        boolean deleteSucceeded;
        if (this.m_output.exists() && !(deleteSucceeded = this.m_output.delete())) {
            throw new IOException("Unable to create output file: " + this.m_output.getPath());
        }
        if (!this.m_tempFile.exists()) {
            throw new IllegalStateException("The temporary packaging file at " + this.m_tempFile.getPath() + " is missing");
        }
        if (this.m_output.exists()) {
            throw new IllegalStateException("The output file at " + this.m_output.getPath() + " still exists and couldn't be deleted");
        }
        Utils.copyTo(this.m_tempFile, this.m_output);
    }

    protected void setSources(SortedMap<String, File> sources) {
        this.m_sources = sources;
    }

    protected SortedMap<String, File> getSources() {
        return this.m_sources;
    }

    protected UCFOutputStream getStream() {
        return this.m_stream;
    }

    protected void setStream(UCFOutputStream stream) {
        this.m_stream = stream;
    }

    protected File getOutput() {
        return this.m_output;
    }

    protected File getTempFile() {
        return this.m_tempFile;
    }

    private static boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (Packager.deleteAll(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    protected void cleanup() {
        if (this.m_filesForCleanup != null) {
            for (File file : this.m_filesForCleanup) {
                Packager.deleteAll(file);
            }
        }
    }

    protected void addFileForCleanup(File file) {
        if (this.m_filesForCleanup == null) {
            this.m_filesForCleanup = new HashSet<File>();
        }
        this.m_filesForCleanup.add(file);
    }
}

