/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import com.adobe.png.PNGReader;
import com.adobe.png.PNGTextChunk;
import com.adobe.png.PNGWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PNGUtils {
    public static InputStream updatePNGMetadata(InputStream inputStream, String keyword, String prefix, String rest) throws IOException {
        byte[] data = PNGUtils.readIn(inputStream);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PNGChunk chunk;
            PNGWriter writer = new PNGWriter(out);
            PNGReader reader = new PNGReader(in);
            boolean insertedMetadata = false;
            while ((chunk = reader.readChunk()) != null) {
                if (chunk.typeStr == "tEXt") {
                    PNGTextChunk textChunk = new PNGTextChunk(chunk);
                    if (textChunk.keyword == keyword && prefix != null && textChunk.value.startsWith(prefix)) continue;
                }
                if (!(insertedMetadata || chunk.typeStr != "IDAT" && chunk.typeStr != "IEND")) {
                    String metadata = (prefix == null ? "" : prefix) + rest;
                    writer.writeChunk(new PNGTextChunk(keyword, metadata));
                    insertedMetadata = true;
                }
                writer.writeChunk(chunk);
            }
            if (!insertedMetadata) {
                throw new PNGReader.ParseException("missing chunks");
            }
            data = out.toByteArray();
        }
        catch (PNGReader.ParseException e2) {
            // empty catch block
        }
        return new ByteArrayInputStream(data);
    }

    public static InputStream addTransparentBorder(InputStream in, int borderThickness) throws IOException {
        byte[] imageBytes = PNGUtils.readIn(in);
        try {
            PNGChunk chunk;
            ByteArrayOutputStream modifiedImage = new ByteArrayOutputStream();
            PNGWriter writer = new PNGWriter(modifiedImage);
            PNGReader reader = new PNGReader(new ByteArrayInputStream(imageBytes));
            while ((chunk = reader.readChunk()) != null) {
                if (chunk.typeStr == "iTXt") continue;
                writer.writeChunk(chunk);
            }
            BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(modifiedImage.toByteArray()));
            int newWidth = originalImage.getWidth() + 2 * borderThickness;
            int newHeight = originalImage.getHeight() + 2 * borderThickness;
            BufferedImage bufferedImage = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.drawImage(originalImage, null, 1, 1);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", buffer);
            return new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (PNGReader.ParseException e2) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(imageBytes);
    }

    private static byte[] readIn(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((len = inputStream.read(data)) >= 0) {
            out.write(data, 0, len);
        }
        return out.toByteArray();
    }
}

