/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.ABCOpCodes;
import adobe.abc.BuiltinDomain;
import adobe.abc.Edge;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr
implements Comparable<Expr> {
    public int op;
    public Expr[] args = OptimizerConstants.noexprs;
    public Expr[] scopes = OptimizerConstants.noexprs;
    public Expr[] locals = OptimizerConstants.noexprs;
    public int[] imm;
    public Edge[] pred = OptimizerConstants.noedges;
    public Edge[] succ;
    public int id;
    public int flags;
    public Name ref;
    public Object value;
    public Type c;
    public Method m;
    boolean is_live_out = false;
    public Typeref castType;
    public final int originalBodyOffset;
    public static final int syntheticBodyOffset = -1;

    public Expr(Method m2, int op, int bodyOffset) {
        this.op = op;
        this.flags = OptimizerConstants.flagTable[op];
        this.id = m2.getNextExprId();
        this.originalBodyOffset = bodyOffset;
    }

    public Expr(Method m2, int op) {
        this(m2, op, -1);
    }

    public Expr(Method m2, int op, int bodyOffset, int imm1) {
        this(m2, op, bodyOffset);
        this.imm = new int[]{imm1};
    }

    public Expr(Method m2, int op, int bodyOffset, Expr arg) {
        this(m2, op, bodyOffset);
        this.args = new Expr[]{arg};
    }

    private Expr(Method m2, int op, int bodyOffset, Object value) {
        this(m2, op, bodyOffset);
        this.value = value;
    }

    public static Expr createWithValue(Method m2, int op, int bodyOffset, Object value) {
        return new Expr(m2, op, bodyOffset, value);
    }

    public static Expr createWithArgs(Method m2, int op, int bodyOffset, Expr[] args) {
        Expr e2 = new Expr(m2, op, bodyOffset);
        e2.args = args;
        return e2;
    }

    public Expr(Method m2, int op, Expr arg) {
        this(m2, op, -1, arg);
    }

    public Expr(Method m2, int op, Expr[] args) {
        this(m2, op, -1);
        this.args = args;
    }

    public static Expr createWithValue(Method m2, int op, Object value) {
        return Expr.createWithValue(m2, op, -1, value);
    }

    public Expr(Method m2, int op, int bodyOffset, Expr[] frame, int sp, int argc) {
        this(m2, op, bodyOffset);
        this.args = GlobalOptimizer.capture(frame, sp, argc);
    }

    public Expr(Method m2, int op, int bodyOffset, int imm1, Expr[] frame, int sp, int argc) {
        this(m2, op, bodyOffset, frame, sp, argc);
        this.imm = new int[]{imm1};
    }

    public Expr(Method m2, int op, int bodyOffset, Name ref, Expr[] frame, int sp, int argc) {
        this(m2, op, bodyOffset, frame, sp, argc);
        this.ref = ref;
    }

    public Expr(Method m2, int op, Name ref, Expr arg) {
        this(m2, op, -1);
        this.ref = ref;
        this.args = new Expr[]{arg};
    }

    public int id() {
        return this.id;
    }

    void appendLocal(Expr l2) {
        this.locals = GlobalOptimizer.copyOf(this.locals, this.locals.length + 1);
        this.locals[this.locals.length - 1] = l2;
    }

    void append(Expr a, Edge p2) {
        this.args = GlobalOptimizer.copyOf(this.args, this.args.length + 1);
        this.args[this.args.length - 1] = a;
        this.pred = GlobalOptimizer.copyOf(this.pred, this.pred.length + 1);
        this.pred[this.pred.length - 1] = p2;
    }

    void removePhiInput(int j2) {
        assert (257 == this.op);
        Expr[] a = new Expr[this.args.length - 1];
        System.arraycopy(this.args, 0, a, 0, j2);
        System.arraycopy(this.args, j2 + 1, a, j2, this.args.length - j2 - 1);
        this.args = a;
        Edge[] ed = new Edge[this.pred.length - 1];
        System.arraycopy(this.pred, 0, ed, 0, j2);
        System.arraycopy(this.pred, j2 + 1, ed, j2, this.pred.length - j2 - 1);
        this.pred = ed;
    }

    public String toString() {
        String bodyOffsetStr = this.originalBodyOffset != -1 ? "_" + String.valueOf(this.originalBodyOffset) : "";
        return (this.onStack() ? "t" : (this.onScope() ? "s" : (this.inLocal() ? "l" : "i"))) + this.id + bodyOffsetStr;
    }

    void clearEffect() {
        this.flags &= 0xFFFFFFFD;
    }

    void clearPx() {
        this.flags &= 0xFFFFFFF7;
    }

    public void setPure() {
        this.clearEffect();
        this.clearPx();
    }

    public void clearNullCheck() {
        this.flags &= 0xFFFFEFFF;
    }

    public void resetFlags(int mask) {
        this.flags = this.flags & ~mask | OptimizerConstants.flagTable[this.op] & mask;
    }

    public boolean hasEffect() {
        return (this.flags & 2) != 0;
    }

    public boolean isNullCheck() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean isPx() {
        return (this.flags & 8) != 0;
    }

    public boolean isSynthetic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean onStack() {
        return (OptimizerConstants.flagTable[this.op] & 0x40) != 0;
    }

    public boolean isOper() {
        return (OptimizerConstants.flagTable[this.op] & 1) != 0;
    }

    public boolean onScope() {
        return (OptimizerConstants.flagTable[this.op] & 0x20) != 0;
    }

    public boolean inLocal() {
        return (OptimizerConstants.flagTable[this.op] & 0x80) != 0;
    }

    public boolean isCoerce() {
        return (OptimizerConstants.flagTable[this.op] & 4) != 0;
    }

    @Override
    public int compareTo(Expr other) {
        int result = this.id - other.id;
        assert (result != 0 || this == other);
        return result;
    }

    public boolean isLegalUpCast(Typeref argTyperef) {
        return this.op == 261 && Expr.isLegalUpCast(this.castType, argTyperef);
    }

    public static boolean isLegalUpCast(Typeref castType, Typeref argTyperef) {
        return castType.getType() == argTyperef.getType() || argTyperef.getType().isDerivedFrom(castType.getType()) || argTyperef.getType() == BuiltinDomain.instance().NULL() && !castType.getType().isNumeric() || castType.getType() == BuiltinDomain.instance().ANY();
    }

    public static String opName(int opCode) {
        if (opCode < 256) {
            return ABCOpCodes.opNames[opCode];
        }
        return OptimizerConstants.synthOPNames[opCode - 256];
    }

    public final String opName() {
        return Expr.opName(this.op);
    }
}

