/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryListBuilder {
    private TryRange firstTryRange = new TryRange(0, 0);
    private TryRange lastTryRange;

    public TryListBuilder() {
        this.firstTryRange.next = this.lastTryRange = new TryRange(0, 0);
        this.lastTryRange.previous = this.firstTryRange;
    }

    public Pair<List<CodeItem.TryItem>, List<CodeItem.EncodedCatchHandler>> encodeTries() {
        if (this.firstTryRange.next == this.lastTryRange) {
            return new Pair<Object, Object>(null, null);
        }
        ArrayList<CodeItem.TryItem> tries = new ArrayList<CodeItem.TryItem>();
        ArrayList<CodeItem.EncodedCatchHandler> handlers = new ArrayList<CodeItem.EncodedCatchHandler>();
        HashMap<CodeItem.EncodedCatchHandler, CodeItem.EncodedCatchHandler> handlerDict = new HashMap<CodeItem.EncodedCatchHandler, CodeItem.EncodedCatchHandler>();
        TryRange tryRange = this.firstTryRange.next;
        while (tryRange != this.lastTryRange) {
            CodeItem.EncodedTypeAddrPair[] encodedTypeAddrPairs = new CodeItem.EncodedTypeAddrPair[tryRange.handlers.size()];
            int index = 0;
            for (Handler handler : tryRange.handlers) {
                CodeItem.EncodedTypeAddrPair encodedTypeAddrPair = new CodeItem.EncodedTypeAddrPair(handler.type, handler.handlerAddress);
                encodedTypeAddrPairs[index++] = encodedTypeAddrPair;
            }
            CodeItem.EncodedCatchHandler encodedCatchHandler = new CodeItem.EncodedCatchHandler(encodedTypeAddrPairs, tryRange.catchAllHandlerAddress);
            CodeItem.EncodedCatchHandler internedEncodedCatchHandler = (CodeItem.EncodedCatchHandler)handlerDict.get(encodedCatchHandler);
            if (internedEncodedCatchHandler == null) {
                handlerDict.put(encodedCatchHandler, encodedCatchHandler);
                handlers.add(encodedCatchHandler);
            } else {
                encodedCatchHandler = internedEncodedCatchHandler;
            }
            CodeItem.TryItem tryItem = new CodeItem.TryItem(tryRange.startAddress, tryRange.endAddress - tryRange.startAddress, encodedCatchHandler);
            tries.add(tryItem);
            tryRange = tryRange.next;
        }
        return new Pair<List<CodeItem.TryItem>, List<CodeItem.EncodedCatchHandler>>(tries, handlers);
    }

    public void addCatchAllHandler(int startAddress, int endAddress, int handlerAddress) {
        Pair<TryRange, TryRange> ranges = this.getBoundingRanges(startAddress, endAddress);
        TryRange startRange = (TryRange)ranges.first;
        TryRange endRange = (TryRange)ranges.second;
        int previousEnd = startAddress;
        TryRange tryRange = startRange;
        do {
            if (tryRange.startAddress > previousEnd) {
                TryRange newRange = new TryRange(previousEnd, tryRange.startAddress);
                tryRange.prepend(newRange);
                tryRange = newRange;
            }
            if (tryRange.catchAllHandlerAddress == -1) {
                tryRange.catchAllHandlerAddress = handlerAddress;
            }
            previousEnd = tryRange.endAddress;
            tryRange = tryRange.next;
        } while (tryRange.previous != endRange);
    }

    public Pair<TryRange, TryRange> getBoundingRanges(int startAddress, int endAddress) {
        TryRange startRange = null;
        TryRange endRange = null;
        TryRange tryRange = this.firstTryRange.next;
        while (tryRange != this.lastTryRange) {
            if (startAddress == tryRange.startAddress) {
                startRange = tryRange;
                break;
            }
            if (startAddress > tryRange.startAddress && startAddress < tryRange.endAddress) {
                startRange = tryRange.split(startAddress);
                break;
            }
            if (startAddress < tryRange.startAddress) {
                if (endAddress <= tryRange.startAddress) {
                    startRange = new TryRange(startAddress, endAddress);
                    tryRange.prepend(startRange);
                    return new Pair<TryRange, TryRange>(startRange, startRange);
                }
                startRange = new TryRange(startAddress, tryRange.startAddress);
                tryRange.prepend(startRange);
                break;
            }
            tryRange = tryRange.next;
        }
        if (startRange == null) {
            startRange = new TryRange(startAddress, endAddress);
            this.lastTryRange.prepend(startRange);
            return new Pair<TryRange, TryRange>(startRange, startRange);
        }
        tryRange = startRange;
        while (tryRange != this.lastTryRange) {
            if (tryRange.endAddress == endAddress) {
                endRange = tryRange;
                break;
            }
            if (tryRange.startAddress < endAddress && tryRange.endAddress > endAddress) {
                tryRange.split(endAddress);
                endRange = tryRange;
                break;
            }
            if (tryRange.startAddress >= endAddress) {
                endRange = new TryRange(tryRange.previous.endAddress, endAddress);
                tryRange.prepend(endRange);
                break;
            }
            tryRange = tryRange.next;
        }
        if (endRange == null) {
            endRange = new TryRange(this.lastTryRange.previous.endAddress, endAddress);
            this.lastTryRange.prepend(endRange);
        }
        return new Pair<TryRange, TryRange>(startRange, endRange);
    }

    public void addHandler(TypeIdItem type, int startAddress, int endAddress, int handlerAddress) {
        Pair<TryRange, TryRange> ranges = this.getBoundingRanges(startAddress, endAddress);
        TryRange startRange = (TryRange)ranges.first;
        TryRange endRange = (TryRange)ranges.second;
        Handler handler = new Handler(type, handlerAddress);
        int previousEnd = startAddress;
        TryRange tryRange = startRange;
        do {
            if (tryRange.startAddress > previousEnd) {
                TryRange newRange = new TryRange(previousEnd, tryRange.startAddress);
                tryRange.prepend(newRange);
                tryRange = newRange;
            }
            tryRange.appendHandler(handler);
            previousEnd = tryRange.endAddress;
            tryRange = tryRange.next;
        } while (tryRange.previous != endRange);
    }

    private class Handler {
        public final TypeIdItem type;
        public final int handlerAddress;

        public Handler(TypeIdItem type, int handlerAddress) {
            this.type = type;
            this.handlerAddress = handlerAddress;
        }
    }

    private class TryRange {
        public TryRange previous = null;
        public TryRange next = null;
        public int startAddress;
        public int endAddress;
        public LinkedList<Handler> handlers;
        public int catchAllHandlerAddress;

        public TryRange(int startAddress, int endAddress) {
            this.startAddress = startAddress;
            this.endAddress = endAddress;
            this.handlers = new LinkedList();
            this.previous = null;
            this.next = null;
            this.catchAllHandlerAddress = -1;
        }

        public void append(TryRange tryRange) {
            this.next.previous = tryRange;
            tryRange.next = this.next;
            this.next = tryRange;
            tryRange.previous = this;
        }

        public void prepend(TryRange tryRange) {
            this.previous.next = tryRange;
            tryRange.previous = this.previous;
            this.previous = tryRange;
            tryRange.next = this;
        }

        public TryRange split(int address) {
            TryRange tryRange = new TryRange(address, this.endAddress);
            tryRange.catchAllHandlerAddress = this.catchAllHandlerAddress;
            tryRange.handlers.addAll(this.handlers);
            this.append(tryRange);
            this.endAddress = address;
            return tryRange;
        }

        public void appendHandler(Handler handler) {
            this.handlers.addLast(handler);
        }

        public void prependHandler(Handler handler) {
            this.handlers.addFirst(handler);
        }
    }
}

