/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public final class Hex {
    private Hex() {
    }

    public static String u8(long v2) {
        char[] result = new char[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            result[15 - i2] = Character.forDigit((int)v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String u4(int v2) {
        char[] result = new char[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            result[7 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String u3(int v2) {
        char[] result = new char[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            result[5 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String u2(int v2) {
        char[] result = new char[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            result[3 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String u2or4(int v2) {
        if (v2 == (char)v2) {
            return Hex.u2(v2);
        }
        return Hex.u4(v2);
    }

    public static String u1(int v2) {
        char[] result = new char[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            result[1 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String uNibble(int v2) {
        char[] result = new char[]{Character.forDigit(v2 & 0xF, 16)};
        return new String(result);
    }

    public static String s8(long v2) {
        char[] result = new char[17];
        if (v2 < 0L) {
            result[0] = 45;
            v2 = -v2;
        } else {
            result[0] = 43;
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            result[16 - i2] = Character.forDigit((int)v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String s4(int v2) {
        char[] result = new char[9];
        if (v2 < 0) {
            result[0] = 45;
            v2 = -v2;
        } else {
            result[0] = 43;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            result[8 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String s2(int v2) {
        char[] result = new char[5];
        if (v2 < 0) {
            result[0] = 45;
            v2 = -v2;
        } else {
            result[0] = 43;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            result[4 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String s1(int v2) {
        char[] result = new char[3];
        if (v2 < 0) {
            result[0] = 45;
            v2 = -v2;
        } else {
            result[0] = 43;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            result[2 - i2] = Character.forDigit(v2 & 0xF, 16);
            v2 >>= 4;
        }
        return new String(result);
    }

    public static String dump(byte[] arr, int offset, int length, int outOffset, int bpl, int addressLength) {
        int end = offset + length;
        if ((offset | length | end) < 0 || end > arr.length) {
            throw new IndexOutOfBoundsException("arr.length " + arr.length + "; " + offset + "..!" + end);
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("outOffset < 0");
        }
        if (length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length * 4 + 6);
        boolean bol = true;
        int col = 0;
        while (length > 0) {
            if (col == 0) {
                String astr;
                switch (addressLength) {
                    case 2: {
                        astr = Hex.u1(outOffset);
                        break;
                    }
                    case 4: {
                        astr = Hex.u2(outOffset);
                        break;
                    }
                    case 6: {
                        astr = Hex.u3(outOffset);
                        break;
                    }
                    default: {
                        astr = Hex.u4(outOffset);
                    }
                }
                sb.append(astr);
                sb.append(": ");
            } else if (!(col & true)) {
                sb.append(' ');
            }
            sb.append(Hex.u1(arr[offset]));
            ++outOffset;
            ++offset;
            if (++col == bpl) {
                sb.append('\n');
                col = 0;
            }
            --length;
        }
        if (col != 0) {
            sb.append('\n');
        }
        return sb.toString();
    }
}

