/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Renderers.ByteRenderer;
import org.jf.baksmali.Renderers.CharRenderer;
import org.jf.baksmali.Renderers.FloatRenderer;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.baksmali.Renderers.ShortRenderer;
import org.jf.baksmali.Renderers.StringIdItemRenderer;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.StringIdItem;

public class baksmali {
    public static boolean noParameterRegisters = false;
    public static boolean useLocalsDirective = false;
    public static boolean useSequentialLabels = false;
    public static boolean outputDebugInfo = true;
    public static boolean addCodeOffsets = false;
    public static boolean deodex = false;
    public static boolean verify = false;
    public static int registerInfo = 0;
    public static String bootClassPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassembleDexFile(String dexFilePath, DexFile dexFile, boolean deodex, String outputDirectory, String[] classPathDirs, String bootClassPath, boolean noParameterRegisters, boolean useLocalsDirective, boolean useSequentialLabels, boolean outputDebugInfo, boolean addCodeOffsets, int registerInfo, boolean verify) {
        File outputDirectoryFile;
        baksmali.noParameterRegisters = noParameterRegisters;
        baksmali.useLocalsDirective = useLocalsDirective;
        baksmali.useSequentialLabels = useSequentialLabels;
        baksmali.outputDebugInfo = outputDebugInfo;
        baksmali.addCodeOffsets = addCodeOffsets;
        baksmali.deodex = deodex;
        baksmali.registerInfo = registerInfo;
        baksmali.bootClassPath = bootClassPath;
        baksmali.verify = verify;
        if (registerInfo != 0 || deodex || verify) {
            try {
                ClassPath.InitializeClassPath(classPathDirs, bootClassPath == null ? null : bootClassPath.split(":"), dexFilePath, dexFile);
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while loading boot class path files. Aborting.");
                ex.printStackTrace(System.err);
                System.exit(1);
            }
        }
        if (!(outputDirectoryFile = new File(outputDirectory)).exists() && !outputDirectoryFile.mkdirs()) {
            System.err.println("Can't create the output directory " + outputDirectory);
            System.exit(1);
        }
        InputStream templateStream = baksmali.class.getClassLoader().getResourceAsStream("templates/baksmali.stg");
        StringTemplateGroup templates = new StringTemplateGroup(new InputStreamReader(templateStream));
        templates.registerRenderer(Long.class, new LongRenderer());
        templates.registerRenderer(Integer.class, new IntegerRenderer());
        templates.registerRenderer(Short.class, new ShortRenderer());
        templates.registerRenderer(Byte.class, new ByteRenderer());
        templates.registerRenderer(Float.class, new FloatRenderer());
        templates.registerRenderer(Character.class, new CharRenderer());
        templates.registerRenderer(StringIdItem.class, new StringIdItemRenderer());
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            String classDescriptor = classDefItem.getClassType().getTypeDescriptor();
            if (classDescriptor.charAt(0) != 'L' || classDescriptor.charAt(classDescriptor.length() - 1) != ';') {
                System.err.println("Unrecognized class descriptor - " + classDescriptor + " - skipping class");
                continue;
            }
            classDescriptor = classDescriptor.substring(1, classDescriptor.length() - 1);
            String[] pathElements = classDescriptor.split("/");
            StringBuilder smaliPath = new StringBuilder(outputDirectory);
            for (String pathElement : pathElements) {
                smaliPath.append(File.separatorChar);
                smaliPath.append(pathElement);
            }
            smaliPath.append(".smali");
            File smaliFile = new File(smaliPath.toString());
            ClassDefinition classDefinition = new ClassDefinition(templates, classDefItem);
            StringTemplate smaliFileST = classDefinition.createTemplate();
            String output = smaliFileST.toString();
            OutputStreamWriter writer = null;
            try {
                File smaliParent = smaliFile.getParentFile();
                if (!smaliParent.exists() && !smaliParent.mkdirs()) {
                    System.err.println("Unable to create directory " + smaliParent.toString() + " - skipping class");
                    continue;
                }
                if (!smaliFile.exists() && !smaliFile.createNewFile()) {
                    System.err.println("Unable to create file " + smaliFile.toString() + " - skipping class");
                    continue;
                }
                writer = new FileWriter(smaliFile);
                writer.write(output);
            }
            catch (Exception ex) {
                System.err.println("\n\nError occured while disassembling class " + classDescriptor.replace('/', '.') + " - skipping class");
                ex.printStackTrace();
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (Throwable ex) {
                    System.err.println("\n\nError occured while closing file " + smaliFile.toString());
                    ex.printStackTrace();
                }
                continue;
            }
            if (!classDefinition.hadValidationErrors()) continue;
            System.exit(1);
        }
    }
}

