/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.jsafe.a8;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class Utils {
    public static int DSA_BLOCK_SIZE = 20;
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final PrintWriter STDOUT = new PrintWriter(System.out, true);

    protected Utils() {
    }

    public static void assertTrue(String string, boolean bl2) {
        if (!bl2) {
            Utils.fail(string);
        }
    }

    public static void assertTrue(boolean bl2) {
        Utils.assertTrue(null, bl2);
    }

    public static void fail(String string) {
        throw new a8(string);
    }

    public static void fail() {
        Utils.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Utils.a(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        Utils.assertEquals(null, object, object2);
    }

    public static void assertEquals(String string, double d2, double d3, double d4) {
        if (Double.isInfinite(d2)) {
            if (d2 != d3) {
                Utils.a(string, new Double(d2), new Double(d3));
            }
        } else if (!(Math.abs(d2 - d3) <= d4)) {
            Utils.a(string, new Double(d2), new Double(d3));
        }
    }

    public static void assertEquals(double d2, double d3, double d4) {
        Utils.assertEquals(null, d2, d3, d4);
    }

    public static void assertEquals(String string, float f2, float f3, float f4) {
        if (Float.isInfinite(f2)) {
            if (f2 != f3) {
                Utils.a(string, new Float(f2), new Float(f3));
            }
        } else if (!(Math.abs(f2 - f3) <= f4)) {
            Utils.a(string, new Float(f2), new Float(f3));
        }
    }

    public static void assertEquals(float f2, float f3, float f4) {
        Utils.assertEquals(null, f2, f3, f4);
    }

    public static void assertEquals(String string, long l2, long l3) {
        Utils.assertEquals(string, new Long(l2), new Long(l3));
    }

    public static void assertEquals(long l2, long l3) {
        Utils.assertEquals(null, l2, l3);
    }

    public static void assertEquals(String string, boolean bl2, boolean bl3) {
        Utils.assertEquals(string, new Boolean(bl2), new Boolean(bl3));
    }

    public static void assertEquals(boolean bl2, boolean bl3) {
        Utils.assertEquals(null, bl2, bl3);
    }

    public static void assertEquals(String string, byte by2, byte by3) {
        Utils.assertEquals(string, new Byte(by2), new Byte(by3));
    }

    public static void assertEquals(byte by2, byte by3) {
        Utils.assertEquals(null, by2, by3);
    }

    public static void assertEquals(String string, char c2, char c3) {
        Utils.assertEquals(string, new Character(c2), new Character(c3));
    }

    public static void assertEquals(char c2, char c3) {
        Utils.assertEquals(null, c2, c3);
    }

    public static void assertEquals(String string, short s2, short s3) {
        Utils.assertEquals(string, new Short(s2), new Short(s3));
    }

    public static void assertEquals(short s2, short s3) {
        Utils.assertEquals(null, s2, s3);
    }

    public static void assertEquals(String string, int n2, int n3) {
        Utils.assertEquals(string, new Integer(n2), new Integer(n3));
    }

    public static void assertEquals(int n2, int n3) {
        Utils.assertEquals(null, n2, n3);
    }

    public static void assertNotNull(Object object) {
        Utils.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        Utils.assertTrue(string, object != null);
    }

    public static void assertNull(Object object) {
        Utils.assertNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        Utils.assertTrue(string, object == null);
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        Utils.b(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        Utils.assertSame(null, object, object2);
    }

    private static void a(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Utils.fail(string2 + "expected:<" + object + "> but was:<" + object2 + ">");
    }

    private static void b(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Utils.fail(string2 + "expected same");
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2) {
        Utils.assertEquals(null, byArray, byArray2);
    }

    public static void assertEquals(String string, byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return;
        }
        if (byArray != null && Utils.equals(byArray, byArray2)) {
            return;
        }
        Utils.a(string, byArray, byArray2);
    }

    public static void assertEquals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        Utils.assertEquals(null, byArray, n2, n3, byArray2, n4, n5);
    }

    public static void assertEquals(String string, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (byArray == null && byArray2 == null) {
            return;
        }
        if (byArray != null && Utils.equals(byArray, n2, n3, byArray2, n4, n5)) {
            return;
        }
        Utils.a(string, byArray, n2, n3, byArray2, n4, n5);
    }

    public static void assertNotEquals(String string, byte[] byArray, byte[] byArray2) {
        if (!Utils.equals(byArray, byArray2)) {
            return;
        }
        String string2 = Utils.byteBufferToHexString(byArray, 0, byArray.length, false);
        String string3 = Utils.byteBufferToHexString(byArray2, 0, byArray2.length, false);
        Utils.c(string, string2, string3);
    }

    private static void c(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " - ";
        }
        Utils.fail(string2 + "Not expected:<" + object + "> yet it was:<" + object2 + ">");
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        return Utils.equals(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static boolean equals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (n3 != n5) {
            return false;
        }
        while (n2 < n3) {
            if (byArray[n2] != byArray2[n4]) {
                return false;
            }
            ++n2;
            ++n4;
        }
        return true;
    }

    private static void a(String string, byte[] byArray, byte[] byArray2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        String string3 = Utils.byteBufferToHexString(byArray, 0, byArray.length, false);
        String string4 = Utils.byteBufferToHexString(byArray2, 0, byArray2.length, false);
        Utils.fail(string2 + "expected:<" + string3 + "> but was:<" + string4 + ">");
    }

    private static void a(String string, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        String string3 = Utils.byteBufferToHexString(byArray, n2, n3, false);
        String string4 = Utils.byteBufferToHexString(byArray2, n4, n5, false);
        Utils.fail(string2 + "expected:<" + string3 + "> but was:<" + string4 + ">");
    }

    public static String byteBufferToHexString(byte[] byArray, int n2, int n3, boolean bl2) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return Utils.byteBufferToHexString(byArray2, bl2);
    }

    public static String byteBufferToHexString(byte[] byArray, boolean bl2) {
        String string = "";
        int n2 = 0;
        int n3 = byArray.length;
        while (n3 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < 8 && n3 != 0) {
                int n5 = byArray[n2] & 0xFF;
                String string2 = Integer.toHexString(n5);
                if (bl2) {
                    stringBuffer = string2.length() == 1 ? stringBuffer.append(" 0x0") : stringBuffer.append(" 0x");
                }
                stringBuffer = stringBuffer.append(string2);
                if (bl2 && --n3 != 0) {
                    stringBuffer = stringBuffer.append(",");
                }
                ++n4;
                ++n2;
            }
            string = string + stringBuffer.toString();
        }
        return string;
    }

    public static byte[] hexStringToByteArray(String string) {
        if (string.equals("")) {
            return new byte[0];
        }
        byte[] byArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        if (string2.substring(0, 2).equals("0x")) {
            string2 = string2.substring(2);
        }
        byArray = new byte[(string2.length() + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (string2.length() % 2 != 0) {
            try {
                byArray[0] = Byte.parseByte("0" + string2.substring(0, 1), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n2 = 1;
            n3 = 1;
        }
        try {
            while (n2 < byArray.length) {
                byte by2;
                byArray[n2] = by2 = Byte.parseByte(string2.substring(n3, n3 + 1), 16);
                byArray[n2] = (byte)(byArray[n2] * 16);
                byte by3 = Byte.parseByte(string2.substring(n3 + 1, n3 + 2), 16);
                byArray[n2] = (byte)(byArray[n2] + by3);
                ++n2;
                n3 += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = byArray[n3] & 0xFF;
            String string = Integer.toHexString(n4);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
            --n2;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n2;
        while (n3 > 0) {
            int n5 = byArray[n4] & 0xFF;
            String string = Integer.toHexString(n5);
            if (string.length() == 1) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer = stringBuffer.append(string);
            --n3;
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static byte[] getBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static byte[] berEncodeDSASignature(byte[] byArray) throws Throwable {
        byte[] byArray2 = new byte[DSA_BLOCK_SIZE];
        byte[] byArray3 = new byte[DSA_BLOCK_SIZE];
        System.arraycopy(byArray, 0, byArray2, 0, DSA_BLOCK_SIZE);
        System.arraycopy(byArray, DSA_BLOCK_SIZE, byArray3, 0, DSA_BLOCK_SIZE);
        return Utils.doBEREncodeDSASignature(byArray2, byArray3);
    }

    public static byte[] doBEREncodeDSASignature(byte[] byArray, byte[] byArray2) throws Throwable {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
        IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray2, 0, byArray2.length, true);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
        return ASN1.derEncode(aSN1ContainerArray);
    }

    public static byte[] berDecodeDSASignature(byte[] byArray) throws Exception {
        byte[][] byArray2 = Utils.doBERDecodeDSASignature(byArray);
        byte[] byArray3 = new byte[2 * DSA_BLOCK_SIZE];
        System.arraycopy(byArray2[0], 0, byArray3, 0, DSA_BLOCK_SIZE);
        System.arraycopy(byArray2[1], 0, byArray3, DSA_BLOCK_SIZE, DSA_BLOCK_SIZE);
        return byArray3;
    }

    public static byte[][] doBERDecodeDSASignature(byte[] byArray) throws Exception {
        byte[][] byArrayArray = new byte[][]{new byte[DSA_BLOCK_SIZE], new byte[DSA_BLOCK_SIZE]};
        byte[] byArray2 = byArrayArray[0];
        byte[] byArray3 = byArrayArray[1];
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, 0);
            IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, 0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
            int n2 = ASN1.berDecode(byArray, 0, aSN1ContainerArray);
            int n3 = integerContainer.dataOffset + integerContainer.dataLen - 1;
            int n4 = DSA_BLOCK_SIZE - 1;
            while (n4 >= 0) {
                if (n3 >= integerContainer.dataOffset) {
                    byArray2[n4] = integerContainer.data[n3];
                }
                --n4;
                --n3;
            }
            n4 = integerContainer2.dataOffset + integerContainer2.dataLen - 1;
            int n5 = DSA_BLOCK_SIZE - 1;
            while (n5 >= 0) {
                if (n4 >= integerContainer2.dataOffset) {
                    byArray3[n5] = integerContainer2.data[n4];
                }
                --n5;
                --n4;
            }
            byte[][] byArrayArray2 = byArrayArray;
            return byArrayArray2;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new Exception(aSN_Exception.toString());
        }
    }
}

