/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Vector;

public class Controls
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    private ASN1Template b;
    private CertPathCtx c;
    private CertJ d;
    private JSAFE_PublicKey e = null;
    private JSAFE_PrivateKey f = null;

    public void decodeControls(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Controls encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                Control control = Control.getInstance(aSN1Container.data, aSN1Container.dataOffset, 0, this.d, this.c, this.e, this.f);
                this.a.addElement(control);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER of the Controls.");
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Controls Encoding is null.");
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding.");
        }
    }

    public int getDERLen(int n2) throws CRMFException {
        return this.a(n2);
    }

    private int a(int n2) throws CRMFException {
        this.special = n2;
        try {
            OfContainer ofContainer = new OfContainer(n2, true, 0, 12288, new EncodedContainer(12288));
            int n3 = this.a.size();
            if (n3 == 0) {
                return 2;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                Control control = (Control)this.a.elementAt(i2);
                int n4 = control.getDERLen(0);
                byte[] byArray = new byte[n4];
                n4 = control.getDEREncoding(byArray, 0, 0);
                EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n4);
                ofContainer.addContainer(encodedContainer);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode Controls. " + aSN_Exception.getMessage());
        }
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified Controls array is null.");
        }
        if ((this.b == null || n3 != this.special) && this.a(n3) == 0) {
            throw new CRMFException("Cannot compute the DER of the Controls");
        }
        if (this.a.size() == 0) {
            byArray[n2] = -96;
            byArray[n2 + 1] = 0;
            return 2;
        }
        try {
            return this.b.derEncode(byArray, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode Controls. " + aSN_Exception.getMessage());
        }
    }

    public int addControl(Control control) throws CRMFException {
        if (control == null) {
            throw new CRMFException("Specified Control is null.");
        }
        this.a.addElement(control);
        return this.a.indexOf(control);
    }

    public int getControlCount() {
        return this.a.size();
    }

    public Control getControlByIndex(int n2) throws CRMFException {
        if (n2 >= this.a.size()) {
            throw new CRMFException("Specified Controls index is invalid.");
        }
        try {
            return (Control)((Control)this.a.elementAt(n2)).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Cannot get specified Control. " + cloneNotSupportedException.getMessage());
        }
    }

    public Control getControlByType(int n2) {
        if (this.a.size() == 0) {
            return null;
        }
        try {
            int n3 = this.getControlCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                Control control = this.getControlByIndex(i2);
                if (control.getControlType() != n2) continue;
                return control;
            }
        }
        catch (CRMFException cRMFException) {
            return null;
        }
        return null;
    }

    public Control getControlByOID(byte[] byArray) {
        if (this.a.size() == 0) {
            return null;
        }
        try {
            int n2 = this.getControlCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Control control = this.getControlByIndex(i2);
                if (!control.compareOID(byArray)) continue;
                return control;
            }
        }
        catch (CRMFException cRMFException) {
            return null;
        }
        return null;
    }

    public void setEnvironment(CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        this.d = certJ;
        this.c = certPathCtx;
        if (jSAFE_PublicKey != null) {
            this.e = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.f = jSAFE_PrivateKey;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Controls controls = new Controls();
        try {
            controls.setEnvironment(this.d, this.c, this.e, this.f);
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Control control = (Control)this.getControlByIndex(i2).clone();
                controls.addControl(control);
            }
            if (this.b != null) {
                controls.getDERLen(this.special);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return controls;
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null || !(object instanceof Controls)) {
            return false;
        }
        Controls controls = (Controls)object;
        int n3 = this.a.size();
        if (n3 != (n2 = controls.a.size())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(this.a.elementAt(i2) != null ? !this.a.elementAt(i2).equals(controls.a.elementAt(i2)) : controls.a.elementAt(i2) != null)) continue;
            return false;
        }
        return true;
    }
}

