/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.argv;

import com.adobe.argv.UsageError;

public class Arguments {
    private String[] m_args;
    private int m_index = 0;

    public Arguments(String[] args) {
        this.m_args = args;
    }

    public boolean peek() {
        return this.m_index < this.m_args.length;
    }

    public boolean peek(String v2) {
        return this.peek() && this.m_args[this.m_index].equals(v2);
    }

    public String next() {
        if (this.peek()) {
            return this.m_args[this.m_index];
        }
        return null;
    }

    public String accept() throws UsageError {
        if (!this.peek()) {
            throw new UsageError("not enough arguments");
        }
        return this.m_args[this.m_index++];
    }

    public void accept(String v2) throws UsageError {
        if (!this.peek()) {
            throw new UsageError("not enough arguments");
        }
        if (!this.peek(v2)) {
            throw new UsageError("expected " + v2 + " instead of " + this.m_args[this.m_index]);
        }
        ++this.m_index;
    }

    public boolean acceptEquals(String v2) throws UsageError {
        if (!this.peek()) {
            throw new UsageError("not enough arguments");
        }
        if (this.peek(v2)) {
            ++this.m_index;
            return true;
        }
        return false;
    }

    public boolean seek(String v2) {
        int original = this.m_index;
        while (this.peek()) {
            if (this.peek(v2)) {
                return true;
            }
            ++this.m_index;
        }
        this.m_index = original;
        return false;
    }

    public void reset() {
        this.m_index = 0;
    }

    public void done() throws UsageError {
        if (this.m_index != this.m_args.length) {
            throw new UsageError("too many arguments");
        }
    }
}

