/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator10
extends ApplicationDescriptorValidator {
    private final ApplicationDescriptorValidator.ElementInfo ROOT_ELEMENT_INFO;
    private String _id;
    private String _version;
    private String _filename = null;
    private String _name = null;
    private String _copyright = null;
    private String _initialWindowTitle = null;
    private String _initialContent;
    private Boolean _visible;
    private String _systemChrome = "standard";
    private boolean _transparent = false;
    protected Map<Integer, String> _appIcons = new HashMap<Integer, String>();
    protected Set<String> _fileExtensions = new HashSet<String>();
    private int[] _minSize;
    private int[] _maxSize;

    public ApplicationDescriptorValidator10() {
        this.ROOT_ELEMENT_INFO = this.createElementInfoTree();
    }

    protected ApplicationDescriptorValidator.ElementInfo createElementInfoTree() {
        ApplicationDescriptorValidator.ElementInfo root = new ApplicationDescriptorValidator.ElementInfo("application", 1, 1);
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("id", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("version", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("filename", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("name", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("description", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("copyright", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("initialWindow", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("installFolder", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("programMenuFolder", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("icon", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("customUpdateUI", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("fileTypes", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("allowBrowserInvocation", 0, 1));
        root.addAttribute(new ApplicationDescriptorValidator.AttributeInfo("minimumPatchLevel", false));
        ApplicationDescriptorValidator.ElementInfo temp = root.getChild("initialWindow");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("content", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("title", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("systemChrome", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("transparent", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("visible", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("minimizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("maximizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("resizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("closeable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("x", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("y", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("width", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("height", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("minSize", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("maxSize", 0, 1));
        temp = root.getChild("fileTypes");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("fileType", 0, -1));
        temp = temp.getChild("fileType");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("name", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("extension", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("description", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("contentType", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("icon", 0, 1));
        temp = temp.getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image16x16", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image32x32", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image48x48", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image128x128", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image16x16", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image32x32", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image48x48", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image128x128", 0, 1));
        return root;
    }

    @Override
    protected ApplicationDescriptorValidator.ElementInfo getRootElementInfo() {
        return this.ROOT_ELEMENT_INFO;
    }

    @Override
    protected boolean validateAttribute(String attributePath, String value) {
        if (attributePath.equals("application@minimumPatchLevel")) {
            return ApplicationDescriptorValidator.validateUnsignedIntType(value);
        }
        return true;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        String imageUri;
        boolean valid = true;
        if (elementPath.equals("application.id")) {
            this._id = value;
            return ApplicationDescriptorValidator.validateAppId(value);
        }
        if (elementPath.equals("application.version")) {
            this._version = value;
            return !value.equals("");
        }
        if (elementPath.equals("application.filename")) {
            this._filename = value;
            valid = ApplicationDescriptorValidator.validateFilename(value);
        }
        if (elementPath.equals("application.name")) {
            this._name = value;
        }
        if (elementPath.equals("application.copyright")) {
            this._copyright = value;
        }
        if (elementPath.equals("application.installFolder") || elementPath.equals("application.programMenuFolder")) {
            valid = ApplicationDescriptorValidator.validateFolderType(value);
        }
        if (elementPath.equals("application.initialWindow.visible")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._visible = ApplicationDescriptorValidator10.evaluateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.title")) {
            this._initialWindowTitle = value;
        }
        if (elementPath.equals("application.initialWindow.transparent")) {
            this._transparent = ApplicationDescriptorValidator10.evaluateBooleanType(value);
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.minimizable") || elementPath.equals("application.initialWindow.maximizable") || elementPath.equals("application.initialWindow.resizable") || elementPath.equals("application.initialWindow.closeable") || elementPath.equals("application.customUpdateUI") || elementPath.equals("application.allowBrowserInvocation")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.systemChrome")) {
            this._systemChrome = value;
            valid = ApplicationDescriptorValidator.validateSystemChrome(value);
        }
        if (elementPath.equals("application.initialWindow.width") || elementPath.equals("application.initialWindow.height")) {
            valid = ApplicationDescriptorValidator.validateUnsignedIntType(value);
        }
        if (elementPath.equals("application.initialWindow.x") || elementPath.equals("application.initialWindow.y")) {
            valid = ApplicationDescriptorValidator.validateSignedIntType(value);
        }
        if (elementPath.equals("application.initialWindow.minSize") || elementPath.equals("application.initialWindow.maxSize")) {
            valid = ApplicationDescriptorValidator.validateUnsignedIntPairType(value);
        }
        if (elementPath.equals("application.fileTypes.fileType.name")) {
            valid = ApplicationDescriptorValidator.validateFileTypeName(value);
        }
        if (elementPath.equals("application.fileTypes.fileType.extension") && (valid = ApplicationDescriptorValidator.validateExtension(value))) {
            valid = this._fileExtensions.add(value);
        }
        if (elementPath.equals("application.initialWindow.content")) {
            this._initialContent = this.validateRootContentURI(value);
            boolean bl2 = valid = this._initialContent != null;
        }
        if (valid) {
            String[] list;
            if (elementPath.equals("application.initialWindow.minSize")) {
                this._minSize = new int[2];
                list = value.split("\\s+");
                this._minSize[0] = Integer.parseInt(list[0]);
                this._minSize[1] = Integer.parseInt(list[1]);
                if (this._maxSize != null && (this._minSize[0] > this._maxSize[0] || this._minSize[1] > this._maxSize[1])) {
                    this.dispatchError(107, new String[]{elementPath});
                }
            }
            if (elementPath.equals("application.initialWindow.maxSize")) {
                this._maxSize = new int[2];
                list = value.split("\\s+");
                this._maxSize[0] = Integer.parseInt(list[0]);
                this._maxSize[1] = Integer.parseInt(list[1]);
                if (this._minSize != null && (this._minSize[0] > this._maxSize[0] || this._minSize[1] > this._maxSize[1])) {
                    this.dispatchError(107, null);
                }
            }
        }
        if (elementPath.equals("application.icon.image16x16") || elementPath.equals("application.icon.image32x32") || elementPath.equals("application.icon.image48x48") || elementPath.equals("application.icon.image128x128")) {
            int size = this.getIntFromIconSize(elementPath);
            imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(size, imageUri);
        }
        if (elementPath.equals("application.fileTypes.fileType.icon.image16x16") || elementPath.equals("application.fileTypes.fileType.icon.image32x32") || elementPath.equals("application.fileTypes.fileType.icon.image48x48") || elementPath.equals("application.fileTypes.fileType.icon.image128x128")) {
            int size = this.getIntFromIconSize(elementPath);
            imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
        }
        return valid;
    }

    @Override
    protected void finalizeValidation() throws SAXException {
        if (this._transparent && !this._systemChrome.equals("none")) {
            this.dispatchError(106, null);
        }
    }

    @Override
    protected int getMaximumSWFVersion() {
        return 9;
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/1.0";
    }

    protected int getIntFromIconSize(String size) {
        return Integer.parseInt(size.substring(size.lastIndexOf(120) + 1));
    }

    public Map<Integer, String> appIcons() {
        return this._appIcons;
    }

    public String id() {
        return this._id;
    }

    public String version() {
        return this._version;
    }

    public String filename() {
        return this._filename;
    }

    public String name() {
        return this._name;
    }

    public String copyright() {
        return this._copyright;
    }

    public String initialWindowTitle() {
        return this._initialWindowTitle;
    }

    public String initialContent() {
        return this._initialContent;
    }

    public Boolean visible() {
        return this._visible;
    }

    public String systemChrome() {
        return this._systemChrome;
    }

    public Boolean transparent() {
        return this._transparent;
    }
}

