/*
 * Decompiled with CFR 0.152.
 */
package antlr.debug;

import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.debug.InputBufferEventSupport;
import antlr.debug.InputBufferListener;
import java.util.Vector;

public class DebuggingInputBuffer
extends InputBuffer {
    private InputBuffer buffer;
    private InputBufferEventSupport inputBufferEventSupport;
    private boolean debugMode = true;

    public DebuggingInputBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void addInputBufferListener(InputBufferListener inputBufferListener) {
        this.inputBufferEventSupport.addInputBufferListener(inputBufferListener);
    }

    public void consume() {
        char c2 = ' ';
        try {
            c2 = this.buffer.LA(1);
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
        this.buffer.consume();
        if (this.debugMode) {
            this.inputBufferEventSupport.fireConsume(c2);
        }
    }

    public void fill(int n2) throws CharStreamException {
        this.buffer.fill(n2);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferEventSupport.getInputBufferListeners();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isMarked() {
        return this.buffer.isMarked();
    }

    public char LA(int n2) throws CharStreamException {
        char c2 = this.buffer.LA(n2);
        if (this.debugMode) {
            this.inputBufferEventSupport.fireLA(c2, n2);
        }
        return c2;
    }

    public int mark() {
        int n2 = this.buffer.mark();
        this.inputBufferEventSupport.fireMark(n2);
        return n2;
    }

    public void removeInputBufferListener(InputBufferListener inputBufferListener) {
        if (this.inputBufferEventSupport != null) {
            this.inputBufferEventSupport.removeInputBufferListener(inputBufferListener);
        }
    }

    public void rewind(int n2) {
        this.buffer.rewind(n2);
        this.inputBufferEventSupport.fireRewind(n2);
    }

    public void setDebugMode(boolean bl2) {
        this.debugMode = bl2;
    }
}

