/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public final class Leb128Utils {
    private Leb128Utils() {
    }

    public static int unsignedLeb128Size(int value) {
        int remaining = value >>> 7;
        int count = 0;
        while (remaining != 0) {
            value = remaining;
            remaining >>>= 7;
            ++count;
        }
        return count + 1;
    }

    public static int signedLeb128Size(int value) {
        int end;
        int remaining = value >> 7;
        int count = 0;
        boolean hasMore = true;
        int n2 = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            value = remaining;
            remaining >>= 7;
            ++count;
        }
        return count;
    }

    public static void writeUnsignedLeb128(int value, byte[] buffer, int bufferIndex) {
        int remaining = value >>> 7;
        int count = 0;
        while (remaining != 0) {
            buffer[bufferIndex] = (byte)(value & 0x7F | 0x80);
            ++bufferIndex;
            value = remaining;
            remaining >>>= 7;
            ++count;
        }
        buffer[bufferIndex] = (byte)(value & 0x7F);
    }
}

