/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

public class ByteArrayInput
implements Input {
    private byte[] data;
    private int cursor;

    public ByteArrayInput(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        this.data = data;
        this.cursor = 0;
    }

    public byte[] getArray() {
        return this.data;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCursor(int cursor) {
        if (cursor < 0 || cursor >= this.data.length) {
            throw new IndexOutOfBoundsException("The provided cursor value is not within the bounds of this instance's data array");
        }
        this.cursor = cursor;
    }

    public void assertCursor(int expectedCursor) {
        if (this.cursor != expectedCursor) {
            throw new ExceptionWithContext("expected cursor " + expectedCursor + "; actual value: " + this.cursor);
        }
    }

    public byte readByte() {
        int readAt = this.cursor;
        int end = readAt + 1;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
        return this.data[readAt];
    }

    public int readShort() {
        int readAt = this.cursor;
        int end = readAt + 2;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
        return (this.data[readAt] & 0xFF) + ((this.data[readAt + 1] & 0xFF) << 8);
    }

    public int readInt() {
        int readAt = this.cursor;
        int end = readAt + 4;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
        return (this.data[readAt] & 0xFF) + ((this.data[readAt + 1] & 0xFF) << 8) + ((this.data[readAt + 2] & 0xFF) << 16) + ((this.data[readAt + 3] & 0xFF) << 24);
    }

    public long readLong() {
        int readAt = this.cursor;
        int end = readAt + 8;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
        return (long)this.data[readAt] & 0xFFL | ((long)this.data[readAt + 1] & 0xFFL) << 8 | ((long)this.data[readAt + 2] & 0xFFL) << 16 | ((long)this.data[readAt + 3] & 0xFFL) << 24 | ((long)this.data[readAt + 4] & 0xFFL) << 32 | ((long)this.data[readAt + 5] & 0xFFL) << 40 | ((long)this.data[readAt + 6] & 0xFFL) << 48 | ((long)this.data[readAt + 7] & 0xFFL) << 58;
    }

    public int readUnsignedOrSignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) > 127) {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        } else {
            this.cursor = end;
            return result;
        }
        this.cursor = end;
        if (this.data[end - 1] == 0) {
            return ~result;
        }
        return result;
    }

    public int readUnsignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) > 127) {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.cursor = end;
        return result;
    }

    public int readSignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) <= 127) {
            result = result << 25 >> 25;
        } else {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue <= 127) {
                result = result << 18 >> 18;
            } else {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue <= 127) {
                    result = result << 11 >> 11;
                } else {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue <= 127) {
                        result = result << 4 >> 4;
                    } else {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.cursor = end;
        return result;
    }

    public void read(byte[] bytes, int offset, int length) {
        int end = this.cursor + length;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        System.arraycopy(this.data, this.cursor, bytes, offset, length);
        this.cursor = end;
    }

    public void read(byte[] bytes) {
        int length = bytes.length;
        int end = this.cursor + length;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        System.arraycopy(this.data, this.cursor, bytes, 0, length);
        this.cursor = end;
    }

    public byte[] readBytes(int length) {
        int end = this.cursor + length;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        byte[] result = new byte[length];
        System.arraycopy(this.data, this.cursor, result, 0, length);
        this.cursor = end;
        return result;
    }

    public byte[] readNullTerminatedBytes() {
        int startPosition = this.cursor;
        while (this.data[this.cursor] != 0) {
            ++this.cursor;
            if (this.cursor < this.data.length) continue;
            ByteArrayInput.throwBounds();
        }
        int byteCount = this.cursor - startPosition;
        ++this.cursor;
        byte[] result = new byte[byteCount];
        System.arraycopy(this.data, startPosition, result, 0, byteCount);
        return result;
    }

    public void skipBytes(int count) {
        int end = this.cursor + count;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
    }

    public void alignTo(int alignment) {
        int end = AlignmentUtils.alignOffset(this.cursor, alignment);
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = end;
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to read past the end");
    }

    private static void throwInvalidLeb() {
        throw new RuntimeException("invalid LEB128 integer encountered");
    }
}

