/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemFactory;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.Util.Hex;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsettedSection<T extends Item>
extends Section<T> {
    public OffsettedSection(DexFile dexFile, ItemType itemType) {
        super(dexFile, itemType);
    }

    @Override
    public void readItems(Input in, ReadContext readContext) {
        SparseArray precreatedItems = readContext.getItemsByType(this.ItemType);
        assert (precreatedItems.size() <= this.items.size()) : "Trying to read " + this.items.size() + " items, but this section " + "already contains " + precreatedItems.size() + " items.";
        int precreatedIndex = 0;
        int nextPrecreatedOffset = Integer.MAX_VALUE;
        if (precreatedItems.size() > 0) {
            nextPrecreatedOffset = precreatedItems.keyAt(0);
        }
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            assert (this.items.get(i2) == null);
            Item item = null;
            in.alignTo(this.ItemType.ItemAlignment);
            int currentOffset = in.getCursor();
            if (currentOffset == nextPrecreatedOffset) {
                item = (Item)precreatedItems.valueAt(precreatedIndex++);
                nextPrecreatedOffset = precreatedIndex < precreatedItems.size() ? precreatedItems.keyAt(precreatedIndex) : Integer.MAX_VALUE;
            } else {
                if (currentOffset > nextPrecreatedOffset) {
                    throw new RuntimeException("The pre-created item at offset 0x" + Hex.u4(nextPrecreatedOffset) + " was not read");
                }
                item = ItemFactory.makeItem(this.ItemType, this.DexFile);
            }
            this.items.set(i2, item);
            item.readFrom(in, i2, readContext);
        }
        readContext.setItemsForSection(this.ItemType, this.items);
    }
}

