/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Debug;

import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.Input;

public class DebugInstructionIterator {
    public static void IterateInstructions(Input in, ProcessRawDebugInstructionDelegate processDebugInstruction) {
        block12: while (true) {
            int startDebugOffset = in.getCursor();
            byte debugOpcode = in.readByte();
            switch (debugOpcode) {
                case 0: {
                    processDebugInstruction.ProcessEndSequence(startDebugOffset);
                    return;
                }
                case 1: {
                    int codeAddressDiff = in.readUnsignedLeb128();
                    processDebugInstruction.ProcessAdvancePC(startDebugOffset, in.getCursor() - startDebugOffset, codeAddressDiff);
                    continue block12;
                }
                case 2: {
                    int lineDiff = in.readSignedLeb128();
                    processDebugInstruction.ProcessAdvanceLine(startDebugOffset, in.getCursor() - startDebugOffset, lineDiff);
                    continue block12;
                }
                case 3: {
                    int registerNum = in.readUnsignedOrSignedLeb128();
                    boolean isSignedRegister = false;
                    if (registerNum < 0) {
                        isSignedRegister = true;
                        registerNum ^= 0xFFFFFFFF;
                    }
                    int nameIndex = in.readUnsignedLeb128() - 1;
                    int typeIndex = in.readUnsignedLeb128() - 1;
                    processDebugInstruction.ProcessStartLocal(startDebugOffset, in.getCursor() - startDebugOffset, registerNum, nameIndex, typeIndex, isSignedRegister);
                    continue block12;
                }
                case 4: {
                    int registerNum = in.readUnsignedOrSignedLeb128();
                    boolean isSignedRegister = false;
                    if (registerNum < 0) {
                        isSignedRegister = true;
                        registerNum ^= 0xFFFFFFFF;
                    }
                    int nameIndex = in.readUnsignedLeb128() - 1;
                    int typeIndex = in.readUnsignedLeb128() - 1;
                    int signatureIndex = in.readUnsignedLeb128() - 1;
                    processDebugInstruction.ProcessStartLocalExtended(startDebugOffset, in.getCursor() - startDebugOffset, registerNum, nameIndex, typeIndex, signatureIndex, isSignedRegister);
                    continue block12;
                }
                case 5: {
                    int registerNum = in.readUnsignedOrSignedLeb128();
                    boolean isSignedRegister = false;
                    if (registerNum < 0) {
                        isSignedRegister = true;
                        registerNum ^= 0xFFFFFFFF;
                    }
                    processDebugInstruction.ProcessEndLocal(startDebugOffset, in.getCursor() - startDebugOffset, registerNum, isSignedRegister);
                    continue block12;
                }
                case 6: {
                    int registerNum = in.readUnsignedOrSignedLeb128();
                    boolean isSignedRegister = false;
                    if (registerNum < 0) {
                        isSignedRegister = true;
                        registerNum ^= 0xFFFFFFFF;
                    }
                    processDebugInstruction.ProcessRestartLocal(startDebugOffset, in.getCursor() - startDebugOffset, registerNum, isSignedRegister);
                    continue block12;
                }
                case 7: {
                    processDebugInstruction.ProcessSetPrologueEnd(startDebugOffset);
                    continue block12;
                }
                case 8: {
                    processDebugInstruction.ProcessSetEpilogueBegin(startDebugOffset);
                    continue block12;
                }
                case 9: {
                    int nameIndex = in.readUnsignedLeb128();
                    processDebugInstruction.ProcessSetFile(startDebugOffset, in.getCursor() - startDebugOffset, nameIndex);
                    continue block12;
                }
            }
            int base = (debugOpcode & 0xFF) - 10;
            processDebugInstruction.ProcessSpecialOpcode(startDebugOffset, debugOpcode, base % 15 - 4, base / 15);
        }
    }

    public static void DecodeInstructions(DebugInfoItem debugInfoItem, int registerCount, ProcessDecodedDebugInstructionDelegate processDecodedDebugInstruction) {
        int currentCodeAddress = 0;
        int line = debugInfoItem.getLineStart();
        ByteArrayInput in = new ByteArrayInput(debugInfoItem.getEncodedDebugInfo());
        DexFile dexFile = debugInfoItem.getDexFile();
        Local[] locals = new Local[registerCount];
        while (true) {
            int startDebugOffset = in.getCursor();
            byte debugOpcode = in.readByte();
            switch (DebugOpcode.getDebugOpcodeByValue(debugOpcode)) {
                case DBG_END_SEQUENCE: {
                    return;
                }
                case DBG_ADVANCE_PC: {
                    int codeAddressDiff = in.readUnsignedLeb128();
                    currentCodeAddress += codeAddressDiff;
                    break;
                }
                case DBG_ADVANCE_LINE: {
                    int lineDiff = in.readSignedLeb128();
                    line += lineDiff;
                    break;
                }
                case DBG_START_LOCAL: {
                    int registerNum = in.readUnsignedLeb128();
                    StringIdItem name = dexFile.StringIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    TypeIdItem type = dexFile.TypeIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    locals[registerNum] = new Local(registerNum, name, type, null);
                    processDecodedDebugInstruction.ProcessStartLocal(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, name, type);
                    break;
                }
                case DBG_START_LOCAL_EXTENDED: {
                    int registerNum = in.readUnsignedLeb128();
                    StringIdItem name = dexFile.StringIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    TypeIdItem type = dexFile.TypeIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    StringIdItem signature = dexFile.StringIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    locals[registerNum] = new Local(registerNum, name, type, signature);
                    processDecodedDebugInstruction.ProcessStartLocalExtended(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, name, type, signature);
                    break;
                }
                case DBG_END_LOCAL: {
                    int registerNum = in.readUnsignedLeb128();
                    Local local = locals[registerNum];
                    if (local == null) {
                        processDecodedDebugInstruction.ProcessEndLocal(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, null, null, null);
                        break;
                    }
                    processDecodedDebugInstruction.ProcessEndLocal(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, local.name, local.type, local.signature);
                    break;
                }
                case DBG_RESTART_LOCAL: {
                    int registerNum = in.readUnsignedLeb128();
                    Local local = locals[registerNum];
                    if (local == null) {
                        processDecodedDebugInstruction.ProcessRestartLocal(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, null, null, null);
                        break;
                    }
                    processDecodedDebugInstruction.ProcessRestartLocal(currentCodeAddress, in.getCursor() - startDebugOffset, registerNum, local.name, local.type, local.signature);
                    break;
                }
                case DBG_SET_PROLOGUE_END: {
                    processDecodedDebugInstruction.ProcessSetPrologueEnd(currentCodeAddress);
                    break;
                }
                case DBG_SET_EPILOGUE_BEGIN: {
                    processDecodedDebugInstruction.ProcessSetEpilogueBegin(currentCodeAddress);
                    break;
                }
                case DBG_SET_FILE: {
                    StringIdItem name = dexFile.StringIdsSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
                    processDecodedDebugInstruction.ProcessSetFile(currentCodeAddress, in.getCursor() - startDebugOffset, name);
                    break;
                }
                case DBG_SPECIAL_OPCODE: {
                    int base = (debugOpcode & 0xFF) - 10;
                    processDecodedDebugInstruction.ProcessLineEmit(currentCodeAddress += base / 15, line += base % 15 - 4);
                }
            }
        }
    }

    private static class Local {
        public final int register;
        public final StringIdItem name;
        public final TypeIdItem type;
        public final StringIdItem signature;

        public Local(int register, StringIdItem name, TypeIdItem type, StringIdItem signature) {
            this.register = register;
            this.name = name;
            this.type = type;
            this.signature = signature;
        }
    }

    public static class ProcessDecodedDebugInstructionDelegate {
        public void ProcessStartLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type) {
        }

        public void ProcessStartLocalExtended(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
        }

        public void ProcessEndLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
        }

        public void ProcessRestartLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
        }

        public void ProcessSetPrologueEnd(int codeAddress) {
        }

        public void ProcessSetEpilogueBegin(int codeAddress) {
        }

        public void ProcessSetFile(int codeAddress, int length, StringIdItem name) {
        }

        public void ProcessLineEmit(int codeAddress, int line) {
        }
    }

    public static class ProcessRawDebugInstructionDelegate {
        public void ProcessEndSequence(int startDebugOffset) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_END_SEQUENCE, startDebugOffset, 1);
        }

        public void ProcessAdvancePC(int startDebugOffset, int length, int codeAddressDiff) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_ADVANCE_PC, startDebugOffset, length);
        }

        public void ProcessAdvanceLine(int startDebugOffset, int length, int lineDiff) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_ADVANCE_LINE, startDebugOffset, length);
        }

        public void ProcessStartLocal(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, boolean registerIsSigned) {
        }

        public void ProcessStartLocalExtended(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, int signatureIndex, boolean registerIsSigned) {
        }

        public void ProcessEndLocal(int startDebugOffset, int length, int registerNum, boolean registerIsSigned) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_END_LOCAL, startDebugOffset, length);
        }

        public void ProcessRestartLocal(int startDebugOffset, int length, int registerNum, boolean registerIsSigned) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_RESTART_LOCAL, startDebugOffset, length);
        }

        public void ProcessSetPrologueEnd(int startDebugOffset) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SET_PROLOGUE_END, startDebugOffset, 1);
        }

        public void ProcessSetEpilogueBegin(int startDebugOffset) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SET_EPILOGUE_BEGIN, startDebugOffset, 1);
        }

        public void ProcessSetFile(int startDebugOffset, int length, int nameIndex) {
        }

        public void ProcessSpecialOpcode(int startDebugOffset, int debugOpcode, int lineDiff, int codeAddressDiff) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SPECIAL_OPCODE, startDebugOffset, 1);
        }

        public void ProcessStaticOpcode(DebugOpcode debugOpcode, int startDebugOffset, int length) {
        }
    }
}

