/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.baksmali;

public class LabelMethodItem
extends MethodItem {
    private final StringTemplateGroup stg;
    private final String labelPrefix;
    private int labelSequence;
    private boolean isCommentedOut = true;

    public LabelMethodItem(int codeAddress, StringTemplateGroup stg, String labelPrefix) {
        super(codeAddress);
        this.stg = stg;
        this.labelPrefix = labelPrefix;
    }

    public double getSortOrder() {
        return 0.0;
    }

    public boolean isCommentedOut() {
        return this.isCommentedOut;
    }

    public void setUncommented() {
        this.isCommentedOut = false;
    }

    public int compareTo(MethodItem methodItem) {
        int result = super.compareTo(methodItem);
        if (result == 0 && methodItem instanceof LabelMethodItem) {
            result = this.labelPrefix.compareTo(((LabelMethodItem)methodItem).labelPrefix);
        }
        return result;
    }

    public int hashCode() {
        return this.getCodeAddress();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof LabelMethodItem)) {
            return false;
        }
        return this.compareTo((MethodItem)o2) == 0;
    }

    public String toString() {
        StringTemplate template = this.stg.getInstanceOf("Label");
        template.setAttribute("Prefix", this.labelPrefix);
        if (baksmali.useSequentialLabels) {
            template.setAttribute("Suffix", Integer.toHexString(this.labelSequence));
        } else {
            template.setAttribute("Suffix", this.getLabelAddress());
        }
        return template.toString();
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getLabelAddress() {
        return Integer.toHexString(this.getCodeAddress());
    }

    public int getLabelSequence() {
        return this.labelSequence;
    }

    public void setLabelSequence(int labelSequence) {
        this.labelSequence = labelSequence;
    }
}

