/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedValueAdaptor;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.NullEncodedValue;
import org.jf.dexlib.Util.AccessFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDefinition {
    public static StringTemplate createTemplate(StringTemplateGroup stg, ClassDataItem.EncodedField encodedField, EncodedValue initialValue, AnnotationSetItem annotationSet, boolean setInStaticConstructor) {
        StringTemplate template = stg.getInstanceOf("field");
        String fieldTypeDescriptor = encodedField.field.getFieldType().getTypeDescriptor();
        template.setAttribute("AccessFlags", FieldDefinition.getAccessFlags(encodedField));
        template.setAttribute("FieldName", encodedField.field.getFieldName().getStringValue());
        template.setAttribute("FieldType", encodedField.field.getFieldType().getTypeDescriptor());
        template.setAttribute("Annotations", FieldDefinition.getAnnotations(stg, annotationSet));
        if (setInStaticConstructor && encodedField.isStatic() && (encodedField.accessFlags & AccessFlags.FINAL.getValue()) != 0 && initialValue != null && (fieldTypeDescriptor.length() == 1 || initialValue != NullEncodedValue.NullValue)) {
            template.setAttribute("Comments", (Object)new String[]{"the value of this static final field might be set in the static constructor"});
        } else {
            template.setAttribute("Comments", (Object)null);
        }
        if (initialValue != null) {
            template.setAttribute("InitialValue", EncodedValueAdaptor.create(stg, initialValue));
        }
        return template;
    }

    public static StringTemplate createTemplate(StringTemplateGroup stg, ClassDataItem.EncodedField encodedField, AnnotationSetItem annotationSet) {
        return FieldDefinition.createTemplate(stg, encodedField, null, annotationSet, false);
    }

    private static List<String> getAccessFlags(ClassDataItem.EncodedField encodedField) {
        ArrayList<String> accessFlags = new ArrayList<String>();
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForField(encodedField.accessFlags)) {
            accessFlags.add(accessFlag.toString());
        }
        return accessFlags;
    }

    private static List<StringTemplate> getAnnotations(StringTemplateGroup stg, AnnotationSetItem annotationSet) {
        if (annotationSet == null) {
            return null;
        }
        ArrayList<StringTemplate> annotationAdaptors = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSet.getAnnotations()) {
            annotationAdaptors.add(AnnotationAdaptor.createTemplate(stg, annotationItem));
        }
        return annotationAdaptors;
    }
}

