/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinition {
    private StringTemplateGroup stg;
    private ClassDefItem classDefItem;
    private ClassDataItem classDataItem;
    private SparseArray<AnnotationSetItem> methodAnnotationsMap;
    private SparseArray<AnnotationSetItem> fieldAnnotationsMap;
    private SparseArray<AnnotationSetRefList> parameterAnnotationsMap;
    private SparseArray<FieldIdItem> fieldsSetInStaticConstructor;
    protected boolean validationErrors;

    public ClassDefinition(StringTemplateGroup stg, ClassDefItem classDefItem) {
        this.stg = stg;
        this.classDefItem = classDefItem;
        this.classDataItem = classDefItem.getClassData();
        this.buildAnnotationMaps();
        this.findFieldsSetInStaticConstructor();
    }

    public StringTemplate createTemplate() {
        StringTemplate template = this.stg.getInstanceOf("smaliFile");
        template.setAttribute("AccessFlags", this.getAccessFlags());
        template.setAttribute("ClassType", this.classDefItem.getClassType().getTypeDescriptor());
        template.setAttribute("SuperType", this.getSuperType());
        template.setAttribute("SourceFile", this.getSourceFile());
        template.setAttribute("Interfaces", this.getInterfaces());
        template.setAttribute("Annotations", this.getAnnotations());
        template.setAttribute("StaticFields", this.getStaticFields());
        template.setAttribute("InstanceFields", this.getInstanceFields());
        template.setAttribute("DirectMethods", this.getDirectMethods());
        template.setAttribute("VirtualMethods", this.getVirtualMethods());
        return template;
    }

    public boolean hadValidationErrors() {
        return this.validationErrors;
    }

    private void buildAnnotationMaps() {
        AnnotationDirectoryItem annotationDirectory = this.classDefItem.getAnnotations();
        if (annotationDirectory == null) {
            this.methodAnnotationsMap = new SparseArray(0);
            this.fieldAnnotationsMap = new SparseArray(0);
            this.parameterAnnotationsMap = new SparseArray(0);
            return;
        }
        this.methodAnnotationsMap = new SparseArray(annotationDirectory.getMethodAnnotationCount());
        annotationDirectory.iterateMethodAnnotations(new AnnotationDirectoryItem.MethodAnnotationIteratorDelegate(){

            public void processMethodAnnotations(MethodIdItem method, AnnotationSetItem methodAnnotations) {
                ClassDefinition.this.methodAnnotationsMap.put(method.getIndex(), methodAnnotations);
            }
        });
        this.fieldAnnotationsMap = new SparseArray(annotationDirectory.getFieldAnnotationCount());
        annotationDirectory.iterateFieldAnnotations(new AnnotationDirectoryItem.FieldAnnotationIteratorDelegate(){

            public void processFieldAnnotations(FieldIdItem field, AnnotationSetItem fieldAnnotations) {
                ClassDefinition.this.fieldAnnotationsMap.put(field.getIndex(), fieldAnnotations);
            }
        });
        this.parameterAnnotationsMap = new SparseArray(annotationDirectory.getParameterAnnotationCount());
        annotationDirectory.iterateParameterAnnotations(new AnnotationDirectoryItem.ParameterAnnotationIteratorDelegate(){

            public void processParameterAnnotations(MethodIdItem method, AnnotationSetRefList parameterAnnotations) {
                ClassDefinition.this.parameterAnnotationsMap.put(method.getIndex(), parameterAnnotations);
            }
        });
    }

    private void findFieldsSetInStaticConstructor() {
        this.fieldsSetInStaticConstructor = new SparseArray();
        if (this.classDataItem == null) {
            return;
        }
        for (ClassDataItem.EncodedMethod directMethod : this.classDataItem.getDirectMethods()) {
            if (!directMethod.method.getMethodName().getStringValue().equals("<clinit>")) continue;
            for (Instruction instruction : directMethod.codeItem.getInstructions()) {
                switch (instruction.opcode) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c ins = (Instruction21c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)ins.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), fieldIdItem);
                    }
                }
            }
        }
    }

    private List<String> getAccessFlags() {
        ArrayList<String> accessFlags = new ArrayList<String>();
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForClass(this.classDefItem.getAccessFlags())) {
            accessFlags.add(accessFlag.toString());
        }
        return accessFlags;
    }

    private String getSuperType() {
        TypeIdItem superClass = this.classDefItem.getSuperclass();
        if (superClass != null) {
            return superClass.getTypeDescriptor();
        }
        return null;
    }

    private String getSourceFile() {
        StringIdItem sourceFile = this.classDefItem.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        return this.classDefItem.getSourceFile().getStringValue();
    }

    private List<String> getInterfaces() {
        ArrayList<String> interfaces = new ArrayList<String>();
        TypeListItem interfaceList = this.classDefItem.getInterfaces();
        if (interfaceList != null) {
            for (TypeIdItem typeIdItem : interfaceList.getTypes()) {
                interfaces.add(typeIdItem.getTypeDescriptor());
            }
        }
        return interfaces;
    }

    private List<StringTemplate> getAnnotations() {
        AnnotationDirectoryItem annotationDirectory = this.classDefItem.getAnnotations();
        if (annotationDirectory == null) {
            return null;
        }
        AnnotationSetItem annotationSet = annotationDirectory.getClassAnnotations();
        if (annotationSet == null) {
            return null;
        }
        ArrayList<StringTemplate> annotations = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSet.getAnnotations()) {
            annotations.add(AnnotationAdaptor.createTemplate(this.stg, annotationItem));
        }
        return annotations;
    }

    private List<StringTemplate> getStaticFields() {
        ArrayList<StringTemplate> staticFields = new ArrayList<StringTemplate>();
        if (this.classDataItem != null) {
            assert (this.classDefItem != null);
            EncodedArrayItem encodedStaticInitializers = this.classDefItem.getStaticFieldInitializers();
            EncodedValue[] staticInitializers = encodedStaticInitializers != null ? encodedStaticInitializers.getEncodedArray().values : new EncodedValue[]{};
            int i2 = 0;
            for (ClassDataItem.EncodedField field : this.classDataItem.getStaticFields()) {
                EncodedValue encodedValue = null;
                if (i2 < staticInitializers.length) {
                    encodedValue = staticInitializers[i2];
                }
                AnnotationSetItem annotationSet = this.fieldAnnotationsMap.get(field.field.getIndex());
                boolean setInStaticConstructor = this.fieldsSetInStaticConstructor.get(field.field.getIndex()) != null;
                staticFields.add(FieldDefinition.createTemplate(this.stg, field, encodedValue, annotationSet, setInStaticConstructor));
                ++i2;
            }
        }
        return staticFields;
    }

    private List<StringTemplate> getInstanceFields() {
        ArrayList<StringTemplate> instanceFields = new ArrayList<StringTemplate>();
        if (this.classDataItem != null) {
            for (ClassDataItem.EncodedField field : this.classDataItem.getInstanceFields()) {
                AnnotationSetItem annotationSet = this.fieldAnnotationsMap.get(field.field.getIndex());
                instanceFields.add(FieldDefinition.createTemplate(this.stg, field, annotationSet));
            }
        }
        return instanceFields;
    }

    private List<StringTemplate> getDirectMethods() {
        if (this.classDataItem == null) {
            return null;
        }
        return this.getTemplatesForMethods(this.classDataItem.getDirectMethods());
    }

    private List<StringTemplate> getVirtualMethods() {
        if (this.classDataItem == null) {
            return null;
        }
        return this.getTemplatesForMethods(this.classDataItem.getVirtualMethods());
    }

    private List<StringTemplate> getTemplatesForMethods(ClassDataItem.EncodedMethod[] methods) {
        ArrayList<StringTemplate> methodTemplates = new ArrayList<StringTemplate>();
        for (ClassDataItem.EncodedMethod method : methods) {
            AnnotationSetItem annotationSet = this.methodAnnotationsMap.get(method.method.getIndex());
            AnnotationSetRefList parameterAnnotationList = this.parameterAnnotationsMap.get(method.method.getIndex());
            MethodDefinition methodDefinition = new MethodDefinition(this.stg, method);
            methodTemplates.add(methodDefinition.createTemplate(annotationSet, parameterAnnotationList));
            ValidationException validationException = methodDefinition.getValidationException();
            if (validationException == null) continue;
            validationException.printStackTrace(System.err);
            this.validationErrors = true;
        }
        return methodTemplates;
    }
}

