/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.EndTryLabelMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.Reference.TypeReference;
import org.jf.dexlib.TypeIdItem;

public class CatchMethodItem
extends MethodItem {
    private final StringTemplateGroup stg;
    private final TypeIdItem exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(MethodDefinition.LabelCache labelCache, int codeAddress, StringTemplateGroup stg, TypeIdItem exceptionType, int startAddress, int endAddress, int handlerAddress) {
        super(codeAddress);
        this.stg = stg;
        this.exceptionType = exceptionType;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(startAddress, stg, "try_start_"));
        this.tryStartLabel.setUncommented();
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(codeAddress, stg, endAddress));
        this.tryEndLabel.setUncommented();
        this.handlerLabel = exceptionType == null ? labelCache.internLabel(new LabelMethodItem(handlerAddress, stg, "catchall_")) : labelCache.internLabel(new LabelMethodItem(handlerAddress, stg, "catch_"));
        this.handlerLabel.setUncommented();
    }

    public LabelMethodItem getTryStartLabel() {
        return this.tryStartLabel;
    }

    public LabelMethodItem getTryEndLabel() {
        return this.tryEndLabel;
    }

    public LabelMethodItem getHandlerLabel() {
        return this.handlerLabel;
    }

    public double getSortOrder() {
        return 102.0;
    }

    protected String getTemplateName() {
        return "Catch";
    }

    public String toString() {
        StringTemplate template = this.stg.getInstanceOf(this.getTemplateName());
        if (this.exceptionType != null) {
            template.setAttribute("ExceptionType", TypeReference.createTemplate(this.stg, this.exceptionType));
        }
        template.setAttribute("StartLabel", this.tryStartLabel);
        template.setAttribute("EndLabel", this.tryEndLabel);
        template.setAttribute("HandlerLabel", this.handlerLabel);
        return template.toString();
    }
}

