/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponder;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public class OCSPResponderInternal
extends OCSPResponder {
    public byte[] extraRequestCertsDER;
    public byte[] taggedSignerNameDER;
    public byte[] expectedKeyHash;
    private int a = 0;

    protected OCSPResponderInternal(CertJ certJ, OCSPResponder oCSPResponder) throws InvalidParameterException, NameException, CertificateException {
        super(oCSPResponder.getProfile(), oCSPResponder.getFlags(), oCSPResponder.getDestList(), oCSPResponder.getProxyList(), oCSPResponder.getRequestControl(), oCSPResponder.getResponderCert(), oCSPResponder.getResponderCACerts(), oCSPResponder.getDatabase(), oCSPResponder.getTimeTolerance());
        X509Certificate x509Certificate = oCSPResponder.getRequestControl().getSignerCert();
        if (x509Certificate != null) {
            byte[][] byArray;
            X500Name x500Name = x509Certificate.getSubjectName();
            this.taggedSignerNameDER = new byte[x500Name.getDERLen(this.a)];
            x500Name.getDEREncoding(this.taggedSignerNameDER, 0, this.a);
            String string = certJ.getDevice();
            JSAFE_PublicKey jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(string);
            try {
                byArray = jSAFE_PublicKey.getKeyData("RSAPublicKeyBER");
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                try {
                    byArray = jSAFE_PublicKey.getKeyData("DSAPublicKeyBER");
                }
                catch (JSAFE_UnimplementedException jSAFE_UnimplementedException2) {
                    throw new CertificateException("Cannot get key BER");
                }
            }
            if (byArray.length != 1) {
                throw new CertificateException("#keys>1");
            }
            this.expectedKeyHash = OCSPutil.makeDataDigest(certJ, super.getRequestControl().getDigestAlgorithm(), byArray[0], 0, 0);
        }
    }

    protected String getSignatureAlgorithm() {
        return super.getRequestControl().getSignatureAlgorithm();
    }
}

