/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.certificate;

import com.adobe.air.certificate.X509TBSCertificate;
import java.io.ByteArrayOutputStream;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.security.auth.x500.X500Principal;

public class X509Certificate {
    private X500Principal subject;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;

    public X509Certificate(X500Principal subject, RSAPrivateKey privateKey, RSAPublicKey publicKey) {
        this.subject = subject;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream s2;
        block2: {
            s2 = new ByteArrayOutputStream();
            try {
                X509TBSCertificate certificate = new X509TBSCertificate(this.subject, this.publicKey);
                byte[] encodedData = certificate.getEncoded();
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initSign(this.privateKey);
                signature.update(encodedData);
                byte[] signedData = signature.sign();
                s2.write(encodedData);
                s2.write(certificate.getEncodedSignature());
                s2.write(3);
                s2.write(130);
                int dataLength = signedData.length + 1;
                s2.write(dataLength >> 8 & 0xFF);
                s2.write(dataLength & 0xFF);
                s2.write(0);
                s2.write(signedData);
                encodedData = s2.toByteArray();
                s2.reset();
                s2.write(48);
                s2.write(130);
                s2.write(encodedData.length >> 8 & 0xFF);
                s2.write(encodedData.length & 0xFF);
                s2.write(encodedData);
            }
            catch (Exception e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return s2.toByteArray();
    }
}

