/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.CertificateCreationException;
import com.adobe.air.certificate.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;

public class CertificateCreator {
    public static final String RSA_1024 = "1024-RSA";
    public static final String RSA_2048 = "2048-RSA";
    private String name;
    private String organizationalUnit;
    private String organizationName;
    private String country;
    private int keyLength;
    private String password;
    private File output;
    private static String ESCAPABLE_CHARS = ",+\"\\<>;";

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setCountry(String country) {
        String[] codes = Locale.getISOCountries();
        for (int i2 = 0; i2 < codes.length; ++i2) {
            if (!codes[i2].equals(country)) continue;
            this.country = country;
            return;
        }
        String[] newCodes = new String[]{"AX", "BL", "CD", "GG", "IM", "JE", "ME", "MF", "PS", "RS", "TL"};
        for (int i3 = 0; i3 < newCodes.length; ++i3) {
            if (!newCodes[i3].equals(country)) continue;
            this.country = country;
            return;
        }
        throw new IllegalArgumentException("Invalid country code -- " + country);
    }

    public void setKeyType(String keyType) {
        if (!keyType.equals(RSA_1024) && !keyType.equals(RSA_2048)) {
            throw new IllegalArgumentException("Unsupported key type");
        }
        String[] tokens = keyType.split("-");
        this.keyLength = Integer.parseInt(tokens[0]);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void create() throws IOException {
        if (this.name == null) {
            throw new IllegalStateException("No name is set");
        }
        if (this.keyLength == 0) {
            throw new IllegalStateException("No key type is set");
        }
        if (this.password == null) {
            throw new IllegalStateException("No password is set");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output file is set");
        }
        try {
            StringBuffer dn = new StringBuffer("CN=" + CertificateCreator.escapeAttributeValue(this.name));
            if (this.organizationalUnit != null) {
                dn.append(",OU=" + CertificateCreator.escapeAttributeValue(this.organizationalUnit));
            }
            if (this.organizationName != null) {
                dn.append(",O=" + CertificateCreator.escapeAttributeValue(this.organizationName));
            }
            if (this.country != null) {
                dn.append(",C=" + CertificateCreator.escapeAttributeValue(this.country));
            }
            X500Principal subject = new X500Principal(dn.toString());
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(this.keyLength);
            KeyPair keyPair = generator.generateKeyPair();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            X509Certificate x509Certificate = new X509Certificate(subject, privateKey, publicKey);
            CertificateFactory factory = null;
            try {
                factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                throw new CertificateCreationException("no X.509 certificate provider available");
            }
            Certificate certificate = null;
            try {
                certificate = factory.generateCertificate(new ByteArrayInputStream(x509Certificate.getEncoded()));
            }
            catch (CertificateException ex) {
                throw new CertificateCreationException("certificate decoding error");
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try {
                keyStore.load(null, null);
            }
            catch (CertificateException ex) {
                throw new CertificateCreationException("KeyStore load error");
            }
            keyStore.setKeyEntry("1", privateKey, this.password.toCharArray(), new Certificate[]{certificate});
            try {
                keyStore.store(new FileOutputStream(this.output), this.password.toCharArray());
            }
            catch (CertificateException ex) {
                throw new CertificateCreationException("certificate encoding error");
            }
            catch (IOException e2) {
                throw new CertificateCreationException("unable to create output file");
            }
        }
        catch (NoSuchAlgorithmException e3) {
            throw new CertificateCreationException("rsa algorithm unavailable");
        }
        catch (KeyStoreException e4) {
            throw new CertificateCreationException("key store error");
        }
    }

    private static String escapeAttributeValue(String value) {
        StringBuffer b3 = new StringBuffer();
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (ESCAPABLE_CHARS.indexOf(c2) != -1) {
                b3.append('\\');
            }
            b3.append(c2);
        }
        return b3.toString();
    }
}

