/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.lang.reflect.Array;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public class InexactComparisonCriteria {
    public double fDelta;

    public InexactComparisonCriteria(double delta) {
        this.fDelta = delta;
    }

    public void internalArrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        if (expecteds == actuals) {
            return;
        }
        String header = message == null ? "" : message + ": ";
        int expectedsLength = Assert.assertArraysAreSameLength(expecteds, actuals, header);
        for (int i2 = 0; i2 < expectedsLength; ++i2) {
            Object expected = Array.get(expecteds, i2);
            Object actual = Array.get(actuals, i2);
            if (Assert.isArray(expected) && Assert.isArray(actual)) {
                try {
                    this.internalArrayEquals(message, expected, actual);
                    continue;
                }
                catch (ArrayComparisonFailure e2) {
                    e2.addDimension(i2);
                    throw e2;
                }
            }
            try {
                if (expected instanceof Double) {
                    Assert.assertEquals((Double)expected, (double)((Double)actual), this.fDelta);
                    continue;
                }
                Assert.assertEquals(((Float)expected).floatValue(), (double)((Float)actual).floatValue(), this.fDelta);
                continue;
            }
            catch (AssertionError e3) {
                throw new ArrayComparisonFailure(header, e3, i2);
            }
        }
    }
}

