/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelComputer
extends Computer {
    private final boolean fClasses;
    private final boolean fMethods;

    public ParallelComputer(boolean classes, boolean methods) {
        this.fClasses = classes;
        this.fMethods = methods;
    }

    public static Computer classes() {
        return new ParallelComputer(true, false);
    }

    @Override
    public Suite getSuite(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
        return this.fClasses ? new ParallelSuite(builder, classes) : super.getSuite(builder, classes);
    }

    @Override
    protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
        return this.fMethods ? new ParallelRunner(testClass) : super.getRunner(builder, testClass);
    }

    public static Computer methods() {
        return new ParallelComputer(false, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParallelRunner
    extends BlockJUnit4ClassRunner {
        private ExecutorService fService = Executors.newCachedThreadPool();
        private List<Future<Object>> fResults = new ArrayList<Future<Object>>();

        public ParallelRunner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        @Override
        protected void runChild(final FrameworkMethod method, final RunNotifier notifier) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ParallelRunner.this.superRunChild(method, notifier);
                    return null;
                }
            };
            this.fResults.add(this.fService.submit(callable));
        }

        protected void superRunChild(FrameworkMethod method, RunNotifier notifier) {
            super.runChild(method, notifier);
        }

        @Override
        public void run(RunNotifier notifier) {
            super.run(notifier);
            for (Future<Object> each : this.fResults) {
                try {
                    each.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParallelSuite
    extends Suite {
        private ExecutorService fService = Executors.newCachedThreadPool();
        private List<Future<Object>> fResults = new ArrayList<Future<Object>>();

        public ParallelSuite(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
            super(builder, classes);
        }

        @Override
        protected void runChild(final Runner runner, final RunNotifier notifier) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ParallelSuite.this.superRunChild(runner, notifier);
                    return null;
                }
            };
            this.fResults.add(this.fService.submit(callable));
        }

        protected void superRunChild(Runner runner, RunNotifier notifier) {
            super.runChild(runner, notifier);
        }

        @Override
        public void run(RunNotifier notifier) {
            super.run(notifier);
            for (Future<Object> each : this.fResults) {
                try {
                    each.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

