/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import org.jf.dexlib.Util.Hex;

public final class Utf8Utils {
    private static char[] tempBuffer = null;

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\u0000' && c2 < '\u0080') {
                bytes[outAt] = (byte)c2;
                ++outAt;
                continue;
            }
            if (c2 < '\u0800') {
                bytes[outAt] = (byte)(c2 >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c2 & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c2 >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c2 >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c2 & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(byte[] bytes) {
        int length = bytes.length;
        if (tempBuffer == null || tempBuffer.length < length) {
            tempBuffer = new char[length];
        }
        char[] chars = tempBuffer;
        int outAt = 0;
        int at2 = 0;
        while (length > 0) {
            char out;
            int v0 = bytes[at2] & 0xFF;
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v0 == 0) {
                        return Utf8Utils.throwBadUtf8(v0, at2);
                    }
                    out = (char)v0;
                    ++at2;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at2);
                    }
                    int v1 = bytes[at2 + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at2 + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v1, at2 + 1);
                    }
                    out = (char)value;
                    at2 += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(v0, at2);
                    }
                    int v1 = bytes[at2 + 1] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v1, at2 + 1);
                    }
                    int v2 = bytes[at2 + 2] & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v2, at2 + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v2, at2 + 2);
                    }
                    out = (char)value;
                    at2 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v0, at2);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeString(String value) {
        len = value.length();
        sb = new StringBuilder(len * 3 / 2);
        block5: for (i = 0; i < len; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append("\\u");
                    sb.append(Character.forDigit(c >> 12, 16));
                    sb.append(Character.forDigit(c >> 8 & 15, 16));
                    sb.append(Character.forDigit(c >> 4 & 15, 16));
                    sb.append(Character.forDigit(c & 15, 16));
                }
            }
        }
        return sb.toString();
    }
}

