/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapItem
extends Item<MapItem> {
    protected MapItem(DexFile dexFile) {
        super(dexFile);
    }

    @Override
    protected int placeItem(int offset) {
        Section[] sections = this.dexFile.getOrderedSections();
        return offset + 4 + (sections.length + 2) * 12;
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            ItemType itemType = ItemType.fromInt(in.readShort());
            in.readShort();
            int sectionSize = in.readInt();
            int sectionOffset = in.readInt();
            readContext.addSection(itemType, sectionSize, sectionOffset);
        }
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        assert (this.getOffset() > 0);
        Section[] sections = this.dexFile.getOrderedSections();
        out.annotate("map_size: 0x" + Integer.toHexString(sections.length + 2) + " (" + Integer.toString(sections.length + 2) + ")");
        out.writeInt(sections.length + 2);
        int index = 0;
        out.annotate(0, "[" + index++ + "]");
        out.indent();
        this.writeSectionInfo(out, ItemType.TYPE_HEADER_ITEM, 1, 0);
        out.deindent();
        for (Section section : this.dexFile.getOrderedSections()) {
            out.annotate(0, "[" + index++ + "]");
            out.indent();
            this.writeSectionInfo(out, section.ItemType, section.getItems().size(), section.getOffset());
            out.deindent();
        }
        out.annotate(0, "[" + index++ + "]");
        out.indent();
        this.writeSectionInfo(out, ItemType.TYPE_MAP_LIST, 1, this.dexFile.MapItem.getOffset());
        out.deindent();
    }

    private void writeSectionInfo(AnnotatedOutput out, ItemType itemType, int sectionSize, int sectionOffset) {
        if (out.annotates()) {
            out.annotate(2, "item_type: " + (Object)((Object)itemType));
            out.annotate(2, "unused");
            out.annotate(4, "section_size: 0x" + Integer.toHexString(sectionSize) + " (" + sectionSize + ")");
            out.annotate(4, "section_off: 0x" + Integer.toHexString(sectionOffset));
        }
        out.writeShort(itemType.MapValue);
        out.writeShort(0);
        out.writeInt(sectionSize);
        out.writeInt(sectionOffset);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_MAP_LIST;
    }

    @Override
    public int compareTo(MapItem o2) {
        return 0;
    }

    @Override
    public String getConciseIdentity() {
        return "map_item";
    }
}

