/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Utf8Utils;

public class StringEncodedValue
extends EncodedValue {
    public final StringIdItem value;

    protected StringEncodedValue(DexFile dexFile, Input in, byte valueArg) {
        int index = (int)EncodedValueUtils.decodeUnsignedIntegralValue(in.readBytes(valueArg + 1));
        this.value = dexFile.StringIdsSection.getItemByIndex(index);
    }

    public StringEncodedValue(StringIdItem value) {
        this.value = value;
    }

    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeUnsignedIntegralValue(this.value.getIndex());
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_STRING.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: \"" + Utf8Utils.escapeString(this.value.getStringValue()) + "\"");
        }
        out.writeByte(ValueType.VALUE_STRING.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value.getIndex()) + 1;
    }

    protected int compareValue(EncodedValue o2) {
        StringEncodedValue other = (StringEncodedValue)o2;
        return this.value.getIndex() - other.value.getIndex();
    }

    public ValueType getValueType() {
        return ValueType.VALUE_STRING;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

