/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.baksmali.main;
import org.jf.dexlib.Code.Analysis.ClassPath;

public class deodexCheck {
    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser = new PosixParser();
        Options options = deodexCheck.buildOptions();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            deodexCheck.usage(options);
            return;
        }
        String bootClassPath = "core.jar:ext.jar:framework.jar:android.policy.jar:services.jar";
        ArrayList<String> bootClassPathDirs = new ArrayList<String>();
        bootClassPathDirs.add(".");
        String deodexerantHost = null;
        int deodexerantPort = 0;
        int classStartIndex = 0;
        String[] remainingArgs = commandLine.getArgs();
        if (commandLine.hasOption("v")) {
            main.version();
            return;
        }
        if (commandLine.hasOption("?")) {
            deodexCheck.usage(options);
            return;
        }
        if (remainingArgs.length > 0) {
            deodexCheck.usage(options);
            return;
        }
        if (commandLine.hasOption("c")) {
            String bcp = commandLine.getOptionValue("c");
            bootClassPath = bcp.charAt(0) == ':' ? bootClassPath + bcp : bcp;
        }
        if (commandLine.hasOption("i")) {
            try {
                classStartIndex = Integer.parseInt(commandLine.getOptionValue("i"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (commandLine.hasOption("d")) {
            bootClassPathDirs.add(commandLine.getOptionValue("d"));
        }
        if (commandLine.hasOption("x")) {
            String deodexerantAddress = commandLine.getOptionValue("x");
            String[] parts = deodexerantAddress.split(":");
            if (parts.length != 2) {
                System.err.println("Invalid deodexerant address. Expecting :<port> or <host>:<port>");
                System.exit(1);
            }
            if ((deodexerantHost = parts[0]).length() == 0) {
                deodexerantHost = "localhost";
            }
            try {
                deodexerantPort = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid port \"" + deodexerantPort + "\" for deodexerant address");
                System.exit(1);
            }
        }
        String[] bootClassPathDirsArray = new String[bootClassPathDirs.size()];
        for (int i2 = 0; i2 < bootClassPathDirsArray.length; ++i2) {
            bootClassPathDirsArray[i2] = (String)bootClassPathDirs.get(i2);
        }
        ClassPath.InitializeClassPath(bootClassPathDirsArray, bootClassPath == null ? null : bootClassPath.split(":"), null, null);
        ClassPath.validateAgainstDeodexerant(deodexerantHost, deodexerantPort, classStartIndex);
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("java -classpath baksmali.jar deodexCheck -x HOST:PORT [options]", "disassembles and/or dumps a dex file", options, "");
    }

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("prints the version then exits");
        Option versionOption = OptionBuilder.create("v");
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("prints the help message then exits");
        Option helpOption = OptionBuilder.create("?");
        OptionBuilder.withLongOpt("bootclasspath");
        OptionBuilder.withDescription("the bootclasspath jars to use, for analysis. Defaults to core.jar:ext.jar:framework.jar:android.policy.jar:services.jar. If you specify a value that begins with a :, it will be appended to the default bootclasspath");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("BOOTCLASSPATH");
        Option classPathOption = OptionBuilder.create("c");
        OptionBuilder.withLongOpt("bootclasspath-dir");
        OptionBuilder.withDescription("the base folder to look for the bootclasspath files in. Defaults to the current directory.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option classPathDirOption = OptionBuilder.create("d");
        OptionBuilder.withLongOpt("deodexerant");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription("connect to deodexerant on the specified HOST:PORT, and validate the virtual method indexes, field offsets and inline methods against what dexlib calculates");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("HOST:PORT");
        Option deodexerantOption = OptionBuilder.create("x");
        OptionBuilder.withLongOpt("class-start-index");
        OptionBuilder.withDescription("Start checking classes at the given class index");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("CLASSINDEX");
        Option classStartOption = OptionBuilder.create("i");
        options.addOption(versionOption);
        options.addOption(helpOption);
        options.addOption(deodexerantOption);
        options.addOption(classPathOption);
        options.addOption(classPathDirOption);
        options.addOption(classStartOption);
        return options;
    }
}

