/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.Format.ArrayDataMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.OffsetInstructionFormatMethodItem;
import org.jf.baksmali.Adaptors.Format.PackedSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.SparseSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.UnresolvedNullReferenceMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.UnresolvedNullReference;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.CodeItem;

public class InstructionMethodItemFactory {
    private InstructionMethodItemFactory() {
    }

    public static InstructionMethodItem makeInstructionFormatMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, boolean dead, StringTemplateGroup stg, Instruction instruction, boolean isLastInstruction) {
        if (instruction instanceof OffsetInstruction) {
            return new OffsetInstructionFormatMethodItem<Instruction>(methodDefinition.getLabelCache(), codeItem, codeAddress, stg, instruction);
        }
        switch (instruction.getFormat()) {
            case ArrayData: {
                return new ArrayDataMethodItem(codeItem, codeAddress, dead, stg, (ArrayDataPseudoInstruction)instruction);
            }
            case PackedSwitchData: {
                return new PackedSwitchMethodItem(methodDefinition, codeItem, codeAddress, dead, stg, (PackedSwitchDataPseudoInstruction)instruction);
            }
            case SparseSwitchData: {
                return new SparseSwitchMethodItem(methodDefinition, codeItem, codeAddress, dead, stg, (SparseSwitchDataPseudoInstruction)instruction);
            }
            case UnresolvedNullReference: {
                return new UnresolvedNullReferenceMethodItem(codeItem, codeAddress, stg, (UnresolvedNullReference)instruction, isLastInstruction);
            }
        }
        return new InstructionMethodItem<Instruction>(codeItem, codeAddress, stg, instruction);
    }
}

