/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import junit.framework.TestCase;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.PathGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class TestStringTemplate
extends TestCase {
    static final String newline = System.getProperty("line.separator");

    public void testInterfaceFileFormat() throws Exception {
        String string = "interface test;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        StringTemplateGroupInterface stringTemplateGroupInterface = new StringTemplateGroupInterface(new StringReader(string));
        String string2 = "interface test;\nt();\nbold(item);\noptional duh(a, b, c);\n";
        TestStringTemplate.assertEquals(string2, stringTemplateGroupInterface.toString());
    }

    public void testNoGroupLoader() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        String string2 = "group testG implements blort;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string2);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string3 = "no group loader registered";
        TestStringTemplate.assertEquals(string3, ((Object)errorBuffer).toString());
    }

    public void testCannotFindInterfaceFile() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "group testG implements blort;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string2);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string3 = "no such interface file blort.sti";
        TestStringTemplate.assertEquals(string3, ((Object)errorBuffer).toString());
    }

    public void testMultiDirGroupLoading() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        if (!new File(string + "/sub").exists() && !new File(string + "/sub").mkdir()) {
            System.err.println("can't make subdir in test");
            return;
        }
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string + ":" + string + "/sub", errorBuffer));
        String string2 = "group testG2;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string + "/sub", "testG2.stg", string2);
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup("testG2");
        String string3 = "group testG2;\nbold(item) ::= <<foo>>\nduh(a,b,c) ::= <<foo>>\nt() ::= <<foo>>\n";
        TestStringTemplate.assertEquals(string3, stringTemplateGroup.toString());
    }

    public void testGroupSatisfiesSingleInterface() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "";
        TestStringTemplate.assertEquals(string4, ((Object)errorBuffer).toString());
    }

    public void testGroupExtendsSuperGroup() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "group superG;" + newline + "bold(item) ::= <<*$item$*>>;\n" + newline;
        TestStringTemplate.writeFile(string, "superG.stg", string2);
        String string3 = "group testG : superG;" + newline + "main(x) ::= <<$bold(x)$>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new FileReader(string + "/testG.stg"), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("main");
        stringTemplate.setAttribute("x", "foo");
        String string4 = "*foo*";
        TestStringTemplate.assertEquals(string4, stringTemplate.toString());
    }

    public void testGroupExtendsSuperGroupWithAngleBrackets() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "group superG;" + newline + "bold(item) ::= <<*<item>*>>;\n" + newline;
        TestStringTemplate.writeFile(string, "superG.stg", string2);
        String string3 = "group testG : superG;" + newline + "main(x) ::= \"<bold(x)>\"" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("main");
        stringTemplate.setAttribute("x", "foo");
        String string4 = "*foo*";
        TestStringTemplate.assertEquals(string4, stringTemplate.toString());
    }

    public void testMissingInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "group testG does not satisfy interface testI: missing templates [bold]";
        TestStringTemplate.assertEquals(string4, ((Object)errorBuffer).toString());
    }

    public void testMissingOptionalInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>";
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "";
        TestStringTemplate.assertEquals(string4, ((Object)errorBuffer).toString());
    }

    public void testMismatchedInterfaceTemplate() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(string, errorBuffer));
        String string2 = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(string, "testI.sti", string2);
        String string3 = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(string, "testG.stg", string3);
        new StringTemplateGroup((Reader)new FileReader(string + "/testG.stg"), errorBuffer);
        String string4 = "group testG does not satisfy interface testI: mismatched arguments on these templates [optional duh(a, b, c)]";
        TestStringTemplate.assertEquals(string4, ((Object)errorBuffer).toString());
    }

    public void testGroupFileFormat() throws Exception {
        String string = "group test;" + newline + "t() ::= \"literal template\"" + newline + "bold(item) ::= \"<b>$item$</b>\"" + newline + "duh() ::= <<" + newline + "xx" + newline + ">>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        String string2 = "group test;" + newline + "bold(item) ::= <<<b>$item$</b>>>" + newline + "duh() ::= <<xx>>" + newline + "t() ::= <<literal template>>" + newline;
        TestStringTemplate.assertEquals(string2, stringTemplateGroup.toString());
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("t");
        string2 = "literal template";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("bold");
        stringTemplate2.setAttribute("item", "dork");
        string2 = "<b>dork</b>";
        TestStringTemplate.assertEquals(string2, stringTemplate2.toString());
    }

    public void testEscapedTemplateDelimiters() throws Exception {
        String string = "group test;" + newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template\n>>" + newline + "bold(item) ::= <<<b>$item$</b\\>>>" + newline + "duh() ::= <<" + newline + "xx" + newline + ">>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        String string2 = "group test;" + newline + "bold(item) ::= <<<b>$item$</b>>>" + newline + "duh() ::= <<xx>>" + newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template>>" + newline;
        TestStringTemplate.assertEquals(string2, stringTemplateGroup.toString());
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("bold");
        stringTemplate.setAttribute("item", "dork");
        string2 = "<b>dork</b>";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("t");
        string2 = "literal} template";
        TestStringTemplate.assertEquals(string2, stringTemplate2.toString());
    }

    public void testTemplateParameterDecls() throws Exception {
        String string = "group test;" + newline + "t() ::= \"no args but ref $foo$\"" + newline + "t2(item) ::= \"decl but not used is ok\"" + newline + "t3(a,b,c,d) ::= <<$a$ $d$>>" + newline + "t4(a,b,c,d) ::= <<$a$ $b$ $c$ $d$>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("t");
        String string2 = null;
        try {
            stringTemplate.setAttribute("foo", "x");
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: foo in template context [t]";
        TestStringTemplate.assertEquals(string3, string2);
        stringTemplate = stringTemplateGroup.getInstanceOf("t2");
        stringTemplate.setAttribute("item", "x");
        stringTemplate = stringTemplateGroup.getInstanceOf("t3");
        stringTemplate.setAttribute("b", "x");
    }

    public void testTemplateRedef() throws Exception {
        String string = "group test;" + newline + "a() ::= \"x\"" + newline + "b() ::= \"y\"" + newline + "a() ::= \"z\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        String string2 = "redefinition of template: a";
        TestStringTemplate.assertEquals(string2, ((Object)errorBuffer).toString());
    }

    public void testMissingInheritedAttribute() throws Exception {
        String string = "group test;" + newline + "page(title,font) ::= <<" + newline + "<html>" + newline + "<body>" + newline + "$title$<br>" + newline + "$body()$" + newline + "</body>" + newline + "</html>" + newline + ">>" + newline + "body() ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("title", "my title");
        stringTemplate.setAttribute("font", "Helvetica");
        stringTemplate.toString();
    }

    public void testFormalArgumentAssignment() throws Exception {
        String string = "group test;" + newline + "page() ::= <<$body(font=\"Times\")$>>" + newline + "body(font) ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "<font face=Times>my body</font>";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testUndefinedArgumentAssignment() throws Exception {
        String string = "group test;" + newline + "page(x) ::= <<$body(font=x)$>>" + newline + "body() ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("x", "Times");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "template body has no such attribute: font in template context [page <invoke body arg context>]";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testFormalArgumentAssignmentInApply() throws Exception {
        String string = "group test;" + newline + "page(name) ::= <<$name:bold(font=\"Times\")$>>" + newline + "bold(font) ::= \"<font face=$font$><b>$it$</b></font>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "<font face=Times><b>Ter</b></font>";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testUndefinedArgumentAssignmentInApply() throws Exception {
        String string = "group test;" + newline + "page(name,x) ::= <<$name:bold(font=x)$>>" + newline + "bold() ::= \"<font face=$font$><b>$it$</b></font>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("x", "Times");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "template bold has no such attribute: font in template context [page <invoke bold arg context>]";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testUndefinedAttributeReference() throws Exception {
        String string = "group test;" + newline + "page() ::= <<$bold()$>>" + newline + "bold() ::= \"$name$\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: name in template context [page bold]";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testUndefinedDefaultAttributeReference() throws Exception {
        String string = "group test;" + newline + "page() ::= <<$bold()$>>" + newline + "bold() ::= \"$it$\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        String string2 = "";
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = noSuchElementException.getMessage();
        }
        String string3 = "no such attribute: it in template context [page bold]";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testAngleBracketsWithGroupFile() throws Exception {
        String string = "group test;" + newline + "a(s) ::= \"<s:{case <i> : <it> break;}>\"" + newline + "b(t) ::= \"<t; separator=\\\",\\\">\"" + newline + "c(t) ::= << <t; separator=\",\"> >>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("s", "Test");
        String string2 = "case 1 : Test break;";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testAngleBracketsNoGroup() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Tokens : <rules; separator=\"|\"> ;", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("rules", "A");
        stringTemplate.setAttribute("rules", "B");
        String string = "Tokens : A|B ;";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRegionRef() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X$@r()$Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testEmbeddedRegionRef() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X$@r$blort$@end$Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testRegionRefAngleBrackets() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testEmbeddedRegionRefAngleBrackets() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r>blort<@end>Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testEmbeddedRegionRefWithNewlinesAngleBrackets() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r>" + newline + "blort" + newline + "<@end>" + newline + "Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XblortY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testRegionRefWithDefAngleBrackets() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        String string2 = stringTemplate.toString();
        String string3 = "XfooY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testRegionRefWithDefInConditional() throws Exception {
        String string = "group test;" + newline + "a(v) ::= \"X<if(v)>A<@r()>B<endif>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("v", "true");
        String string2 = stringTemplate.toString();
        String string3 = "XAfooBY";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testRegionRefWithImplicitDefInConditional() throws Exception {
        String string = "group test;" + newline + "a(v) ::= \"X<if(v)>A<@r>yo<@end>B<endif>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.setAttribute("v", "true");
        String string2 = stringTemplate.toString();
        String string3 = "XAyoBY";
        TestStringTemplate.assertEquals(string3, string2);
        String string4 = ((Object)errorBuffer).toString();
        String string5 = "group test line 3: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(string5, string4);
    }

    public void testRegionOverride() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XfooY";
        TestStringTemplate.assertEquals(string4, string3);
    }

    public void testRegionOverrideRefSuperRegion() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"A<@super.r()>B\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XAfooBY";
        TestStringTemplate.assertEquals(string4, string3);
    }

    public void testRegionOverrideRefSuperRegion3Levels() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"<@super.r()>2\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        String string3 = "group subsub;" + newline + "@a.r() ::= \"<@super.r()>3\"" + newline;
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup(new StringReader(string3), AngleBracketTemplateLexer.class, null, stringTemplateGroup2);
        StringTemplate stringTemplate = stringTemplateGroup3.getInstanceOf("a");
        String string4 = stringTemplate.toString();
        String string5 = "Xfoo23Y";
        TestStringTemplate.assertEquals(string5, string4);
    }

    public void testRegionOverrideRefSuperImplicitRegion() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r>foo<@end>Y\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"A<@super.r()>\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        String string3 = stringTemplate.toString();
        String string4 = "XAfooY";
        TestStringTemplate.assertEquals(string4, string3);
    }

    public void testEmbeddedRegionRedefError() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r>dork<@end>Y\"" + "@a.r() ::= \"foo\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 2: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testImplicitRegionRedefError() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.r() ::= \"foo\"" + newline + "@a.r() ::= \"bar\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 4: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testImplicitOverriddenRegionRedefError() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"foo\"" + newline + "@a.r() ::= \"bar\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, errorBuffer, stringTemplateGroup);
        stringTemplateGroup2.getInstanceOf("a");
        String string3 = ((Object)errorBuffer).toString();
        String string4 = "group sub line 3: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(string4, string3);
    }

    public void testUnknownRegionDefError() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.q() ::= \"foo\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "group test line 3: template a has no region called q";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testSuperRegionRefError() throws Exception {
        String string = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "@a.r() ::= \"A<@super.q()>B\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, errorBuffer, stringTemplateGroup);
        stringTemplateGroup2.getInstanceOf("a");
        String string3 = ((Object)errorBuffer).toString();
        String string4 = "template a has no region called q";
        TestStringTemplate.assertEquals(string4, string3);
    }

    public void testMissingEndRegionError() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X$@r$foo\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer, null);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "missing region r $@end$ tag";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testMissingEndRegionErrorAngleBrackets() throws Exception {
        String string = "group test;" + newline + "a() ::= \"X<@r>foo\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        stringTemplate.toString();
        String string2 = ((Object)errorBuffer).toString();
        String string3 = "missing region r <@end> tag";
        TestStringTemplate.assertEquals(string3, string2);
    }

    public void testSimpleInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup2, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testOverrideInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup2, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<strong>Terence</strong>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testMultiLevelInheritance() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("root");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("level1");
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup("level2");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup3.setSuperGroup(stringTemplateGroup2);
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        stringTemplateGroup2.setErrorListener(errorBuffer);
        stringTemplateGroup3.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup3, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testComplicatedInheritance() throws Exception {
        String string = "group base;" + newline + "decls() ::= \"D<labels()>\"" + newline + "labels() ::= \"L\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "decls() ::= \"<super.decls()>\"" + newline + "labels() ::= \"SL\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2));
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("decls");
        String string3 = "DSL";
        String string4 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string3, string4);
    }

    public void test3LevelSuperRef() throws Exception {
        String string = "group super;" + newline + "r() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "r() ::= \"<super.r()>2\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        String string3 = "group subsub;" + newline + "r() ::= \"<super.r()>3\"" + newline;
        StringTemplateGroup stringTemplateGroup3 = new StringTemplateGroup(new StringReader(string3), AngleBracketTemplateLexer.class, null, stringTemplateGroup2);
        StringTemplate stringTemplate = stringTemplateGroup3.getInstanceOf("r");
        String string4 = stringTemplate.toString();
        String string5 = "foo23";
        TestStringTemplate.assertEquals(string5, string4);
    }

    public void testExprInParens() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$(\"blort: \"+(list)):bold()$");
        stringTemplate.setAttribute("list", "a");
        stringTemplate.setAttribute("list", "b");
        stringTemplate.setAttribute("list", "c");
        String string = "<b>blort: abc</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testMultipleAdditions() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$link(url=\"/member/view?ID=\"+ID+\"&x=y\"+foo, title=\"the title\")$");
        stringTemplate.setAttribute("ID", "3321");
        stringTemplate.setAttribute("foo", "fubar");
        String string = "<a href=\"/member/view?ID=3321&x=yfubar\"><b>the title</b></a>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCollectionAttributes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$data$, $data:bold()$, $list:bold():bold()$, $array$, $a2$, $a3$, $a4$");
        Vector<String> vector = new Vector<String>();
        vector.addElement("1");
        vector.addElement("2");
        vector.addElement("3");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("a");
        arrayList.add("b");
        arrayList.add("c");
        stringTemplate.setAttribute("data", vector);
        stringTemplate.setAttribute("list", arrayList);
        stringTemplate.setAttribute("array", (Object)new String[]{"x", "y"});
        stringTemplate.setAttribute("a2", (Object)new int[]{10, 20});
        stringTemplate.setAttribute("a3", (Object)new float[]{1.2f, 1.3f});
        stringTemplate.setAttribute("a4", (Object)new double[]{8.7, 9.2});
        String string = "123, <b>1</b><b>2</b><b>3</b>, <b><b>a</b></b><b><b>b</b></b><b><b>c</b></b>, xy, 1020, 1.21.3, 8.79.2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParenthesizedExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$(f+l):bold()$");
        stringTemplate.setAttribute("f", "Joe");
        stringTemplate.setAttribute("l", "Schmoe");
        String string = "<b>JoeSchmoe</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyTemplateNameExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("foobar", "foo$attr$bar");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$data:(name+\"bar\")()$");
        stringTemplate.setAttribute("data", "Ter");
        stringTemplate.setAttribute("data", "Tom");
        stringTemplate.setAttribute("name", "foo");
        String string = "fooTerbarfooTombar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyTemplateNameTemplateEval() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("foobar", "foo$it$bar");
        stringTemplateGroup.defineTemplate("a", "$it$bar");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$data:(\"foo\":a())()$");
        stringTemplate.setAttribute("data", "Ter");
        stringTemplate.setAttribute("data", "Tom");
        String string = "fooTerbarfooTombar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testTemplateNameExpression() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("foo", "hi there!");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$(name)()$");
        stringTemplate.setAttribute("name", "foo");
        String string = "hi there!";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testMissingEndDelimiter() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        new StringTemplate(stringTemplateGroup, "stuff $a then more junk etc...");
        String string = "problem parsing template 'anonymous': line 1:31: expecting '$', found '<EOF>'";
        TestStringTemplate.assertTrue(((Object)errorBuffer).toString().startsWith(string));
    }

    public void testSetButNotRefd() throws Exception {
        StringTemplate.setLintMode(true);
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$a$ then $b$ and $c$ refs.");
        stringTemplate.setAttribute("a", "Terence");
        stringTemplate.setAttribute("b", "Terence");
        stringTemplate.setAttribute("cc", "Terence");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        String string = "anonymous: set but not used: cc";
        stringTemplate.toString();
        StringTemplate.setLintMode(false);
        TestStringTemplate.assertEquals(string, ((Object)errorBuffer).toString());
    }

    public void testNullTemplateApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate.setAttribute("names", "Terence");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "Can't find template bold.st; context is [anonymous]; group hierarchy is [test]";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testNullTemplateToMultiValuedApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Tom");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "Can't find template bold.st; context is [anonymous]; group hierarchy is [test]";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testChangingAttrValueTemplateApplicationToVector() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names:bold(x=it)$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Tom");
        String string = "<b>Terence</b><b>Tom</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testChangingAttrValueRepeatedTemplateApplicationToVector() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("bold", "<b>$item$</b>");
        stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$members:bold(item=it):italics(it=it)$");
        stringTemplate.setAttribute("members", "Jim");
        stringTemplate.setAttribute("members", "Mike");
        stringTemplate.setAttribute("members", "Ashar");
        String string = "<i><b>Jim</b></i><i><b>Mike</b></i><i><b>Ashar</b></i>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testAlternatingTemplateApplication() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("listItem", "<li>$it$</li>");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$item:bold(),italics():listItem()$");
        stringTemplate.setAttribute("item", "Jim");
        stringTemplate.setAttribute("item", "Mike");
        stringTemplate.setAttribute("item", "Ashar");
        String string = "<li><b>Jim</b></li><li><i>Mike</i></li><li><b>Ashar</b></li>";
        TestStringTemplate.assertEquals(stringTemplate.toString(), string);
    }

    public void testExpressionAsRHSOfAssignment() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("hostname", "$machine$.jguru.com");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(x=hostname(machine=\"www\"))$");
        String string = "<b>www.jguru.com</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testTemplateApplicationAsRHSOfAssignment() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("hostname", "$machine$.jguru.com");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        stringTemplateGroup.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(x=hostname(machine=\"www\"):italics())$");
        String string = "<b><i>www.jguru.com</i></b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParameterAndAttributeScoping() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("italics", "<i>$x$</i>");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(x=italics(x=name))$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b><i>Terence</i></b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testComplicatedSeparatorExpr() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bulletSeparator", "</li>$foo$<li>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<ul>$name; separator=bulletSeparator(foo=\" \")+\"&nbsp;\"$</ul>");
        stringTemplate.setAttribute("name", "Ter");
        stringTemplate.setAttribute("name", "Tom");
        stringTemplate.setAttribute("name", "Mel");
        String string = "<ul>Ter</li> <li>&nbsp;Tom</li> <li>&nbsp;Mel</ul>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testAttributeRefButtedUpAgainstEndifAndWhitespace() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if (!firstName)$$email$$endif$");
        stringTemplate.setAttribute("email", "parrt@jguru.com");
        String string = "parrt@jguru.com";
        TestStringTemplate.assertEquals(stringTemplate.toString(), string);
    }

    public void testStringCatenationOnSingleValuedAttributeViaTemplateLiteral() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(it={$name$ Parr})$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence Parr</b>";
        TestStringTemplate.assertEquals(stringTemplate.toString(), string);
    }

    public void testStringCatenationOpOnArg() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(it=name+\" Parr\")$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence Parr</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testStringCatenationOpOnArgWithEqualsInString() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$bold(it=name+\" Parr=\")$");
        stringTemplate.setAttribute("name", "Terence");
        String string = "<b>Terence Parr=</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyingTemplateFromDiskWithPrecompiledIF() throws Exception {
        Comparable<StringBuffer> comparable;
        File file;
        File file2 = new File(System.getProperty("java.io.tmpdir"));
        int n2 = new Random().nextInt() & 0xFFFF;
        do {
            comparable = new StringBuffer("st-junit-");
            ((StringBuffer)comparable).append(++n2);
        } while ((file = new File(file2, ((StringBuffer)comparable).toString())).exists());
        file.mkdirs();
        comparable = new File(file, "page.st");
        FileWriter fileWriter = new FileWriter((File)comparable);
        fileWriter.write("<html><head>" + newline);
        fileWriter.write("</head>" + newline);
        fileWriter.write("<body>" + newline);
        fileWriter.write("$if(member)$User: $member:terse()$$endif$" + newline);
        fileWriter.write("</body>" + newline);
        fileWriter.write("</head>" + newline);
        fileWriter.close();
        File file3 = new File(file, "terse.st");
        fileWriter = new FileWriter(file3);
        fileWriter.write("$it.firstName$ $it.lastName$ (<tt>$it.email$</tt>)" + newline);
        fileWriter.close();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", file.toString());
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("member", new Connector());
        String string = "<html><head>" + newline + "</head>" + newline + "<body>" + newline + "User: Terence Parr (<tt>parrt@jguru.com</tt>)" + newline + "</body>" + newline + "</head>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        ((File)comparable).delete();
        file3.delete();
        file.delete();
    }

    public void testMultiValuedAttributeWithAnonymousTemplateUsingIndexVariableI() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, " List:" + newline + "  " + newline + "foo" + newline + newline + "$names:{<br>$i$. $it$" + newline + "}$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string = " List:" + newline + "  " + newline + "foo" + newline + newline + "<br>1. Terence" + newline + "<br>2. Jim" + newline + "<br>3. Sriram" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testFindTemplateInCLASSPATH() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("method stuff", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/method");
        stringTemplate.setAttribute("visibility", "public");
        stringTemplate.setAttribute("name", "foobar");
        stringTemplate.setAttribute("returnType", "void");
        stringTemplate.setAttribute("statements", "i=1;");
        stringTemplate.setAttribute("statements", "x=i;");
        String string = "public void foobar() {" + newline + "\t// start of a body" + newline + "\ti=1;" + newline + "\tx=i;" + newline + "\t// end of a body" + newline + "}";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$name:bold(x=name)$");
        stringTemplate.setAttribute("name", "Terence");
        TestStringTemplate.assertEquals("<b>Terence</b>", stringTemplate.toString());
    }

    public void testStringLiteralAsAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$\"Terence\":bold()$");
        TestStringTemplate.assertEquals("<b>Terence</b>", stringTemplate.toString());
    }

    public void testApplyTemplateToSingleValuedAttributeWithDefaultAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$name:bold()$");
        stringTemplate.setAttribute("name", "Terence");
        TestStringTemplate.assertEquals("<b>Terence</b>", stringTemplate.toString());
    }

    public void testApplyAnonymousTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$item:{<li>$it$</li>}$");
        stringTemplate.setAttribute("item", "Terence");
        TestStringTemplate.assertEquals("<li>Terence</li>", stringTemplate.toString());
    }

    public void testApplyAnonymousTemplateToMultiValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<ul>$items$</ul>");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$item:{<li>$it$</li>}; separator=\",\"$");
        stringTemplate2.setAttribute("item", "Terence");
        stringTemplate2.setAttribute("item", "Jim");
        stringTemplate2.setAttribute("item", "John");
        stringTemplate.setAttribute("items", stringTemplate2);
        String string = "<ul><li>Terence</li>,<li>Jim</li>,<li>John</li></ul>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyAnonymousTemplateToAggregateAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items:{$it.lastName$, $it.firstName$\n}$");
        stringTemplate.setAttribute("items.{ firstName ,lastName}", "Ter", "Parr");
        stringTemplate.setAttribute("items.{firstName, lastName }", "Tom", "Burns");
        String string = "Parr, Ter" + newline + "Burns, Tom" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRepeatedApplicationOfTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$item:bold():bold()$");
        stringTemplate.setAttribute("item", "Jim");
        TestStringTemplate.assertEquals("<b><b>Jim</b></b>", stringTemplate.toString());
    }

    public void testRepeatedApplicationOfTemplateToMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$item:bold():bold(); separator=\",\"$");
        stringTemplate.setAttribute("item", "Jim");
        stringTemplate.setAttribute("item", "Mike");
        stringTemplate.setAttribute("item", "Ashar");
        String string = "<b><b>Jim</b></b>,<b><b>Mike</b></b>,<b><b>Ashar</b></b>";
        TestStringTemplate.assertEquals(stringTemplate.toString(), string);
    }

    public void testMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "SELECT <distinct> <column; separator=\", \"> FROM <table>;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("column", "email");
        stringTemplate.setAttribute("table", "User");
        TestStringTemplate.assertEquals("SELECT  name, email FROM User;", stringTemplate.toString());
    }

    public void testSingleValuedAttributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("SELECT $column$ FROM $table$;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("table", "User");
        TestStringTemplate.assertEquals("SELECT name FROM User;", stringTemplate.toString());
    }

    public void testIFTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "SELECT <column> FROM PERSON <if(cond)>WHERE ID=<id><endif>;");
        stringTemplate.setAttribute("column", "name");
        stringTemplate.setAttribute("cond", "true");
        stringTemplate.setAttribute("id", "231");
        TestStringTemplate.assertEquals("SELECT name FROM PERSON WHERE ID=231;", stringTemplate.toString());
    }

    public void testIFCondWithParensTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<if(map.(type))><type> <prop>=<map.(type)>;<endif>");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("int", "0");
        stringTemplate.setAttribute("map", hashMap);
        stringTemplate.setAttribute("prop", "x");
        stringTemplate.setAttribute("type", "int");
        TestStringTemplate.assertEquals("int x=0;", stringTemplate.toString());
    }

    public void testIFCondWithParensDollarDelimsTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(map.(type))$$type$ $prop$=$map.(type)$;$endif$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("int", "0");
        stringTemplate.setAttribute("map", hashMap);
        stringTemplate.setAttribute("prop", "x");
        stringTemplate.setAttribute("type", "int");
        TestStringTemplate.assertEquals("int x=0;", stringTemplate.toString());
    }

    public void testIFBoolean() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(b)$x$endif$ $if(!b)$y$endif$");
        stringTemplate.setAttribute("b", new Boolean(true));
        TestStringTemplate.assertEquals(stringTemplate.toString(), "x ");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("b", new Boolean(false));
        TestStringTemplate.assertEquals(" y", stringTemplate.toString());
    }

    public void testNestedIFTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "ack<if(a)>" + newline + "foo" + newline + "<if(!b)>stuff<endif>" + newline + "<if(b)>no<endif>" + newline + "junk" + newline + "<endif>");
        stringTemplate.setAttribute("a", "blort");
        String string = "ackfoo" + newline + "stuff" + newline + "junk";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testObjectPropertyReference() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<b>Name: $p.firstName$ $p.lastName$</b><br>" + newline + "<b>Email: $p.email$</b><br>" + newline + "$p.bio$");
        stringTemplate.setAttribute("p", new Connector());
        String string = "<b>Name: Terence Parr</b><br>" + newline + "<b>Email: parrt@jguru.com</b><br>" + newline + "Superhero by night...";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyRepeatedAnonymousTemplateWithForeignTemplateRefToMultiValuedAttribute() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "start|$p:{$link(url=\"/member/view?ID=\"+it.ID, title=it.firstName)$ $if(it.canEdit)$canEdit$endif$}:{$it$<br>\n}$|end");
        stringTemplate.setAttribute("p", new Connector());
        stringTemplate.setAttribute("p", new Connector2());
        String string = "start|<a href=\"/member/view?ID=1\"><b>Terence</b></a> <br>" + newline + "<a href=\"/member/view?ID=2\"><b>Tom</b></a> canEdit<br>" + newline + "|end";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRecursion() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        stringTemplateGroup.defineTemplate("tree", "<if(it.firstChild)>( <it.text> <it.children:tree(); separator=\" \"> )<else><it.text><endif>");
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("tree");
        Tree tree = new Tree("a");
        tree.addChild(new Tree("b"));
        Tree tree2 = new Tree("c");
        tree2.addChild(new Tree("d"));
        tree.addChild(tree2);
        tree.addChild(new Tree("e"));
        stringTemplate.setAttribute("it", tree);
        String string = "( a b ( c d ) e )";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNestedAnonymousTemplates() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$</b>" + newline + "}$</i>" + newline + "}$");
        stringTemplate.setAttribute("A", "parrt");
        String string = newline + "<i>" + newline + "<b>parrt</b>" + newline + "</i>" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testAnonymousTemplateAccessToEnclosingAttributes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$, $B$</b>" + newline + "}$</i>" + newline + "}$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("B", "tombu");
        String string = newline + "<i>" + newline + "<b>parrt, tombu</b>" + newline + "</i>" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNestedAnonymousTemplatesAgain() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<table>" + newline + "$names:{<tr>$it:{<td>$it:{<b>$it$</b>}$</td>}$</tr>}$" + newline + "</table>" + newline);
        stringTemplate.setAttribute("names", "parrt");
        stringTemplate.setAttribute("names", "tombu");
        String string = "<table>" + newline + "<tr><td><b>parrt</b></td></tr><tr><td><b>tombu</b></td></tr>" + newline + "</table>" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testEscapes() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        stringTemplateGroup.defineTemplate("foo", "$x$ && $it$");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:foo(x=\"dog\\\"\\\"\")$");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "$A:foo(x=\"dog\\\"g\")$");
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplateGroup, "$A:{$it:foo(x=\"\\{dog\\}\\\"\")$ is cool}$");
        stringTemplate.setAttribute("A", "ick");
        stringTemplate2.setAttribute("A", "ick");
        stringTemplate3.setAttribute("A", "ick");
        String string = "dog\"\" && ick";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        string = "dog\"g && ick";
        TestStringTemplate.assertEquals(string, stringTemplate2.toString());
        string = "{dog}\" && ick is cool";
        TestStringTemplate.assertEquals(string, stringTemplate3.toString());
    }

    public void testEscapesOutsideExpressions() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("It\\'s ok...\\$; $a:{\\'hi\\', $it$}$");
        stringTemplate.setAttribute("a", "Ter");
        String string = "It\\'s ok...$; \\'hi\\', Ter";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testElseClause() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(title)$" + newline + "foo" + newline + "$else$" + newline + "bar" + newline + "$endif$");
        stringTemplate.setAttribute("title", "sample");
        String string = "foo";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        string = "bar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testElseIfClause() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(x)$" + newline + "foo" + newline + "$elseif(y)$" + newline + "bar" + newline + "$endif$");
        stringTemplate.setAttribute("y", "yep");
        String string = "bar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testElseIfClauseAngleBrackets() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("<if(x)>" + newline + "foo" + newline + "<elseif(y)>" + newline + "bar" + newline + "<endif>", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("y", "yep");
        String string = "bar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testElseIfClause2() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(x)$" + newline + "foo" + newline + "$elseif(y)$" + newline + "bar" + newline + "$elseif(z)$" + newline + "blort" + newline + "$endif$");
        stringTemplate.setAttribute("z", "yep");
        String string = "blort";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testElseIfClauseAndElse() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(x)$" + newline + "foo" + newline + "$elseif(y)$" + newline + "bar" + newline + "$elseif(z)$" + newline + "z" + newline + "$else$" + newline + "blort" + newline + "$endif$");
        String string = "blort";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNestedIF() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$if(title)$" + newline + "foo" + newline + "$else$" + newline + "$if(header)$" + newline + "bar" + newline + "$else$" + newline + "blort" + newline + "$endif$" + newline + "$endif$");
        stringTemplate.setAttribute("title", "sample");
        String string = "foo";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("header", "more");
        string = "bar";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        string = "blort";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testEmbeddedMultiLineIF() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$sub$");
        StringTemplate stringTemplate2 = new StringTemplate(stringTemplateGroup, "begin" + newline + "$if(foo)$" + newline + "$foo$" + newline + "$else$" + newline + "blort" + newline + "$endif$" + newline);
        stringTemplate2.setAttribute("foo", "stuff");
        stringTemplate.setAttribute("sub", stringTemplate2);
        String string = "begin" + newline + "stuff";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = new StringTemplate(stringTemplateGroup, "$sub$");
        stringTemplate2 = stringTemplate2.getInstanceOf();
        stringTemplate.setAttribute("sub", stringTemplate2);
        string = "begin" + newline + "blort";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testSimpleIndentOfAttributeList() throws Exception {
        String string = "group test;" + newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + newline + ">>" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string2 = "  Terence" + newline + "  Jim" + newline + "  Sriram";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIndentOfMultilineAttributes() throws Exception {
        String string = "group test;" + newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + newline + ">>" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence\nis\na\nmaniac");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram\nis\ncool");
        String string2 = "  Terence" + newline + "  is" + newline + "  a" + newline + "  maniac" + newline + "  Jim" + newline + "  Sriram" + newline + "  is" + newline + "  cool";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIndentOfMultipleBlankLines() throws Exception {
        String string = "group test;" + newline + "list(names) ::= <<" + "  $names$" + newline + ">>" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence\n\nis a maniac");
        String string2 = "  Terence" + newline + "" + newline + "  is a maniac";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIndentBetweenLeftJustifiedLiterals() throws Exception {
        String string = "group test;" + newline + "list(names) ::= <<" + "Before:" + newline + "  $names; separator=\"\\n\"$" + newline + "after" + newline + ">>" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("list");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "Jim");
        stringTemplate.setAttribute("names", "Sriram");
        String string2 = "Before:" + newline + "  Terence" + newline + "  Jim" + newline + "  Sriram" + newline + "after";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testNestedIndent() throws Exception {
        String string = "group test;" + newline + "method(name,stats) ::= <<" + "void $name$() {" + newline + "\t$stats; separator=\"\\n\"$" + newline + "}" + newline + ">>" + newline + "ifstat(expr,stats) ::= <<" + newline + "if ($expr$) {" + newline + "  $stats; separator=\"\\n\"$" + newline + "}" + ">>" + newline + "assign(lhs,expr) ::= <<$lhs$=$expr$;>>" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate2.setAttribute("lhs", "x");
        stringTemplate2.setAttribute("expr", "0");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("ifstat");
        stringTemplate3.setAttribute("expr", "x>0");
        StringTemplate stringTemplate4 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate4.setAttribute("lhs", "y");
        stringTemplate4.setAttribute("expr", "x+y");
        StringTemplate stringTemplate5 = stringTemplateGroup.getInstanceOf("assign");
        stringTemplate5.setAttribute("lhs", "z");
        stringTemplate5.setAttribute("expr", "4");
        stringTemplate3.setAttribute("stats", stringTemplate4);
        stringTemplate3.setAttribute("stats", stringTemplate5);
        stringTemplate.setAttribute("stats", stringTemplate2);
        stringTemplate.setAttribute("stats", stringTemplate3);
        String string2 = "void foo() {" + newline + "\tx=0;" + newline + "\tif (x>0) {" + newline + "\t  y=x+y;" + newline + "\t  z=4;" + newline + "\t}" + newline + "}";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testAlternativeWriter() throws Exception {
        final StringBuffer stringBuffer = new StringBuffer();
        StringTemplateWriter stringTemplateWriter = new StringTemplateWriter(){

            public void pushIndentation(String string) {
            }

            public String popIndentation() {
                return null;
            }

            public void pushAnchorPoint() {
            }

            public void popAnchorPoint() {
            }

            public void setLineWidth(int n2) {
            }

            public int write(String string, String string2) throws IOException {
                return 0;
            }

            public int write(String string) throws IOException {
                stringBuffer.append(string);
                return string.length();
            }

            public int writeWrapSeparator(String string) throws IOException {
                return 0;
            }

            public int writeSeparator(String string) throws IOException {
                return this.write(string);
            }
        };
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        stringTemplateGroup.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$name:bold(x=name)$");
        stringTemplate.setAttribute("name", "Terence");
        stringTemplate.write(stringTemplateWriter);
        TestStringTemplate.assertEquals("<b>Terence</b>", stringBuffer.toString());
    }

    public void testApplyAnonymousTemplateToMapAndSet() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items:{<li>$it$</li>}$");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("a", "1");
        linkedHashMap.put("b", "2");
        linkedHashMap.put("c", "3");
        stringTemplate.setAttribute("items", linkedHashMap);
        String string = "<li>1</li><li>2</li><li>3</li>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1");
        hashSet.add("2");
        hashSet.add("3");
        stringTemplate.setAttribute("items", hashSet);
        string = "<li>3</li><li>2</li><li>1</li>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testDumpMapAndSet() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$items; separator=\",\"$");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("a", "1");
        linkedHashMap.put("b", "2");
        linkedHashMap.put("c", "3");
        stringTemplate.setAttribute("items", linkedHashMap);
        String string = "1,2,3";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("1");
        hashSet.add("2");
        hashSet.add("3");
        stringTemplate.setAttribute("items", hashSet);
        string = "3,2,1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplyAnonymousTemplateToArrayAndMapProperty() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$x.values:{<li>$it$</li>}$");
        stringTemplate.setAttribute("x", new Connector3());
        String string = "<li>1</li><li>2</li><li>3</li>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = new StringTemplate("$x.stuff:{<li>$it$</li>}$");
        stringTemplate.setAttribute("x", new Connector3());
        string = "<li>1</li><li>2</li>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testSuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("page", "$font()$:text");
        stringTemplateGroup.defineTemplate("font", "Helvetica");
        stringTemplateGroup2.defineTemplate("font", "$super.font()$ and Times");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        String string = "Helvetica and Times:text";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testApplySuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup2.defineTemplate("page", "$name:super.bold()$");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = "<b>Ter</b>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLazyEvalOfSuperInApplySuperTemplateRef() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("base");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        stringTemplateGroup.defineTemplate("page", "$name:super.bold()$");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "base has no super group; invalid template: super.bold";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testTemplatePolymorphism() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("super");
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup("sub");
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        stringTemplateGroup.defineTemplate("page", "$name:bold()$");
        stringTemplateGroup2.defineTemplate("bold", "<strong>$it$</strong>");
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("page");
        stringTemplate.setAttribute("name", "Ter");
        String string = "<strong>Ter</strong>";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testListOfEmbeddedTemplateSeesEnclosingAttributes() throws Exception {
        String string = "group test;" + newline + "output(cond,items) ::= <<page: $items$>>" + newline + "mybody() ::= <<$font()$stuff>>" + newline + "font() ::= <<$if(cond)$this$else$that$endif$>>";
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("output");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("mybody");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("mybody");
        StringTemplate stringTemplate4 = stringTemplateGroup.getInstanceOf("mybody");
        stringTemplate.setAttribute("items", stringTemplate2);
        stringTemplate.setAttribute("items", stringTemplate3);
        stringTemplate.setAttribute("items", stringTemplate4);
        String string2 = "page: thatstuffthatstuffthatstuff";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testInheritArgumentFromRecursiveTemplateApplication() throws Exception {
        String string = "group test;" + newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("ifstat"));
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("ifstat"));
        String string2 = "IF true then IF true then ";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDeliberateRecursiveTemplateApplication() throws Exception {
        String string = "group test;" + newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + newline;
        StringTemplate.setLintMode(true);
        StringTemplate.resetTemplateCounter();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("ifstat");
        stringTemplate.setAttribute("stats", stringTemplate2);
        stringTemplate2.setAttribute("stats", stringTemplate);
        String string2 = "infinite recursion to <ifstat([stats])@4> referenced in <block([stats])@3>; stack trace:" + newline + "<ifstat([stats])@4>, attributes=[stats=<block()@3>]>" + newline + "<block([stats])@3>, attributes=[stats=<ifstat()@4>], references=[stats]>" + newline + "<ifstat([stats])@4> (start of recursive cycle)" + newline + "...";
        String string3 = "";
        try {
            stringTemplate.toString();
        }
        catch (IllegalStateException illegalStateException) {
            string3 = illegalStateException.getMessage();
        }
        StringTemplate.setLintMode(false);
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testImmediateTemplateAsAttributeLoop() throws Exception {
        String string = "group test;" + newline + "block(stats) ::= \"{<stats>}\"";
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("block");
        stringTemplate.setAttribute("stats", stringTemplateGroup.getInstanceOf("block"));
        String string2 = "{{}}";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testTemplateAlias() throws Exception {
        String string = "group test;" + newline + "page(name) ::= \"name is <name>\"" + "other ::= page" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("other");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "name is Ter";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testTemplateGetPropertyGetsAttribute() throws Exception {
        String string = "group test;" + newline + "Cfile(funcs) ::= <<" + newline + "#include \\<stdio.h>" + newline + "<funcs:{public void <it.name>(<it.args>);}; separator=\"\\n\">" + newline + "<funcs; separator=\"\\n\">" + newline + ">>" + newline + "func(name,args,body) ::= <<" + newline + "public void <name>(<args>) {<body>}" + newline + ">>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("Cfile");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("func");
        StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("func");
        stringTemplate2.setAttribute("name", "f");
        stringTemplate2.setAttribute("args", "");
        stringTemplate2.setAttribute("body", "i=1;");
        stringTemplate3.setAttribute("name", "g");
        stringTemplate3.setAttribute("args", "int arg");
        stringTemplate3.setAttribute("body", "y=1;");
        stringTemplate.setAttribute("funcs", stringTemplate2);
        stringTemplate.setAttribute("funcs", stringTemplate3);
        String string2 = "#include <stdio.h>" + newline + "public void f();" + newline + "public void g(int arg);" + newline + "public void f() {i=1;}" + newline + "public void g(int arg) {y=1;}";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testComplicatedIndirectTemplateApplication() throws Exception {
        String string = "group Java;" + newline + "" + newline + "file(variables) ::= <<" + "<variables:{ v | <v.decl:(v.format)()>}; separator=\"\\n\">" + newline + ">>" + newline + "intdecl(decl) ::= \"int <decl.name> = 0;\"" + newline + "intarray(decl) ::= \"int[] <decl.name> = null;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("file");
        stringTemplate.setAttribute("variables.{decl,format}", new Decl("i", "int"), "intdecl");
        stringTemplate.setAttribute("variables.{decl,format}", new Decl("a", "int-array"), "intarray");
        String string2 = "int i = 0;" + newline + "int[] a = null;";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIndirectTemplateApplication() throws Exception {
        String string = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)()>" + newline + ">>" + newline + "first() ::= \"the first\"" + newline + "second() ::= \"the second\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "first");
        String string2 = "the first";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIndirectTemplateWithArgsApplication() throws Exception {
        String string = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)(a=\"foo\")>" + newline + ">>" + newline + "first(a) ::= \"the first: <a>\"" + newline + "second(a) ::= \"the second <a>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "first");
        String string2 = "the first: foo";
        TestStringTemplate.assertEquals(stringTemplate.toString(), string2);
    }

    public void testNullIndirectTemplateApplication() throws Exception {
        String string = "group dork;" + newline + "" + newline + "test(names) ::= <<" + "<names:(ind)()>" + newline + ">>" + newline + "ind() ::= \"[<it>]\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "me");
        stringTemplate.setAttribute("names", "you");
        String string2 = "";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testNullIndirectTemplate() throws Exception {
        String string = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)()>" + newline + ">>" + newline + "first() ::= \"the first\"" + newline + "second() ::= \"the second\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        String string2 = "";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testHashMapPropertyFetch() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$stuff.prop$");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        stringTemplate.setAttribute("stuff", hashMap);
        hashMap.put("prop", "Terence");
        String string = stringTemplate.toString();
        String string2 = "Terence";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testHashMapPropertyFetchEmbeddedStringTemplate() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$stuff.prop$");
        HashMap<String, StringTemplate> hashMap = new HashMap<String, StringTemplate>();
        stringTemplate.setAttribute("stuff", hashMap);
        stringTemplate.setAttribute("title", "ST rocks");
        hashMap.put("prop", new StringTemplate("embedded refers to $title$"));
        String string = stringTemplate.toString();
        String string2 = "embedded refers to ST rocks";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testEmbeddedComments() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo $! ignore !$bar" + newline);
        String string = "Foo bar" + newline;
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("Foo $! ignore" + newline + " and a line break!$" + newline + "bar" + newline);
        string = "Foo " + newline + "bar" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("$! start of line $ and $! ick" + newline + "!$boo" + newline);
        string = "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("$! start of line !$" + newline + "$! another to ignore !$" + newline + "$! ick" + newline + "!$boo" + newline);
        string = "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("$! back !$$! to back !$" + newline + "$! ick" + newline + "!$boo" + newline);
        string = newline + "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmbeddedCommentsAngleBracketed() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo <! ignore !>bar" + newline, AngleBracketTemplateLexer.class);
        String string = "Foo bar" + newline;
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("Foo <! ignore" + newline + " and a line break!>" + newline + "bar" + newline, AngleBracketTemplateLexer.class);
        string = "Foo " + newline + "bar" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("<! start of line $ and <! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        string = "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("<! start of line !><! another to ignore !><! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        string = "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("<! back !><! to back !>" + newline + "<! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        string = newline + "boo" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testCharLiterals() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo <\\r\\n><\\n><\\t> bar" + newline, AngleBracketTemplateLexer.class);
        StringWriter stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\n"));
        String string = stringWriter.toString();
        String string2 = "Foo \n\n\t bar" + newline;
        TestStringTemplate.assertEquals(string2, string);
        stringTemplate = new StringTemplate("Foo $\\n$$\\t$ bar" + newline);
        stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\n"));
        string2 = "Foo \n\t bar" + newline;
        string = stringWriter.toString();
        TestStringTemplate.assertEquals(string2, string);
        stringTemplate = new StringTemplate("Foo$\\ $bar$\\n$");
        stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\n"));
        string = stringWriter.toString();
        string2 = "Foo bar\n";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testNewlineNormalizationInTemplateString() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo\r\nBar\n", AngleBracketTemplateLexer.class);
        StringWriter stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\n"));
        String string = stringWriter.toString();
        String string2 = "Foo\nBar\n";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testNewlineNormalizationInTemplateStringPC() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo\r\nBar\n", AngleBracketTemplateLexer.class);
        StringWriter stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\r\n"));
        String string = stringWriter.toString();
        String string2 = "Foo\r\nBar\r\n";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testNewlineNormalizationInAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo\r\n<name>\n", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("name", "a\nb\r\nc");
        StringWriter stringWriter = new StringWriter();
        stringTemplate.write(new AutoIndentWriter(stringWriter, "\n"));
        String string = stringWriter.toString();
        String string2 = "Foo\na\nb\nc\n";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testUnicodeLiterals() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Foo <\\uFEA5\\n\\u00C2> bar" + newline, AngleBracketTemplateLexer.class);
        String string = "Foo \ufea5" + newline + "\u00c2 bar" + newline;
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("Foo $\\uFEA5\\n\\u00C2$ bar" + newline);
        string = "Foo \ufea5" + newline + "\u00c2 bar" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
        stringTemplate = new StringTemplate("Foo$\\ $bar$\\n$");
        string = "Foo bar" + newline;
        string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyIteratedValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$names; separator=\",\"$");
        stringTemplate.setAttribute("names", "Terence");
        stringTemplate.setAttribute("names", "");
        stringTemplate.setAttribute("names", "");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Frank");
        stringTemplate.setAttribute("names", "");
        String string = "Terence,,,Tom,Frank,";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyIteratedConditionalValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users:{$if(it.ok)$$it.name$$endif$}; separator=\",\"$");
        stringTemplate.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        stringTemplate.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String string = "Terence,,Frank,";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyIteratedConditionalWithElseValueGetsSeparator() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users:{$if(it.ok)$$it.name$$else$$endif$}; separator=\",\"$");
        stringTemplate.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        stringTemplate.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        stringTemplate.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String string = "Terence,,Frank,";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testWhiteSpaceAtEndOfTemplate() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("group");
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/page");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("org/antlr/stringtemplate/test/users_list");
        stringTemplate2.setAttribute("users", new Connector());
        stringTemplate2.setAttribute("users", new Connector2());
        stringTemplate.setAttribute("title", "some title");
        stringTemplate.setAttribute("body", stringTemplate2);
        String string = "some title" + newline + "Terence parrt@jguru.comTom tombu@jguru.com";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testSizeZeroButNonNullListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$duh.users:{name: $it$}; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("duh", new Duh());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testNullListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyListGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("users", new ArrayList());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyListNoIteratorGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$users; separator=\", \"$\nend\n");
        stringTemplate.setAttribute("users", new ArrayList());
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmptyExprAsFirstLineGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        stringTemplateGroup.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$users$\nend\n");
        String string = "end\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testSizeZeroOnLineByItselfGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n$name$\n$users:{name: $it$}$\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testSizeZeroOnLineWithIndentGetsNoOutput() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "begin\n  $name$\n\t$users:{name: $it$}$\n\t$users:{name: $it$$\\n$}$\nend\n");
        String string = "begin\nend\n";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testSimpleAutoIndent() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$title$: {\n\t$name; separator=\"\n\"$\n}");
        stringTemplate.setAttribute("title", "foo");
        stringTemplate.setAttribute("name", "Terence");
        stringTemplate.setAttribute("name", "Frank");
        String string = stringTemplate.toString();
        String string2 = "foo: {\n\tTerence\n\tFrank\n}";
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testComputedPropertyName() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        ErrorBuffer errorBuffer = new ErrorBuffer();
        stringTemplateGroup.setErrorListener(errorBuffer);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "variable property $propName$=$v.(propName)$");
        stringTemplate.setAttribute("v", new Decl("i", "int"));
        stringTemplate.setAttribute("propName", "type");
        String string = "variable property type=int";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals("", ((Object)errorBuffer).toString());
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testNonNullButEmptyIteratorTestsFalse() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$if(users)$\nUsers: $users:{$it.name$ }$\n$endif$");
        stringTemplate.setAttribute("users", new LinkedList());
        String string = "";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testDoNotInheritAttributesThroughFormalArgs() throws Exception {
        String string = "group test;" + newline + "method(name) ::= \"<stat()>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // ";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testArgEvaluationContext() throws Exception {
        String string = "group test;" + newline + "method(name) ::= \"<stat(name=name)>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testPassThroughAttributes() throws Exception {
        String string = "group test;" + newline + "method(name) ::= \"<stat(...)>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=y; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testPassThroughAttributes2() throws Exception {
        String string = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(value=\"34\",...)>" + newline + ">>" + newline + "stat(name,value) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=34; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDefaultArgument() throws Exception {
        String string = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=99; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDefaultArgument2() throws Exception {
        String string = "group test;" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("stat");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=99; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDefaultArgumentAsTemplate() throws Exception {
        String string = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value={<name>}) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "2");
        String string2 = "x=foo; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDefaultArgumentAsTemplate2() throws Exception {
        String string = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value={ [<name>] }) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "2");
        String string2 = "x= [foo] ; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDoNotUseDefaultArgument() throws Exception {
        String string = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(value=\"34\",...)>" + newline + ">>" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        String string2 = "x=34; // foo";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testArgumentsAsTemplates() throws Exception {
        String string = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(value={<size>})>" + newline + ">>" + newline + "stat(value) ::= \"x=<value>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "34");
        String string2 = "x=34;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testTemplateArgumentEvaluatedInSurroundingContext() throws Exception {
        String string = "group test;" + newline + "file(m,size) ::= \"<m>\"" + newline + "method(name) ::= <<" + newline + "<stat(value={<size>.0})>" + newline + ">>" + newline + "stat(value) ::= \"x=<value>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("file");
        stringTemplate.setAttribute("size", "34");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("method");
        stringTemplate2.setAttribute("name", "foo");
        stringTemplate.setAttribute("m", stringTemplate2);
        String string2 = "x=34.0;";
        String string3 = stringTemplate2.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testArgumentsAsTemplatesDefaultDelimiters() throws Exception {
        String string = "group test;" + newline + "method(name,size) ::= <<" + newline + "$stat(value={$size$})$" + newline + ">>" + newline + "stat(value) ::= \"x=$value$;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("method");
        stringTemplate.setAttribute("name", "foo");
        stringTemplate.setAttribute("size", "34");
        String string2 = "x=34;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testDefaultArgsWhenNotInvoked() throws Exception {
        String string = "group test;" + newline + "b(name=\"foo\") ::= \".<name>.\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("b");
        String string2 = ".foo.";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testRendererForST() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplate.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String string = "date: 2005.07.05";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testRendererWithFormat() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("date: <created; format=\"yyyy.MM.dd\">", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplate.registerRenderer(GregorianCalendar.class, new DateRenderer3());
        String string = "date: 2005.07.05";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testRendererWithFormatAndList() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("The names: <names; format=\"upper\">", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("names", "ter");
        stringTemplate.setAttribute("names", "tom");
        stringTemplate.setAttribute("names", "sriram");
        stringTemplate.registerRenderer(String.class, new StringRenderer());
        String string = "The names: TERTOMSRIRAM";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testRendererWithFormatAndSeparator() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("The names: <names; separator=\" and \", format=\"upper\">", AngleBracketTemplateLexer.class);
        stringTemplate.setAttribute("names", "ter");
        stringTemplate.setAttribute("names", "tom");
        stringTemplate.setAttribute("names", "sriram");
        stringTemplate.registerRenderer(String.class, new StringRenderer());
        String string = "The names: TER and TOM and SRIRAM";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testRendererWithFormatAndSeparatorAndNull() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("The names: <names; separator=\" and \", null=\"n/a\", format=\"upper\">", AngleBracketTemplateLexer.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ter");
        arrayList.add(null);
        arrayList.add("sriram");
        stringTemplate.setAttribute("names", arrayList);
        stringTemplate.registerRenderer(String.class, new StringRenderer());
        String string = "The names: TER and N/A and SRIRAM";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testEmbeddedRendererSeesEnclosing() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("X: <x>", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate2 = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        stringTemplate2.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplate.setAttribute("x", stringTemplate2);
        stringTemplate.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String string = "X: date: 2005.07.05";
        String string2 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testRendererForGroup() throws Exception {
        String string = "group test;" + newline + "dateThing(created) ::= \"date: <created>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("dateThing");
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplateGroup.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String string2 = "date: 2005.07.05";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testOverriddenRenderer() throws Exception {
        String string = "group test;" + newline + "dateThing(created) ::= \"date: <created>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("dateThing");
        stringTemplate.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        stringTemplateGroup.registerRenderer(GregorianCalendar.class, new DateRenderer());
        stringTemplate.registerRenderer(GregorianCalendar.class, new DateRenderer2());
        String string2 = "date: 07/05/2005";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMap() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapValuesAreTemplates() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0<w>\", \"float\":\"0.0<w>\"] " + newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("w", "L");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0L;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapKeyLookupViaTemplate() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0<w>\", \"float\":\"0.0<w>\"] " + newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("w", "L");
        stringTemplate.setAttribute("type", new StringTemplate("int"));
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0L;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapMissingDefaultValueIsEmpty() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("w", "L");
        stringTemplate.setAttribute("type", "double");
        stringTemplate.setAttribute("name", "x");
        String string2 = "double x = ;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapHiddenByFormalArg() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(typeInit,type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = ;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapEmptyValueAndAngleBracketStrings() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":, \"double\":<<0.0L>>] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "float");
        stringTemplate.setAttribute("name", "x");
        String string2 = "float x = ;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapDefaultValue() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", default:\"null\"] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = null;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapEmptyDefaultValue() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", default:] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = ;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapDefaultValueIsKey() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", default:key] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "UserRecord");
        stringTemplate.setAttribute("name", "x");
        String string2 = "UserRecord x = UserRecord;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapDefaultStringAsKey() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"default\":\"foo\"] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("var");
        stringTemplate.setAttribute("type", "default");
        stringTemplate.setAttribute("name", "x");
        String string2 = "default x = foo;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapDefaultIsDefaultString() throws Exception {
        String string = "group test;" + newline + "map ::= [default: \"default\"] " + newline + "t1() ::= \"<map.(1)>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("t1");
        String string2 = "default";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapViaEnclosingTemplates() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "intermediate(type,name) ::= \"<var(...)>\"" + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("intermediate");
        stringTemplate.setAttribute("type", "int");
        stringTemplate.setAttribute("name", "x");
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testMapViaEnclosingTemplates2() throws Exception {
        String string = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "intermediate(stuff) ::= \"<stuff>\"" + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("intermediate");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("var");
        stringTemplate2.setAttribute("type", "int");
        stringTemplate2.setAttribute("name", "x");
        stringTemplate.setAttribute("stuff", stringTemplate2);
        String string2 = "int x = 0;";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testEmptyGroupTemplate() throws Exception {
        String string = "group test;" + newline + "foo() ::= \"\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("foo");
        String string2 = "";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingAngleBracketLexer() throws Exception {
        String string = "group test;" + newline + "top() ::= <<<x(a=\"\", b={})\\>>>" + newline + "x(a,b) ::= \"a=<a>, b=<b>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        String string2 = "a=, b=";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingDollarLexer() throws Exception {
        String string = "group test;" + newline + "top() ::= <<$x(a=\"\", b={})$>>" + newline + "x(a,b) ::= \"a=$a$, b=$b$\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        String string2 = "a=, b=";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void test8BitEuroChars() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("Danish: \u0143 char");
        stringTemplate = stringTemplate.getInstanceOf();
        String string = "Danish: \u0143 char";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void test16BitUnicodeChar() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("DINGBAT CIRCLED SANS-SERIF DIGIT ONE: \u2780");
        stringTemplate = stringTemplate.getInstanceOf();
        String string = "DINGBAT CIRCLED SANS-SERIF DIGIT ONE: \u2780";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testFirstOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testTruncOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$trunc(names); separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter, Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRestOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names); separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Tom, Sriram";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRestOpEmptyList() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names); separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", new ArrayList());
        String string = "";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testReUseOfRestResult() throws Exception {
        String string = "group test;" + newline + "a(names) ::= \"<b(rest(names))>\"" + newline + "b(x) ::= \"<x>, <x>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList);
        String string2 = "Tom, Tom";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testLastOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Sriram";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCombinedOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[first(mine),rest(yours)]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        stringTemplate.setAttribute("yours", "b");
        String string = "1, b";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCatListAndSingleAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[mine,yours]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        String string = "1, 2, 3, a";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testReUseOfCat() throws Exception {
        String string = "group test;" + newline + "a(mine,yours) ::= \"<b([mine,yours])>\"" + newline + "b(x) ::= \"<x>, <x>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("mine", arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Foo");
        stringTemplate.setAttribute("yours", arrayList2);
        String string2 = "TerTomFoo, TerTomFoo";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testCatListAndEmptyAttributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[x,mine,y,yours,z]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("mine", "1");
        stringTemplate.setAttribute("mine", "2");
        stringTemplate.setAttribute("mine", "3");
        stringTemplate.setAttribute("yours", "a");
        String string = "1, 2, 3, a";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNestedOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(rest(names))$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testFirstWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "Ter";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLastWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "Ter";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLastWithLengthOneListAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$last(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String string = "Ter";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRestWithOneAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRestWithLengthOneListAttributeOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String string = "";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRepeatedRestOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$, $rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Tom, Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testRepeatedIteratedAttrFromArg() throws Exception {
        String string = "group test;" + newline + "root(names) ::= \"$other(names)$\"" + newline + "other(x) ::= \"$x$, $x$\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("root");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList.iterator());
        String string2 = "TerTom, ";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testIncomingLists() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$rest(names)$, $rest(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Tom, Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testIncomingListsAreNotModified() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList);
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter, Tom, Sriram";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        TestStringTemplate.assertEquals(arrayList.size(), 2);
    }

    public void testIncomingListsAreNotModified2() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("names", arrayList);
        String string = "Sriram, Ter, Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        TestStringTemplate.assertEquals(arrayList.size(), 2);
    }

    public void testIncomingArraysAreOk() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", (Object)new String[]{"Ter", "Tom"});
        stringTemplate.setAttribute("names", "Sriram");
        String string = "Ter, Tom, Sriram";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testMultipleRefsToListAttribute() throws Exception {
        String string = "group test;" + newline + "f(x) ::= \"<x> <x>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("f");
        stringTemplate.setAttribute("x", "Ter");
        stringTemplate.setAttribute("x", "Tom");
        String string2 = "TerTom TerTom";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testApplyTemplateWithSingleFormalArgs() throws Exception {
        String string = "group test;" + newline + "test(names) ::= <<<names:bold(item=it); separator=\", \"> >>" + newline + "bold(item) ::= <<*<item>*>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*, *Tom* ";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testApplyTemplateWithNoFormalArgs() throws Exception {
        String string = "group test;" + newline + "test(names) ::= <<<names:bold(); separator=\", \"> >>" + newline + "bold() ::= <<*<it>*>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*, *Tom* ";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testAnonTemplateArgs() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| $n$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "Ter, Tom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testAnonTemplateWithArgHasNoITArg() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| $n$:$it$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = null;
        try {
            stringTemplate.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            string = noSuchElementException.getMessage();
        }
        String string2 = "no such attribute: it in template context [anonymous anonymous]";
        TestStringTemplate.assertEquals(string, string2);
    }

    public void testAnonTemplateArgs2() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names:{n| .$n$.}:{ n | _$n$_}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string = "_.Ter._, _.Tom._";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testFirstWithCatAttribute() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first([names,phones])$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testFirstWithListOfMaps() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$first(maps).Ter$");
        stringTemplate = stringTemplate.getInstanceOf();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        final HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap.put("Ter", "x5707");
        stringTemplate.setAttribute("maps", hashMap);
        hashMap2.put("Tom", "x5332");
        stringTemplate.setAttribute("maps", hashMap2);
        String string = "x5707";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList arrayList = new ArrayList(){
            {
                this.add(hashMap);
                this.add(hashMap2);
            }
        };
        stringTemplate.setAttribute("maps", arrayList);
        string = "x5707";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testJustCat() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "TerTom12";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCat2Attributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter, Tom, 1, 2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCat2AttributesWithApply() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones]:{a|$a$.}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string = "Ter.Tom.1.2.";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testCat3Attributes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[names,phones,salaries]; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "Ter, Tom, 1, 2, big, huge";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testListAsTemplateArgument() throws Exception {
        String string = "group test;" + newline + "test(names,phones) ::= \"<foo([names,phones])>\"" + newline + "foo(items) ::= \"<items:{a | *<a>*}>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        String string2 = "*Ter**Tom**1**2*";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testSingleExprTemplateArgument() throws Exception {
        String string = "group test;" + newline + "test(name) ::= \"<bold(name)>\"" + newline + "bold(item) ::= \"*<item>*\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "Ter");
        String string2 = "*Ter*";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testSingleExprTemplateArgumentInApply() throws Exception {
        String string = "group test;" + newline + "test(names,x) ::= \"<names:bold(x)>\"" + newline + "bold(item) ::= \"*<item>*\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("x", "ick");
        String string2 = "*ick**ick*";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testSoleFormalTemplateArgumentInMultiApply() throws Exception {
        String string = "group test;" + newline + "test(names) ::= \"<names:bold(),italics()>\"" + newline + "bold(x) ::= \"*<x>*\"" + newline + "italics(y) ::= \"_<y>_\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        String string2 = "*Ter*_Tom_";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testSingleExprTemplateArgumentError() throws Exception {
        String string = "group test;" + newline + "test(name) ::= \"<bold(name)>\"" + newline + "bold(item,ick) ::= \"*<item>*\"" + newline;
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string), AngleBracketTemplateLexer.class, errorBuffer);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("name", "Ter");
        stringTemplate.toString();
        String string2 = "template bold must have exactly one formal arg in template context [test <invoke bold arg context>]";
        TestStringTemplate.assertEquals(((Object)errorBuffer).toString(), string2);
    }

    public void testInvokeIndirectTemplateWithSingleFormalArgs() throws Exception {
        String string = "group test;" + newline + "test(templateName,arg) ::= \"<(templateName)(arg)>\"" + newline + "bold(x) ::= <<*<x>*>>" + newline + "italics(y) ::= <<_<y>_>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("test");
        stringTemplate.setAttribute("templateName", "italics");
        stringTemplate.setAttribute("arg", "Ter");
        String string2 = "_Ter_";
        String string3 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testParallelAttributeIteration() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$\n}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "Ter@1: big" + newline + "Tom@2: huge" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParallelAttributeIterationWithNullValue() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$\n}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("phones", new ArrayList(){
            {
                this.add("1");
                this.add(null);
                this.add("3");
            }
        });
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        stringTemplate.setAttribute("salaries", "enormous");
        String string = "Ter@1: big" + newline + "Tom@: huge" + newline + "Sriram@3: enormous" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParallelAttributeIterationHasI() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $i0$. $n$@$p$: $s$\n}$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.setAttribute("salaries", "huge");
        String string = "0. Ter@1: big" + newline + "1. Tom@2: huge" + newline;
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParallelAttributeIterationWithDifferentSizes() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1: big, Tom@2: , Sriram@: ";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParallelAttributeIterationWithSingletons() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1: big";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testParallelAttributeIterationWithMismatchArgListSizes() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{n,p | $n$@$p$}; separator=\", \"$");
        stringTemplate.setErrorListener(errorBuffer);
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string = "Ter@1, Tom@2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
        String string2 = "number of arguments [n, p] mismatch between attribute list and anonymous template in context [anonymous]";
        TestStringTemplate.assertEquals(string2, ((Object)errorBuffer).toString());
    }

    public void testParallelAttributeIterationWithMissingArgs() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        StringTemplate stringTemplate = new StringTemplate("$names,phones,salaries:{$n$@$p$}; separator=\", \"$");
        stringTemplate.setErrorListener(errorBuffer);
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        stringTemplate.toString();
        String string = "missing arguments in anonymous template in context [anonymous]";
        TestStringTemplate.assertEquals(string, ((Object)errorBuffer).toString());
    }

    public void testParallelAttributeIterationWithDifferentSizesTemplateRefInsideToo() throws Exception {
        String string = "group test;" + newline + "page(names,phones,salaries) ::= " + newline + "\t<<$names,phones,salaries:{n,p,s | $value(n)$@$value(p)$: $value(s)$}; separator=\", \"$>>" + newline + "value(x=\"n/a\") ::= \"$x$\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), DefaultTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("page");
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("phones", "2");
        stringTemplate.setAttribute("salaries", "big");
        String string2 = "Ter@1: big, Tom@2: n/a, Sriram@n/a: n/a";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testAnonTemplateOnLeftOfApply() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("${foo}:{($it$)}$");
        String string = "(foo)";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testOverrideThroughConditional() throws Exception {
        String string = "group base;" + newline + "body(ick) ::= \"<if(ick)>ick<f()><else><f()><endif>\"" + "f() ::= \"foo\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        String string2 = "group sub;" + newline + "f() ::= \"bar\"" + newline;
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup(new StringReader(string2), AngleBracketTemplateLexer.class, null, stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("body");
        String string3 = "bar";
        String string4 = stringTemplate.toString();
        TestStringTemplate.assertEquals(string3, string4);
    }

    public void testNonPublicPropertyAccess() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$x.foo$:$x.bar$");
        Object object = new Object(){
            public int foo = 9;

            public int getBar() {
                return 34;
            }
        };
        stringTemplate.setAttribute("x", object);
        String string = "9:34";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testIndexVar() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{$i$. $it$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        String string = "1. parrt" + newline + "2. tombu";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testIndex0Var() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A:{$i0$. $it$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        String string = "0. parrt" + newline + "1. tombu";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testIndexVarWithMultipleExprs() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A,B:{a,b|$i$. $a$@$b$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        stringTemplate.setAttribute("B", "x5707");
        stringTemplate.setAttribute("B", "x5000");
        String string = "1. parrt@x5707" + newline + "2. tombu@x5000";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testIndex0VarWithMultipleExprs() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$A,B:{a,b|$i0$. $a$@$b$}; separator=\"\\n\"$");
        stringTemplate.setAttribute("A", "parrt");
        stringTemplate.setAttribute("A", "tombu");
        stringTemplate.setAttribute("B", "x5707");
        stringTemplate.setAttribute("B", "x5000");
        String string = "0. parrt@x5707" + newline + "1. tombu@x5000";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testArgumentContext() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("main", "$foo(t={Hi, $name$}, name=\"parrt\")$");
        stringTemplateGroup.defineTemplate("foo", "$t$");
        String string = "Hi, parrt";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNoDotsInAttributeNames() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".");
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "$user.Name$");
        String string = null;
        try {
            stringTemplate.setAttribute("user.Name", "Kunle");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = illegalArgumentException.getMessage();
        }
        String string2 = "cannot have '.' in attribute names";
        TestStringTemplate.assertEquals(string2, string);
    }

    public void testNoDotsInTemplateNames() throws Exception {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        String string = "group test;" + newline + "a.b() ::= <<foo>>" + newline;
        new StringTemplateGroup(new StringReader(string), DefaultTemplateLexer.class, errorBuffer);
        String string2 = "template group parse error: line 2:1: unexpected token:";
        TestStringTemplate.assertTrue(((Object)errorBuffer).toString().startsWith(string2));
    }

    public void testLineWrap() throws Exception {
        String string = "group test;" + newline + "array(values) ::= <<int[] a = { <values; wrap=\"\\n\", separator=\",\"> };>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String string2 = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n2,1,6,32,5,6,77,4,9,20,2,1,4,63,9,20,2,1,\n4,6,32,5,6,77,6,32,5,6,77,3,9,20,2,1,4,6,\n32,5,6,77,888,1,6,32,5 };";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(40));
    }

    public void testLineWrapWithNormalizedNewlines() throws Exception {
        String string = "group test;" + newline + "array(values) ::= <<int[] a = { <values; wrap=\"\\r\\n\", separator=\",\"> };>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String string2 = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n2,1,6,32,5,6,77,4,9,20,2,1,4,63,9,20,2,1,\n4,6,32,5,6,77,6,32,5,6,77,3,9,20,2,1,4,6,\n32,5,6,77,888,1,6,32,5 };";
        StringWriter stringWriter = new StringWriter();
        AutoIndentWriter autoIndentWriter = new AutoIndentWriter(stringWriter, "\n");
        autoIndentWriter.setLineWidth(40);
        stringTemplate.write(autoIndentWriter);
        String string3 = stringWriter.toString();
        TestStringTemplate.assertEquals(string2, string3);
    }

    public void testLineWrapAnchored() throws Exception {
        String string = "group test;" + newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String string2 = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(40));
    }

    public void testFortranLineWrap() throws Exception {
        String string = "group test;" + newline + "func(args) ::= <<       FUNCTION line( <args; wrap=\"\\n      c\", separator=\",\"> )>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("func");
        stringTemplate.setAttribute("args", (Object)new String[]{"a", "b", "c", "d", "e", "f"});
        String string2 = "       FUNCTION line( a,b,c,d,\n      ce,f )";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(30));
    }

    public void testLineWrapWithDiffAnchor() throws Exception {
        String string = "group test;" + newline + "array(values) ::= <<int[] a = { <{1,9,2,<values; wrap, separator=\",\">}; anchor> };>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("array");
        stringTemplate.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6});
        String string2 = "int[] a = { 1,9,2,3,9,20,2,1,4,\n            6,32,5,6,77,888,2,\n            1,6,32,5,6,77,4,9,\n            20,2,1,4,63,9,20,2,\n            1,4,6 };";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(30));
    }

    public void testLineWrapEdgeCase() throws Exception {
        String string = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "abc\nde";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(3));
    }

    public void testLineWrapLastCharIsNewline() throws Exception {
        String string = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "\n", "d", "e"});
        String string2 = "ab\nde";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(3));
    }

    public void testLineWrapCharAfterWrapIsNewline() throws Exception {
        String string = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "\n", "d", "e"});
        String string2 = "abc\n\nde";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(3));
    }

    public void testLineWrapForAnonTemplate() throws Exception {
        String string = "group test;" + newline + "duh(data) ::= <<!<data:{v|[<v>]}; wrap>!>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String string2 = "![1][2][3]\n[4][5][6]\n[7][8][9]!";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(9));
    }

    public void testLineWrapForAnonTemplateAnchored() throws Exception {
        String string = "group test;" + newline + "duh(data) ::= <<!<data:{v|[<v>]}; anchor, wrap>!>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String string2 = "![1][2][3]\n [4][5][6]\n [7][8][9]!";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(9));
    }

    public void testLineWrapForAnonTemplateComplicatedWrap() throws Exception {
        String string = "group test;" + newline + "top(s) ::= <<  <s>.>>" + "str(data) ::= <<!<data:{v|[<v>]}; wrap=\"!+\\n!\">!>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("str");
        stringTemplate2.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        stringTemplate.setAttribute("s", stringTemplate2);
        String string2 = "  ![1][2]!+\n  ![3][4]!+\n  ![5][6]!+\n  ![7][8]!+\n  ![9]!.";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(9));
    }

    public void testIndentBeyondLineWidth() throws Exception {
        String string = "group test;" + newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "    a\n    b\n    c\n    d\n    e";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(2));
    }

    public void testIndentedExpr() throws Exception {
        String string = "group test;" + newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String string2 = "    ab\n    cd\n    e";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(6));
    }

    public void testNestedIndentedExpr() throws Exception {
        String string = "group test;" + newline + "top(d) ::= <<  <d>!>>" + newline + "duh(chars) ::= <<  <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate2.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        stringTemplate.setAttribute("d", stringTemplate2);
        String string2 = "    ab\n    cd\n    e!";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(6));
    }

    public void testNestedWithIndentAndTrackStartOfExpr() throws Exception {
        String string = "group test;" + newline + "top(d) ::= <<  <d>!>>" + newline + "duh(chars) ::= <<x: <chars; anchor, wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("duh");
        stringTemplate2.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        stringTemplate.setAttribute("d", stringTemplate2);
        String string2 = "  x: ab\n     cd\n     e!";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(7));
    }

    public void testLineDoesNotWrapDueToLiteral() throws Exception {
        String string = "group test;" + newline + "m(args,body) ::= <<public void foo(<args; wrap=\"\\n\",separator=\", \">) throws Ick { <body> }>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("m");
        stringTemplate.setAttribute("args", (Object)new String[]{"a", "b", "c"});
        stringTemplate.setAttribute("body", "i=3;");
        int n2 = "public void foo(a, b, c".length();
        String string2 = "public void foo(a, b, c) throws Ick { i=3; }";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(n2));
    }

    public void testSingleValueWrap() throws Exception {
        String string = "group test;" + newline + "m(args,body) ::= <<{ <body; anchor, wrap=\"\\n\"> }>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("m");
        stringTemplate.setAttribute("body", "i=3;");
        String string2 = "{ \n  i=3; }";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(2));
    }

    public void testLineWrapInNestedExpr() throws Exception {
        String string = "group test;" + newline + "top(arrays) ::= <<Arrays: <arrays>done>>" + newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };<\\n\\>>>" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("top");
        StringTemplate stringTemplate2 = stringTemplateGroup.getInstanceOf("array");
        stringTemplate2.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        stringTemplate.setAttribute("arrays", stringTemplate2);
        stringTemplate.setAttribute("arrays", stringTemplate2);
        String string2 = "Arrays: int[] a = { 3,9,20,2,1,4,6,32,5,\n                    6,77,888,2,1,6,32,5,\n                    6,77,4,9,20,2,1,4,63,\n                    9,20,2,1,4,6,32,5,6,\n                    77,6,32,5,6,77,3,9,20,\n                    2,1,4,6,32,5,6,77,888,\n                    1,6,32,5 };\nint[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };\ndone";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString(40));
    }

    public void testEscapeEscape() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test");
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "\\\\$v$");
        stringTemplate.setAttribute("v", "Joe");
        String string = "\\Joe";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testEscapeEscapeNestedAngle() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<v:{a|\\\\<a>}>");
        stringTemplate.setAttribute("v", "Joe");
        String string = "\\Joe";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testListOfIntArrays() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array()>");
        stringTemplateGroup.defineTemplate("array", "[<it:element(); separator=\",\">]");
        stringTemplateGroup.defineTemplate("element", "<it>");
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        arrayList.add(new int[]{1, 2, 3});
        arrayList.add(new int[]{10, 20, 30});
        stringTemplate.setAttribute("data", arrayList);
        String string = "[1,2,3][10,20,30]";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullOptionSingleNullValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"0\">");
        String string = "0";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullOptionHasEmptyNullValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"\", separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        stringTemplate.setAttribute("data", arrayList);
        String string = ", 1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullOptionSingleNullValueInList() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"0\">");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "0";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullValueInList() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; null=\"-1\", separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        arrayList.add(null);
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1, 1, -1, 3, 4, -1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullValueInListNoNullOption() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data; separator=\", \">");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(1));
        arrayList.add(null);
        arrayList.add(new Integer(3));
        arrayList.add(new Integer(4));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "1, 3, 4";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        arrayList.add(null);
        arrayList.add(new Integer(2));
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "0, -1, 2, -1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullValueInListWithTemplateApplyNullFirstValue() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(null);
        arrayList.add(new Integer(0));
        arrayList.add(null);
        arrayList.add(new Integer(2));
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1, 0, -1, 2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullSingleValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "-1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testNullSingleValueWithTemplateApply() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = stringTemplateGroup.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        stringTemplateGroup.defineTemplate("array", "<it>");
        String string = "-1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOp() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("names", "Tom");
        stringTemplate.setAttribute("names", "Sriram");
        String string = "3";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpWithMap() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Tom", "foo");
        hashMap.put("Sriram", "foo");
        hashMap.put("Doug", "foo");
        stringTemplate.setAttribute("names", hashMap);
        String string = "3";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpWithSet() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Tom");
        hashSet.add("Sriram");
        hashSet.add("Doug");
        stringTemplate.setAttribute("names", hashSet);
        String string = "3";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpNull() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", (Object)null);
        String string = "0";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpSingleValue() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(names)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        String string = "1";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpPrimitive() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(ints)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("ints", (Object)new int[]{1, 2, 3, 4});
        String string = "4";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpOfListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "4";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testStripOpOfListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "Himom";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testStripOpOfListOfListsWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data):{list | $strip(list)$}; separator=\",\"$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Hi");
        arrayList2.add("mom");
        arrayList.add(arrayList2);
        arrayList.add(null);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("Hi");
        arrayList3.add(null);
        arrayList3.add("dad");
        arrayList3.add(null);
        arrayList.add(arrayList3);
        stringTemplate.setAttribute("data", arrayList);
        String string = "Himom,Hidad";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testStripOpOfSingleAlt() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("data", "hi");
        String string = "hi";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testStripOpOfNull() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$strip(data)$");
        stringTemplate = stringTemplate.getInstanceOf();
        String string = "";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testReUseOfStripResult() throws Exception {
        String string = "group test;" + newline + "a(names) ::= \"<b(strip(names))>\"" + newline + "b(x) ::= \"<x>, <x>\"" + newline;
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new StringReader(string));
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("a");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Ter");
        arrayList.add(null);
        arrayList.add("Tom");
        stringTemplate.setAttribute("names", arrayList);
        String string2 = "TerTom, TerTom";
        TestStringTemplate.assertEquals(string2, stringTemplate.toString());
    }

    public void testLengthOpOfStrippedListWithNulls() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(strip(data))$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testLengthOpOfStrippedListWithNullsFrontAndBack() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$length(strip(data))$");
        stringTemplate = stringTemplate.getInstanceOf();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add("Hi");
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add("mom");
        arrayList.add(null);
        arrayList.add(null);
        arrayList.add(null);
        stringTemplate.setAttribute("data", arrayList);
        String string = "2";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public void testMapKeys() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<aMap.keys:{k|<k>:<aMap.(k)>}; separator=\", \">");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("int", "0");
        linkedHashMap.put("float", "0.0");
        stringTemplate.setAttribute("aMap", linkedHashMap);
        TestStringTemplate.assertEquals("int:0, float:0.0", stringTemplate.toString());
    }

    public void testMapValues() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<aMap.values; separator=\", \"> <aMap.(\"i\"+\"nt\")>");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("int", "0");
        linkedHashMap.put("float", "0.0");
        stringTemplate.setAttribute("aMap", linkedHashMap);
        TestStringTemplate.assertEquals("0, 0.0 0", stringTemplate.toString());
    }

    public void testMapKeysWithIntegerType() throws Exception {
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate stringTemplate = new StringTemplate(stringTemplateGroup, "<aMap.keys:{k|<k>:<aMap.(k)>}; separator=\", \">");
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        hashMap.put(new Integer(1), new ArrayList(){
            {
                this.add("ick");
                this.add("foo");
            }
        });
        hashMap.put(new Integer(2), new ArrayList(){
            {
                this.add("x");
                this.add("y");
            }
        });
        stringTemplate.setAttribute("aMap", hashMap);
        TestStringTemplate.assertEquals("2:xy, 1:ickfoo", stringTemplate.toString());
    }

    public void testSuperReferenceInIfClause() throws Exception {
        String string = "group super;" + newline + "a(x) ::= \"super.a\"" + newline + "b(x) ::= \"<c()>super.b\"" + newline + "c() ::= \"super.c\"";
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup((Reader)new StringReader(string), AngleBracketTemplateLexer.class);
        String string2 = "group sub;\na(x) ::= \"<if(x)><super.a()><endif>\"" + newline + "b(x) ::= \"<if(x)><else><super.b()><endif>\"" + newline + "c() ::= \"sub.c\"";
        StringTemplateGroup stringTemplateGroup2 = new StringTemplateGroup((Reader)new StringReader(string2), AngleBracketTemplateLexer.class);
        stringTemplateGroup2.setSuperGroup(stringTemplateGroup);
        StringTemplate stringTemplate = stringTemplateGroup2.getInstanceOf("a");
        stringTemplate.setAttribute("x", "foo");
        TestStringTemplate.assertEquals("super.a", stringTemplate.toString());
        StringTemplate stringTemplate2 = stringTemplateGroup2.getInstanceOf("b");
        TestStringTemplate.assertEquals("sub.csuper.b", stringTemplate2.toString());
        StringTemplate stringTemplate3 = stringTemplateGroup2.getInstanceOf("c");
        TestStringTemplate.assertEquals("sub.c", stringTemplate3.toString());
    }

    public void testListLiteralWithEmptyElements() throws Exception {
        StringTemplate stringTemplate = new StringTemplate("$[\"Ter\",,\"Jesse\"]:{n | $i$:$n$}; separator=\", \", null=\"\"$");
        stringTemplate = stringTemplate.getInstanceOf();
        stringTemplate.setAttribute("names", "Ter");
        stringTemplate.setAttribute("phones", "1");
        stringTemplate.setAttribute("salaries", "big");
        String string = "1:Ter, 2:, 3:Jesse";
        TestStringTemplate.assertEquals(string, stringTemplate.toString());
    }

    public static void writeFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("can't write file");
            iOException.printStackTrace(System.err);
        }
    }

    public static class NonPublicProperty {
    }

    public class StringRenderer
    implements AttributeRenderer {
        public String toString(Object object) {
            return (String)object;
        }

        public String toString(Object object, String string) {
            if (string.equals("upper")) {
                return ((String)object).toUpperCase();
            }
            return this.toString(object);
        }
    }

    public class DateRenderer3
    implements AttributeRenderer {
        public String toString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            return simpleDateFormat.format(((Calendar)object).getTime());
        }

        public String toString(Object object, String string) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            return simpleDateFormat.format(((Calendar)object).getTime());
        }
    }

    public class DateRenderer2
    implements AttributeRenderer {
        public String toString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            return simpleDateFormat.format(((Calendar)object).getTime());
        }

        public String toString(Object object, String string) {
            return this.toString(object);
        }
    }

    public class DateRenderer
    implements AttributeRenderer {
        public String toString(Object object) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
            return simpleDateFormat.format(((Calendar)object).getTime());
        }

        public String toString(Object object, String string) {
            return this.toString(object);
        }
    }

    static class Duh {
        public List users = new ArrayList();

        Duh() {
        }
    }

    public static class Decl {
        String name;
        String type;

        public Decl(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Connector3 {
        public int[] getValues() {
            return new int[]{1, 2, 3};
        }

        public Map getStuff() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("a", "1");
            linkedHashMap.put("b", "2");
            return linkedHashMap;
        }
    }

    public static class Tree {
        protected List children = new LinkedList();
        protected String text;

        public Tree(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public void addChild(Tree tree) {
            this.children.add(tree);
        }

        public Tree getFirstChild() {
            if (this.children.size() == 0) {
                return null;
            }
            return (Tree)this.children.get(0);
        }

        public List getChildren() {
            return this.children;
        }
    }

    public class Connector2 {
        public int getID() {
            return 2;
        }

        public String getFirstName() {
            return "Tom";
        }

        public String getLastName() {
            return "Burns";
        }

        public String getEmail() {
            return "tombu@jguru.com";
        }

        public String getBio() {
            return "Superhero by day...";
        }

        public Boolean getCanEdit() {
            return new Boolean(true);
        }
    }

    public class Connector {
        public int getID() {
            return 1;
        }

        public String getFirstName() {
            return "Terence";
        }

        public String getLastName() {
            return "Parr";
        }

        public String getEmail() {
            return "parrt@jguru.com";
        }

        public String getBio() {
            return "Superhero by night...";
        }

        public boolean getCanEdit() {
            return false;
        }
    }

    static class ErrorBuffer
    implements StringTemplateErrorListener {
        StringBuffer errorOutput = new StringBuffer(500);
        int n = 0;

        ErrorBuffer() {
        }

        public void error(String string, Throwable throwable) {
            ++this.n;
            if (this.n > 1) {
                this.errorOutput.append('\n');
            }
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.errorOutput.append(string + ": " + stringWriter.toString());
            } else {
                this.errorOutput.append(string);
            }
        }

        public void warning(String string) {
            ++this.n;
            this.errorOutput.append(string);
        }

        public boolean equals(Object object) {
            String string = this.toString();
            String string2 = object.toString();
            return string.equals(string2);
        }

        public String toString() {
            return this.errorOutput.toString();
        }
    }
}

