/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.ucf.DetachedPKCS7Signer;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCFPackager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class UCF {
    public static final String PATH_MIMETYPE = "mimetype";
    public static final String PATH_SIGNATURES = "META-INF/signatures.xml";
    public static final int ERROR_UNKNOWN = 5;
    public static final int ERROR_DEST = 6;
    public static final int ERROR_CERT_ACCESS = 7;
    public static final int ERROR_INVALID_CERT = 8;
    public static final int ERROR_CODE_SIGN = 9;
    public static final int ERROR_TIMESTAMP_GEN = 10;
    public static final int ERROR_CERTIFICATE_GEN = 11;
    public static final int ERROR_INVALID_INPUT = 12;
    protected static final String ARG_STORETYPE = "-storetype";
    protected static final String ARG_KEYSTORE = "-keystore";
    protected static final String ARG_STOREPASS = "-storepass";
    protected static final String ARG_KEYPASS = "-keypass";
    protected static final String ARG_PROVIDER_NAME = "-providerName";
    protected static final String ARG_ALIAS = "-alias";
    protected static final String ARG_TIMESTAMPURL = "-tsa";
    protected static final String ARG_OLD_TS = "-backwardCompatibleTimestamps";
    protected static final String ARG_HELP = "-help";
    protected static final String ARG_PACKAGE = "-package";
    protected static final String ARG_CHANGE_DIR = "-C";
    protected static final String ARG_RENAME = "-e";
    protected static final String ARG_DETACHED_PKCS7_SIG = "-detached-pkcs7-sig";
    protected static final String TSA_NONE = "none";
    protected Arguments args;
    protected File cwd = new File(System.getProperty("user.dir"));
    private Packager m_packager;

    public static String stringFromInputStream(InputStream is) throws IOException {
        int bytesRead;
        StringBuffer result = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(is);
        char[] charBuf = new char[4096];
        while ((bytesRead = reader.read(charBuf)) != -1) {
            result.append(charBuf, 0, bytesRead);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        UCF ucf = new UCF();
        int result = ucf.doPackage(args);
        System.exit(result);
    }

    protected UCF() {
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  ucf -package SIGNING_OPTIONS? <ucf-file> <fileOrDir>* (( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ))*");
        System.err.println("  ucf -detached-pkcs7-sig SIGNING_OPTIONS <sig-file> <file-to-be-signed>");
        System.err.println("  ucf -help");
        System.err.println();
        System.err.println("SIGNING_OPTIONS: { -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )? }");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPackage(String[] argv) {
        block11: {
            this.args = new Arguments(argv);
            try {
                this.cwd = new File(System.getProperty("user.dir"));
                if (!this.args.peek()) {
                    this.printUsage();
                    break block11;
                }
                if (this.args.peek(ARG_HELP)) {
                    this.parseUsage();
                    break block11;
                }
                if (this.args.peek(ARG_PACKAGE)) {
                    this.parsePackage();
                    this.getUCFPackager().createPackage();
                    break block11;
                }
                if (this.args.peek(ARG_DETACHED_PKCS7_SIG)) {
                    this.parseDetachedPKCS7Sig();
                    break block11;
                }
                throw new UsageError("unexpected argument " + this.args.accept());
            }
            catch (UsageError e2) {
                System.err.println(e2.getMessage());
                this.printUsage();
                int n2 = e2.getExitCode();
                return n2;
            }
            catch (Exception e3) {
                System.err.println("Packaging failed: " + e3.getMessage());
                e3.printStackTrace();
                int n3 = 5;
                return n3;
            }
            finally {
                this.getPackager().close();
            }
        }
        return 0;
    }

    protected void parseUsage() throws UsageError {
        this.args.accept(ARG_HELP);
        this.printUsage();
    }

    private void parsePackage() throws UsageError {
        this.args.accept(ARG_PACKAGE);
        if (this.args.peek(ARG_STORETYPE)) {
            this.parseSigningOptions(this.getPackager());
        }
        try {
            this.getPackager().setOutput(new File(this.args.accept()));
        }
        catch (IOException ex) {
            throw new UsageError("unable to create temp file in output directory", 6);
        }
        this.parseFileArguments();
    }

    private void parseDetachedPKCS7Sig() throws UsageError {
        this.args.accept(ARG_DETACHED_PKCS7_SIG);
        DetachedPKCS7Signer signer = new DetachedPKCS7Signer();
        this.parseSigningOptions(signer);
        File outputFile = new File(this.args.accept());
        File fileToSign = new File(this.args.accept());
        this.args.done();
        try {
            signer.setInput(fileToSign);
        }
        catch (IOException ex) {
            throw new UsageError("Couldn't read input file", 8);
        }
        try {
            signer.setOutput(outputFile);
            signer.sign();
        }
        catch (GeneralSecurityException ex) {
            throw new UsageError("Failed to create signature", 9);
        }
        catch (IOException ex) {
            throw new UsageError("Failed to write output file", 6);
        }
    }

    protected boolean signingOptionNext(Arguments args) {
        return args.peek(ARG_ALIAS) || args.peek(ARG_STORETYPE) || args.peek(ARG_KEYSTORE) || args.peek(ARG_STOREPASS) || args.peek(ARG_KEYPASS) || args.peek(ARG_PROVIDER_NAME) || args.peek(ARG_TIMESTAMPURL) || args.peek(ARG_OLD_TS);
    }

    protected SigningOptions cacheSigningOptions() throws UsageError {
        SigningOptions options = new SigningOptions();
        while (this.cacheSigningOption(options)) {
        }
        if (options.storeType == null) {
            throw new UsageError("-storetype is required");
        }
        if (options.storePass == null) {
            options.storePass = options.storeType.equalsIgnoreCase("KeychainStore") ? "a" : this.readPassword();
        }
        return options;
    }

    protected boolean cacheSigningOption(SigningOptions options) throws UsageError {
        if (this.args.peek(ARG_STORETYPE)) {
            if (options.storeType != null) {
                throw new UsageError("-storetype already specified");
            }
            this.args.accept(ARG_STORETYPE);
            options.storeType = this.args.accept();
        } else if (this.args.peek(ARG_KEYSTORE)) {
            if (options.keyStoreFile != null) {
                throw new UsageError("-keystore already specified");
            }
            this.args.accept(ARG_KEYSTORE);
            options.keyStoreFile = this.args.accept();
        } else if (this.args.peek(ARG_STOREPASS)) {
            if (options.storePass != null) {
                throw new UsageError("-storepass already specified");
            }
            this.args.accept(ARG_STOREPASS);
            options.storePass = this.args.accept();
        } else if (this.args.peek(ARG_KEYPASS)) {
            if (options.keyPass != null) {
                throw new UsageError("-keypass already specified");
            }
            this.args.accept(ARG_KEYPASS);
            options.keyPass = this.args.accept();
        } else if (this.args.peek(ARG_PROVIDER_NAME)) {
            if (options.providerName != null) {
                throw new UsageError("-providerName already specified");
            }
            this.args.accept(ARG_PROVIDER_NAME);
            options.providerName = this.args.accept();
        } else if (this.args.peek(ARG_ALIAS)) {
            if (options.alias != null) {
                throw new UsageError("-alias already specified");
            }
            this.args.accept(ARG_ALIAS);
            options.alias = this.args.accept();
        } else if (this.args.peek(ARG_TIMESTAMPURL)) {
            if (options.timestampURL != null) {
                throw new UsageError("-tsa already specified");
            }
            this.args.accept(ARG_TIMESTAMPURL);
            options.timestampURL = this.args.accept();
        } else if (this.args.peek(ARG_OLD_TS)) {
            if (options.addOldTs) {
                throw new UsageError("-backwardCompatibleTimestamps already specified");
            }
            this.args.accept(ARG_OLD_TS);
            options.addOldTs = true;
        } else {
            return false;
        }
        return true;
    }

    protected void parseSigningOptions(ISigner p2) throws UsageError {
        this.processSigningOptions(p2, this.cacheSigningOptions());
    }

    protected void processSigningOptions(ISigner p2, SigningOptions options) throws UsageError {
        KeyStore keyStore = null;
        try {
            keyStore = options.providerName == null ? KeyStore.getInstance(options.storeType) : KeyStore.getInstance(options.storeType, options.providerName);
        }
        catch (KeyStoreException ex) {
            throw new UsageError("requested keystore type is not available", 7);
        }
        catch (NoSuchProviderException ex) {
            throw new UsageError("requested provider is not available", 7);
        }
        try {
            try {
                keyStore.load(options.keyStoreFile == null ? null : new FileInputStream(options.keyStoreFile), options.storePass.toCharArray());
            }
            catch (IOException ex) {
                throw new UsageError("could not load keystore file (password may be incorrect)", 7);
            }
            catch (CertificateException ex) {
                throw new UsageError("unable to load a certificate in this file", 7);
            }
            if (options.alias == null) {
                if (!keyStore.aliases().hasMoreElements()) {
                    throw new UsageError("The key could not be obtained. You may need to use the -keystore argument with the specified keystore type.", 7);
                }
                options.alias = keyStore.aliases().nextElement();
            }
            try {
                String pass = options.keyPass != null ? options.keyPass : options.storePass;
                PrivateKey key = (PrivateKey)keyStore.getKey(options.alias, pass.toCharArray());
                if (p2 != null) {
                    p2.setPrivateKey(key);
                }
            }
            catch (UnrecoverableKeyException ex) {
                throw new UsageError("unable to retrieve key (password may be incorrect)", 7);
            }
            try {
                if (p2 != null) {
                    p2.setSignerCertificate(keyStore.getCertificate(options.alias));
                }
                Certificate[] certChain = keyStore.getCertificateChain(options.alias);
                if (p2 != null) {
                    if (certChain == null) {
                        throw new UsageError("could not retreive certificate chain from keystore", 8);
                    }
                    p2.setCertificateChain(certChain);
                }
            }
            catch (CertificateExpiredException ex) {
                throw new UsageError("certificate has expired", 8);
            }
            catch (CertificateNotYetValidException ex) {
                throw new UsageError("certificate is not yet valid", 8);
            }
            catch (CertificateException ex) {
                throw new UsageError("not an X509 code-signing certificate", 8);
            }
            if (options.timestampURL != null) {
                p2.setTimestampURL(TSA_NONE.equals(options.timestampURL) ? null : options.timestampURL);
            }
            if (options.addOldTs) {
                p2.setAlsoIncludeOldStyleTimestamp();
            }
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("aliases accessed before keystore was loaded");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UsageError("required crypto algorithm not available", 7);
        }
    }

    protected void parseFileArguments() throws UsageError {
        if (!this.args.peek()) {
            throw new UsageError("at least one file is required");
        }
        this.parseOptionalFileList();
        while (this.args.peek()) {
            this.parseCORE();
        }
    }

    protected void parseFileList() throws UsageError {
        this.addFileOrDir(this.cwd, new File(this.args.accept()));
        this.parseOptionalFileList();
    }

    protected void parseOptionalFileList() throws UsageError {
        while (!this.args.peek(ARG_RENAME) && !this.args.peek(ARG_CHANGE_DIR) && this.args.peek()) {
            this.addFileOrDir(this.cwd, new File(this.args.accept()));
        }
    }

    protected void parseCORE() throws UsageError {
        if (this.args.peek(ARG_CHANGE_DIR)) {
            this.args.accept(ARG_CHANGE_DIR);
            this.cwd = new File(this.args.accept());
            this.parseFileList();
        } else if (this.args.peek(ARG_RENAME)) {
            this.args.accept(ARG_RENAME);
            File inputFile = new File(this.args.accept());
            String path = this.args.accept();
            try {
                this.getPackager().addSourceWithPath(inputFile, path);
            }
            catch (IllegalArgumentException e2) {
                throw new UsageError(e2.getLocalizedMessage() + ": " + path);
            }
        } else {
            throw new UsageError("unexpected argument " + this.args.accept());
        }
    }

    protected String readPassword() throws UsageError {
        String password = null;
        try {
            Object theConsole = System.class.getMethod("console", new Class[0]).invoke(null, (Object[])null);
            if (theConsole != null) {
                Method readPasswordMethod = theConsole.getClass().getMethod("readPassword", String.class, Object[].class);
                password = String.copyValueOf((char[])readPasswordMethod.invoke(theConsole, "password: ", null));
            }
        }
        catch (IllegalArgumentException e2) {
        }
        catch (SecurityException e3) {
        }
        catch (IllegalAccessException e4) {
        }
        catch (InvocationTargetException e5) {
        }
        catch (NoSuchMethodException e6) {
            // empty catch block
        }
        if (password == null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("password: ");
                password = reader.readLine();
            }
            catch (IOException ex) {
                throw new UsageError("could not read password from console", 7);
            }
        }
        return password;
    }

    protected void addFileOrDir(File cwd, File file) throws UsageError {
        if (!file.isAbsolute()) {
            file = new File(cwd, file.getPath());
        }
        if (!file.exists()) {
            throw new UsageError("no such file " + file.getPath());
        }
        if ((file = new File(file.toURI().normalize().getPath())).isHidden()) {
            return;
        }
        if (file.isFile()) {
            try {
                this.getPackager().addSourceWithRoot(file, cwd);
            }
            catch (IllegalArgumentException e2) {
                throw new UsageError(e2.getLocalizedMessage() + ": " + file.getPath());
            }
            return;
        }
        File[] dirContents = file.listFiles();
        for (int idx = 0; idx < dirContents.length; ++idx) {
            this.addFileOrDir(cwd, dirContents[idx]);
        }
    }

    protected Packager getPackager() {
        if (this.m_packager == null) {
            this.m_packager = new UCFPackager();
        }
        return this.m_packager;
    }

    private UCFPackager getUCFPackager() {
        return (UCFPackager)this.getPackager();
    }

    public class SigningOptions {
        public String storeType = null;
        public String keyStoreFile = null;
        public String storePass = null;
        public String keyPass = null;
        public String providerName = null;
        public String alias = null;
        public String timestampURL = null;
        public boolean addOldTs = false;
    }
}

