/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTException;
import com.adobe.air.ADTPackager;
import com.adobe.air.CertificateCreationException;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.pki.TimestampException;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.MessageFormat;

public abstract class ADTEntrypoint
extends UCF {
    public static final String MIMETYPE_AIR = "application/vnd.adobe.air-application-installer-package+zip";
    public static final String MIMETYPE_AIRI = "application/vnd.adobe.air-application-intermediate-package+zip";
    public static final String PATH_DESCRIPTOR = "META-INF/AIR/application.xml";
    public static final String PATH_HASH = "META-INF/AIR/hash";
    public static final String PATH_DEBUG = "META-INF/AIR/debug";
    protected static final String ARG_PACKAGE = "-package";
    protected static final String ARG_TARGET = "-target";
    protected static final String ARG_VERSION = "-version";
    private static final String ARG_DEBUG = "-Xdebug";
    protected static final String ARG_CONNECT = "-connect";
    protected static final String VERSION_STRING = "{0} version \"{1}\"";
    protected boolean m_debug;
    private int m_exitCode = 0;
    private Packager m_packager;

    public abstract String getExecutableName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int run(String[] argv) {
        this.args = new Arguments(argv);
        try {
            this.parseArgsAndGo();
        }
        catch (UsageError e2) {
            System.err.println(e2.getMessage());
            this.printUsage();
            this.m_exitCode = e2.getExitCode();
        }
        catch (CertificateNotYetValidException e3) {
            System.err.println(e3.getMessage());
            this.m_exitCode = 8;
        }
        catch (CertificateExpiredException e4) {
            String betterMessage = e4.getMessage().replace("NotAfter:", "Your certificate expired on");
            System.err.println(betterMessage);
            this.m_exitCode = 8;
        }
        catch (GeneralSecurityException e5) {
            System.err.println(e5.getMessage());
            this.m_exitCode = 9;
        }
        catch (TimestampException e6) {
            System.err.println(e6.getMessage());
            this.m_exitCode = 10;
        }
        catch (CertificateCreationException e7) {
            System.err.println(e7.getMessage());
            this.m_exitCode = 11;
        }
        catch (SDKDamagedException e8) {
            System.err.println("SDK is missing file " + e8.getMissingFilePath());
            this.m_exitCode = 5;
        }
        catch (ApplicationDescriptorValidationException e9) {
            System.out.println(e9.getMessage());
            this.m_exitCode = 12;
        }
        catch (InvalidInputException e10) {
            System.err.println(e10.getMessage());
            this.m_exitCode = 12;
        }
        catch (ADTException e11) {
            System.err.println(e11.getMessage());
            this.m_exitCode = e11.getExitCode();
        }
        catch (Exception e12) {
            System.err.println("unexpected failure: " + e12.getMessage());
            e12.printStackTrace();
            this.m_exitCode = 5;
        }
        finally {
            if (this.m_packager != null) {
                this.m_packager.close();
            }
        }
        return this.m_exitCode;
    }

    protected void parseArgsAndGo() throws UsageError, GeneralSecurityException, IOException {
        if (!this.args.peek()) {
            throw new UsageError("No arguments were found");
        }
        if (this.args.peek("-help")) {
            this.parseUsage();
        } else if (this.args.peek(ARG_PACKAGE)) {
            this.parsePackage();
            this.getADTPackager().createPackage();
        } else if (this.args.peek(ARG_VERSION)) {
            this.parseVersion();
        } else {
            throw new UsageError("unexpected argument " + this.args.accept());
        }
    }

    protected void parsePackage() throws UsageError {
        this.args.accept(ARG_PACKAGE);
        this.parseUndocumentedParams();
        this.parseAppSigningOptions();
        this.parseTarget();
        this.parseConnectOptions();
        this.parseNativeSigningOptions();
        this.parseOutput(this.getPackager(), this.getExtension());
        this.parseInput();
    }

    protected void parseUndocumentedParams() throws UsageError {
        while (this.parseUndocumentedParam()) {
        }
    }

    protected boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_DEBUG)) {
            this.args.accept(ARG_DEBUG);
            this.getADTPackager().setDebug(true);
            this.m_debug = true;
            return true;
        }
        return false;
    }

    protected abstract void parseConnectOptions() throws UsageError;

    protected void parseAppSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.parseSigningOptions(this.getPackager());
        }
    }

    protected abstract void parseTarget() throws UsageError;

    protected void parseNativeSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.parseSigningOptions(this.getPackager());
        }
    }

    protected void parseOutput(ISigner p2, String extension) throws UsageError {
        try {
            p2.setOutput(Utils.getFileWithExtension(this.args.accept(), extension));
        }
        catch (FileNotFoundException ex) {
            throw new UsageError("output directory is not writable", 6);
        }
        catch (IOException ex) {
            throw new UsageError("output file is not writable", 6);
        }
    }

    protected abstract String getExtension();

    protected void parseInput() throws UsageError {
        File firstFile = new File(this.args.accept()).getAbsoluteFile();
        if (this.args.peek()) {
            this.parseDescriptorAndFileset(firstFile);
        } else {
            if (!firstFile.exists()) {
                throw new UsageError("File " + firstFile.getPath() + " does not exist");
            }
            String mimetype = ADTEntrypoint.getAIRMimetype(firstFile);
            if (mimetype == MIMETYPE_AIR) {
                this.parseAIRFile(firstFile);
            } else if (mimetype == MIMETYPE_AIRI) {
                this.parseAIRIFile(firstFile);
            } else {
                throw new UsageError("File " + firstFile.getPath() + " is not a valid AIRI or AIR file", 12);
            }
        }
    }

    protected void parseDescriptorAndFileset(File descriptor) throws UsageError {
        this.getADTPackager().setDescriptor(descriptor);
        this.parseFileArguments();
    }

    protected void parseAIRFile(File airFile) throws UsageError {
        this.getADTPackager().setAIRFile(airFile);
    }

    protected void parseAIRIFile(File airiFile) throws UsageError {
        this.getADTPackager().setAIRIFile(airiFile);
    }

    private void parseVersion() throws UsageError {
        this.args.accept(ARG_VERSION);
        MessageFormat mf = new MessageFormat(VERSION_STRING);
        String version = mf.format(new Object[]{this.getExecutableName(), "2.0.1.12090"});
        System.out.println(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getAIRMimetype(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (file.isDirectory()) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] header = new byte[38];
            if (((InputStream)in).read(header) < header.length) {
                String string = null;
                return string;
            }
            byte[] mimeType = new byte[MIMETYPE_AIR.length()];
            if (((InputStream)in).read(mimeType) < mimeType.length) {
                String e2 = null;
                return e2;
            }
            if (MIMETYPE_AIR.equals(new String(mimeType))) {
                String e2 = MIMETYPE_AIR;
                return e2;
            }
            byte[] mimeTypeRemainder = new byte[MIMETYPE_AIRI.length() - MIMETYPE_AIR.length()];
            if (((InputStream)in).read(mimeTypeRemainder) < mimeTypeRemainder.length) {
                String string = null;
                return string;
            }
            if (MIMETYPE_AIRI.equals(new String(mimeType) + new String(mimeTypeRemainder))) {
                String string = MIMETYPE_AIRI;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e3) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e4) {}
        }
    }

    protected ADTPackager getADTPackager() {
        return (ADTPackager)this.getPackager();
    }

    protected Packager getPackager() {
        if (this.m_packager == null) {
            this.m_packager = this.newPackager();
        }
        return this.m_packager;
    }

    protected abstract Packager newPackager();
}

