/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class DeltaCRLIndicator
extends X509V3Extension
implements Cloneable,
Serializable,
CRLExtension {
    private byte[] a = null;
    ASN1Template b;

    private DeltaCRLIndicator(boolean bl2) {
        this.extensionTypeFlag = 27;
        this.criticality = bl2;
        this.setStandardOID(27);
        this.extensionTypeString = "DeltaCRLIndicator";
    }

    public DeltaCRLIndicator() {
        this(false);
        this.setDeltaCRLIndicator(0);
    }

    public DeltaCRLIndicator(int n2, boolean bl2) {
        this(bl2);
        this.setDeltaCRLIndicator(n2);
    }

    public DeltaCRLIndicator(byte[] byArray, int n2, int n3, boolean bl2) {
        this(bl2);
        this.setDeltaCRLIndicator(byArray, n2, n3);
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.a = new byte[integerContainer.dataLen];
            System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.a, 0, integerContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode DeltaCRLIndicator extension.");
        }
    }

    public void setDeltaCRLIndicator(int n2) {
        this.a = this.intToByteArray(n2);
    }

    public void setDeltaCRLIndicator(byte[] byArray, int n2, int n3) {
        this.a = new byte[n3];
        System.arraycopy(byArray, n2, this.a, 0, n3);
    }

    public int getDeltaCRLIndicator() throws CertificateException {
        if (this.a.length > 4) {
            throw new CertificateException("Can not represent integer in 32 bits.");
        }
        return this.byteArrayToInt(this.a);
    }

    public byte[] getDeltaCRLIndicatorAsByteArray() {
        return this.a;
    }

    public int derEncodeValueInit() {
        try {
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.a, 0, this.a.length, true);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DeltaCRLIndicator deltaCRLIndicator = new DeltaCRLIndicator();
        if (this.a != null) {
            deltaCRLIndicator.a = (byte[])this.a.clone();
        }
        if (this.b != null) {
            deltaCRLIndicator.derEncodeValueInit();
        }
        super.copyValues(deltaCRLIndicator);
        return deltaCRLIndicator;
    }

    protected void reset() {
        super.reset();
        this.setDeltaCRLIndicator(0);
        this.b = null;
    }
}

