/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.xml.NodeListImpl;
import com.rsa.certj.xml.Transformer;
import com.rsa.certj.xml.XMLException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Recode;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Base64Transformer
extends Transformer
implements Cloneable,
Serializable {
    private String a = Transformer.BASE64_LIST[0];

    public byte[] performTransformation(byte[] byArray, int n2, int n3) throws XMLException {
        return Base64Transformer.decodeBase64Data(byArray, n2, n3);
    }

    public NodeList performTransformation(NodeList nodeList) throws XMLException {
        if (nodeList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Base64Transformer.decodeElementData(nodeList.item(i2), stringBuffer);
            }
            Text text = nodeList.item(0).getOwnerDocument().createTextNode(stringBuffer.toString());
            NodeListImpl nodeListImpl = new NodeListImpl();
            nodeListImpl.add(text);
            return nodeListImpl;
        }
        return null;
    }

    protected static void decodeElementData(Node node, StringBuffer stringBuffer) throws XMLException {
        if (node != null && stringBuffer != null) {
            short s2 = node.getNodeType();
            switch (s2) {
                case 1: 
                case 5: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    byte[] byArray = node.getNodeValue().getBytes();
                    if (byArray == null) break;
                    byte[] byArray2 = Base64Transformer.decodeBase64Data(byArray, 0, byArray.length);
                    stringBuffer.append(new String(byArray2));
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    throw new XMLException("Unexpected node type:" + s2);
                }
            }
        }
    }

    public String getTransformAlgorithm() {
        return this.a;
    }

    protected void setTransformAlgorithm(String string) {
        this.a = string;
    }

    public static byte[] encodeBase64(byte[] byArray, int n2, int n3) throws XMLException {
        if (byArray == null || n3 == 0 || n2 < 0) {
            return null;
        }
        try {
            JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance("Base64-76", "Java");
            jSAFE_Recode.encodeInit();
            int n4 = jSAFE_Recode.getOutputBufferSize(n3);
            byte[] byArray2 = new byte[n4];
            int n5 = jSAFE_Recode.encodeUpdate(byArray, n2, n3, byArray2, 0);
            int n6 = jSAFE_Recode.encodeFinal(byArray2, n5);
            jSAFE_Recode.clearSensitiveData();
            int n7 = 0;
            for (int i2 = 0; i2 < n5 + n6; ++i2) {
                if (byArray2[i2] != 13) continue;
                ++n7;
            }
            byte[] byArray3 = new byte[n5 + n6 - n7];
            int n8 = 0;
            for (int i3 = 0; i3 < n5 + n6; ++i3) {
                byte by2 = byArray2[i3];
                if (by2 == 13) continue;
                byArray3[n8] = by2;
                ++n8;
            }
            return byArray3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new XMLException("Error in Base64 encoding: " + jSAFE_Exception.getMessage());
        }
    }

    public static byte[] decodeBase64Data(byte[] byArray, int n2, int n3) throws XMLException {
        if (byArray == null || n3 == 0 || n2 < 0) {
            return null;
        }
        try {
            JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance("Base64-76", "Java");
            jSAFE_Recode.decodeInit();
            int n4 = jSAFE_Recode.getOutputBufferSize(n3);
            byte[] byArray2 = new byte[n4];
            int n5 = jSAFE_Recode.decodeUpdate(byArray, n2, n3, byArray2, 0);
            int n6 = jSAFE_Recode.decodeFinal(byArray2, n5);
            byte[] byArray3 = new byte[n5 + n6];
            System.arraycopy(byArray2, 0, byArray3, 0, n5 + n6);
            jSAFE_Recode.clearSensitiveData();
            return byArray3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new XMLException("Error in Base64 decoding: " + jSAFE_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Base64Transformer base64Transformer = (Base64Transformer)super.clone();
        if (this.a != null) {
            base64Transformer.a = this.a;
        }
        return base64Transformer;
    }
}

