/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.Cq;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.util.Date;

class PKIHeader {
    protected int pvno = -1;
    protected GeneralName sender = null;
    protected GeneralName recipient = null;
    protected Date messageTime = null;
    protected Cq protectionAlg = null;
    protected Cq senderKID = null;
    protected Cq recipKID = null;
    protected Cq transactionID = null;
    protected Cq senderNonce = null;
    protected Cq recipNonce = null;
    protected String[] freeText = null;
    protected TypeAndValue[] generalInfo = null;
    private final int a = 16;
    private final int b = 16;
    private final int c = 16;

    protected PKIHeader(byte[] byArray, int n2) throws CMPException {
        Object object;
        IntegerContainer integerContainer = null;
        EncodedContainer encodedContainer = null;
        EncodedContainer encodedContainer2 = null;
        GenTimeContainer genTimeContainer = null;
        EncodedContainer encodedContainer3 = null;
        OctetStringContainer octetStringContainer = null;
        OctetStringContainer octetStringContainer2 = null;
        OctetStringContainer octetStringContainer3 = null;
        OctetStringContainer octetStringContainer4 = null;
        OctetStringContainer octetStringContainer5 = null;
        OfContainer ofContainer = null;
        OfContainer ofContainer2 = null;
        try {
            EndContainer endContainer = new EndContainer();
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            integerContainer = new IntegerContainer(0);
            encodedContainer = new EncodedContainer(65280);
            encodedContainer2 = new EncodedContainer(65280);
            genTimeContainer = new GenTimeContainer(0xA10000);
            encodedContainer3 = new EncodedContainer(10563585);
            octetStringContainer = new OctetStringContainer(10551298);
            octetStringContainer2 = new OctetStringContainer(10551299);
            octetStringContainer3 = new OctetStringContainer(10551300);
            octetStringContainer4 = new OctetStringContainer(10551301);
            octetStringContainer5 = new OctetStringContainer(10551302);
            ofContainer = new OfContainer(10551303, 12288, new EncodedContainer(3072));
            ofContainer2 = new OfContainer(10551304, 12288, new EncodedContainer(12288));
            object = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, genTimeContainer, encodedContainer3, octetStringContainer, octetStringContainer2, octetStringContainer3, octetStringContainer4, octetStringContainer5, ofContainer, ofContainer2, endContainer};
            ASN1.berDecode(byArray, n2, object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("PKIHeader.PKIHeader: decoding PKIHeader faild(" + aSN_Exception.getMessage() + ").");
        }
        try {
            this.pvno = integerContainer.getValueAsInt();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("PKIHeader.PKIHeader: unable to get PKIHeader.pvo as int(" + aSN_Exception.getMessage() + ").");
        }
        this.sender = this.a(encodedContainer, "sender");
        this.recipient = this.a(encodedContainer2, "recipient");
        if (genTimeContainer.dataPresent) {
            this.messageTime = genTimeContainer.theTime;
        }
        this.protectionAlg = this.a(encodedContainer3);
        this.senderKID = this.a(octetStringContainer);
        this.recipKID = this.a(octetStringContainer2);
        this.transactionID = this.a(octetStringContainer3);
        this.senderNonce = this.a(octetStringContainer4);
        this.recipNonce = this.a(octetStringContainer5);
        if (ofContainer.dataPresent) {
            int n3 = ofContainer.getContainerCount();
            this.freeText = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                try {
                    object = ofContainer.containerAt(i2);
                    UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{uTF8StringContainer};
                    ASN1.berDecode(object.data, object.dataOffset, aSN1ContainerArray);
                    if (uTF8StringContainer.dataPresent && uTF8StringContainer.dataLen != 0) {
                        this.freeText[i2] = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        continue;
                    }
                    this.freeText[i2] = null;
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("PKIHeader.PKIHeader: unable to extract and decode a freeText string(" + aSN_Exception.getMessage() + ").");
                }
            }
        }
        if (ofContainer2.dataPresent) {
            int n4 = ofContainer2.getContainerCount();
            this.generalInfo = new TypeAndValue[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                try {
                    object = ofContainer2.containerAt(i3);
                    this.generalInfo[i3] = new TypeAndValue(object.data, object.dataOffset, 0);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("PKIHeader.PKIHeader: unable to get an element of generalInfo(" + aSN_Exception.getMessage() + ").");
                }
            }
        }
    }

    protected PKIHeader(CMPRequestCommon cMPRequestCommon, CMPProtectInfo cMPProtectInfo, byte[] byArray, JSAFE_SecureRandom jSAFE_SecureRandom) throws CMPException {
        int n2 = cMPRequestCommon.getVersion();
        if (n2 > 0 && n2 != 2) {
            throw new CMPException("PKIHeader.PKIHeader: CMP version provided (" + cMPRequestCommon.getVersion() + ") does not match the supported version (" + 2 + ").");
        }
        this.pvno = 2;
        this.a(cMPProtectInfo);
        this.messageTime = cMPRequestCommon.getMessageTime();
        if (byArray != null) {
            this.protectionAlg = new Cq(this, byArray, null);
        }
        this.recipKID = null;
        this.a(cMPRequestCommon, jSAFE_SecureRandom);
        this.transactionID = new Cq(this, cMPRequestCommon.getTransactionID(), null);
        this.senderNonce = new Cq(this, this.a(jSAFE_SecureRandom, 16), null);
        if (cMPRequestCommon.getRecipNonce() != null) {
            this.recipNonce = new Cq(this, cMPRequestCommon.getRecipNonce(), null);
        }
        this.freeText = cMPRequestCommon.getFreeText();
        this.generalInfo = cMPRequestCommon.getGeneralInfo();
    }

    private void a(CMPProtectInfo cMPProtectInfo) throws CMPException {
        X509Certificate x509Certificate;
        if (cMPProtectInfo == null) {
            return;
        }
        if (cMPProtectInfo.pbmProtected()) {
            this.senderKID = new Cq(this, cMPProtectInfo.getKeyID(), null);
        } else {
            x509Certificate = cMPProtectInfo.getSenderCert();
            this.sender = this.a(x509Certificate);
            this.senderKID = this.b(x509Certificate);
        }
        x509Certificate = cMPProtectInfo.getRecipCert();
        if (x509Certificate != null) {
            this.recipient = this.a(x509Certificate);
            this.recipKID = this.b(x509Certificate);
        }
    }

    /*
     * Unable to fully structure code
     */
    private GeneralName a(X509Certificate var1_1) throws CMPException {
        var2_2 = null;
        var3_3 = var1_1.getSubjectName();
        if (var3_3 == null || var3_3.getRDNCount() == 0) {
            var4_4 = var1_1.getExtensions();
            if (var4_4 != null) {
                var5_6 = null;
                try {
                    var5_6 = (SubjectAltName)var4_4.getExtensionByType(17);
                }
                catch (CertificateException var6_7) {
                    throw new CMPException("PKIHeader.getSubjectName: unable to extract SubjectAltName extension(" + var6_7.getMessage() + ").");
                }
                if (var5_6 != null) {
                    try {
                        var6_8 = var5_6.getGeneralNames();
                        if (var6_8 == null || (var7_10 = var6_8.getNameCount()) <= 0) ** GOTO lbl28
                        var2_2 = var6_8.getGeneralName(0);
                    }
                    catch (NameException var6_9) {
                        throw new CMPException("PKIHeader.getSubjectName: unable to extract GeneralName from SubjectAltName(" + var6_9.getMessage() + ").");
                    }
                }
            }
        } else {
            try {
                var2_2 = new GeneralName();
                var2_2.setGeneralName(var3_3, 5);
            }
            catch (NameException var4_5) {
                throw new CMPException("PKIHeader.getSubjectName: unable to create a GeneralName(" + var4_5.getMessage() + ").");
            }
        }
lbl28:
        // 4 sources

        if (var2_2 == null) {
            var2_2 = this.a();
        }
        return var2_2;
    }

    private Cq b(X509Certificate x509Certificate) throws CMPException {
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions != null) {
            try {
                SubjectKeyID subjectKeyID = (SubjectKeyID)x509V3Extensions.getExtensionByType(14);
                if (subjectKeyID != null) {
                    return new Cq(this, subjectKeyID.getKeyID(), null);
                }
            }
            catch (CertificateException certificateException) {
                throw new CMPException("PKIHeader.getSubjectKID: unable to extract Subject Key ID extension.(" + certificateException.getMessage() + ").");
            }
        }
        return null;
    }

    protected byte[] derEncode() throws CMPException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.sender == null) {
            this.sender = this.a();
        }
        if (this.recipient == null) {
            this.recipient = this.a();
        }
        try {
            byArray = new byte[this.sender.getDERLen(0)];
            this.sender.getDEREncoding(byArray, 0, 0);
        }
        catch (NameException nameException) {
            throw new CMPException("PKIHeader.derEncode: unable to encode sender(" + nameException.getMessage() + ").");
        }
        try {
            byArray2 = new byte[this.recipient.getDERLen(0)];
            this.recipient.getDEREncoding(byArray2, 0, 0);
        }
        catch (NameException nameException) {
            throw new CMPException("PKIHeader.derEncode:  unable to encode recipient(" + nameException.getMessage() + ").");
        }
        try {
            byte[] byArray3;
            Object object;
            OfContainer ofContainer;
            OfContainer ofContainer2;
            EndContainer endContainer = new EndContainer();
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.pvno);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
            EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, byArray2.length);
            GenTimeContainer genTimeContainer = this.messageTime == null ? new GenTimeContainer(65536, false, 0, null) : new GenTimeContainer(0xA10000, true, 0, this.messageTime);
            EncodedContainer encodedContainer3 = this.protectionAlg == null ? new EncodedContainer(65536, false, 0, null, 0, 0) : new EncodedContainer(0, true, 0, Cq.a(this.protectionAlg), Cq.b(this.protectionAlg), Cq.c(this.protectionAlg));
            ASN1Container aSN1Container = this.a(this.senderKID, 2);
            ASN1Container aSN1Container2 = this.a(this.recipKID, 3);
            ASN1Container aSN1Container3 = this.a(this.transactionID, 4);
            ASN1Container aSN1Container4 = this.a(this.senderNonce, 5);
            ASN1Container aSN1Container5 = this.a(this.recipNonce, 6);
            if (this.freeText != null) {
                ofContainer2 = new OfContainer(10551303, true, 0, 12288, new EncodedContainer(3072));
                for (int i2 = 0; i2 < this.freeText.length; ++i2) {
                    byte[] byArray4 = this.freeText[i2].getBytes();
                    try {
                        ofContainer2.addContainer(new UTF8StringContainer(0, true, 0, byArray4, 0, byArray4.length));
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new CMPException("PKIHeader.derEncode: unable to add an element to freeText(" + aSN_Exception.getMessage() + ").");
                    }
                }
            } else {
                ofContainer2 = new OfContainer(65536, false, 0, 0, null);
            }
            if (this.generalInfo != null) {
                ofContainer = new OfContainer(10551304, true, 0, 12288, new EncodedContainer(12288));
                for (int i3 = 0; i3 < this.generalInfo.length; ++i3) {
                    object = this.generalInfo[i3];
                    byArray3 = new byte[((TypeAndValue)object).getDERLen(0)];
                    ((TypeAndValue)object).getDEREncoding(byArray3, 0, 0);
                    EncodedContainer encodedContainer4 = new EncodedContainer(0, true, 0, byArray3, 0, byArray3.length);
                    try {
                        ofContainer.addContainer(encodedContainer4);
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new CMPException("PKIHeader.derEncode: unable to add an element to generalInfo(" + aSN_Exception.getMessage() + ").");
                    }
                }
            } else {
                ofContainer = new OfContainer(65536, false, 0, 0, null);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, genTimeContainer, encodedContainer3, aSN1Container, aSN1Container2, aSN1Container3, aSN1Container4, aSN1Container5, ofContainer2, ofContainer, endContainer};
            object = new ASN1Template(aSN1ContainerArray);
            byArray3 = new byte[((ASN1Template)object).derEncodeInit()];
            ((ASN1Template)object).derEncode(byArray3, 0);
            return byArray3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("PKIHeader.derEncode: encoding CMP PKIHeader faild(" + aSN_Exception.getMessage() + ").");
        }
    }

    protected byte[] getSenderKID() {
        return this.a(this.senderKID);
    }

    protected byte[] getRecipKID() {
        return this.a(this.recipKID);
    }

    protected byte[] getSenderNonce() {
        return this.a(this.senderNonce);
    }

    protected byte[] getRecipNonce() {
        return this.a(this.recipNonce);
    }

    protected byte[] getTransactionID() {
        return this.a(this.transactionID);
    }

    protected byte[] getProtectionAlg() {
        return this.a(this.protectionAlg);
    }

    private byte[] a(Cq cq) {
        if (cq == null) {
            return null;
        }
        return Cq.d(cq);
    }

    private void a(CMPRequestCommon cMPRequestCommon, JSAFE_SecureRandom jSAFE_SecureRandom) throws CMPException {
        byte[] byArray = cMPRequestCommon.getTransactionID();
        if (byArray != null) {
            return;
        }
        byArray = this.a(jSAFE_SecureRandom, 16);
        cMPRequestCommon.setTransactionID(byArray);
    }

    private byte[] a(JSAFE_SecureRandom jSAFE_SecureRandom, int n2) {
        byte[] byArray = new byte[n2];
        do {
            jSAFE_SecureRandom.generateRandomBytes(byArray, 0, byArray.length);
        } while ((byArray[0] & 0x80) != 0);
        return byArray;
    }

    private GeneralName a() throws CMPException {
        GeneralName generalName = new GeneralName();
        try {
            generalName.setGeneralName(new X500Name(), 5);
            return generalName;
        }
        catch (NameException nameException) {
            throw new CMPException("PKIHeader.createEmptyName: " + nameException.getMessage());
        }
    }

    private GeneralName a(ASN1Container aSN1Container, String string) throws CMPException {
        if (!aSN1Container.dataPresent || aSN1Container.dataLen == 0) {
            throw new CMPException("PKIHeader.decodeGeneralName: missing required field(" + string + ").");
        }
        try {
            return new GeneralName(aSN1Container.data, aSN1Container.dataOffset, 0);
        }
        catch (NameException nameException) {
            throw new CMPException("PKIHeader.decodeGeneralName: unable to decode a GeneralName in the " + string + " field(" + nameException.getMessage() + ").");
        }
    }

    private ASN1Container a(Cq cq, int n2) throws ASN_Exception {
        if (cq == null || Cq.c(cq) == 0) {
            return new EncodedContainer(65536, false, 0, null, 0, 0);
        }
        return new OctetStringContainer(0xA10000 | n2, true, 0, Cq.a(cq), Cq.b(cq), Cq.c(cq));
    }

    private Cq a(ASN1Container aSN1Container) {
        if (!aSN1Container.dataPresent) {
            return null;
        }
        return new Cq(this, aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen, null);
    }
}

