/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.EncryptedValue;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class POPOPrivKey
implements Cloneable,
Serializable {
    public static final int THIS_MESSAGE = 0;
    public static final int SUBSEQUENT_MESSAGE = 1;
    public static final int ENCRYPTED_CERT = 0;
    public static final int CHALLENGE_RESPONSE = 1;
    private ASN1Template a = null;
    private EncryptedValue b = null;
    private int c = -1;
    private int d = 0;
    private int e = -1;
    private CertJ f;
    private JSAFE_PublicKey g = null;
    private JSAFE_PrivateKey h = null;

    public void setType(int n2) throws CRMFException {
        if (n2 != 0 && n2 != 1) {
            throw new CRMFException("Invalid type.");
        }
        this.e = n2;
    }

    public int getType() {
        return this.e;
    }

    public void setEnvironment(CertJ certJ, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) {
        if (certJ != null) {
            this.f = certJ;
        }
        if (jSAFE_PublicKey != null) {
            this.g = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.h = jSAFE_PrivateKey;
        }
    }

    public void setEncryptedValue(EncryptedValue encryptedValue) throws CRMFException {
        if (this.e == 1) {
            throw new CRMFException("Wrong type: this object is of SUBSEQUENT_MESSAGE type");
        }
        if (encryptedValue == null) {
            throw new CRMFException("specified EncryptedValue is null");
        }
        try {
            this.b = (EncryptedValue)encryptedValue.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Encrypted Value." + cloneNotSupportedException.getMessage());
        }
    }

    public EncryptedValue getEncryptedValue() throws CRMFException {
        if (this.e == 1) {
            throw new CRMFException("Wrong type: this object is of SUBSEQUENT_MESSAGE type");
        }
        if (this.b == null) {
            return null;
        }
        try {
            return (EncryptedValue)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Invalid Encrypted Value." + cloneNotSupportedException.getMessage());
        }
    }

    public void setSubsequentMessage(int n2) throws CRMFException {
        if (n2 != 0 && n2 != 1) {
            throw new CRMFException("Invalid value for Subsequent Message.");
        }
        this.c = n2;
    }

    public int getSubsequentMessage() {
        return this.c;
    }

    public void decodePOPOPrivKey(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOPrivKey Encoding is null.");
        }
        this.d = n3;
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(n3);
            BitStringContainer bitStringContainer = new BitStringContainer(0x800000);
            IntegerContainer integerContainer = new IntegerContainer(0x800001);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, bitStringContainer, integerContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (bitStringContainer.dataPresent) {
                this.b = new EncryptedValue(this.f, this.g, this.h);
                this.b.decodeEncryptedValue(bitStringContainer.data, bitStringContainer.dataOffset, 0);
                this.e = 0;
            } else if (integerContainer.dataPresent) {
                this.c = integerContainer.getValueAsInt();
                if (this.c != 0 && this.c != 1) {
                    throw new CRMFException("Invalid value of Subsequent Message.");
                }
                this.e = 1;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Invalid POPOPrivKey encoding: " + aSN_Exception.getMessage());
        }
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOPrivKey Encoding is null.");
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) throws CRMFException {
        this.d = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified POPOPrivKey array is null.");
        }
        this.d = n3;
        int n4 = 0;
        try {
            if (this.a == null) {
                this.getDERLen(n3);
            }
            n4 = this.a.derEncode(byArray, n2);
            this.a = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CRMFException("Unable to encode POPOPrivKey." + aSN_Exception.getMessage());
        }
        return n4;
    }

    private int a() throws CRMFException {
        try {
            byte[] byArray = null;
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.b != null) {
                n2 = this.b.getDERLen(0);
                byArray = new byte[n2];
                n2 = this.b.getDEREncoding(byArray, 0, 0x800000);
                bl2 = true;
            } else if (this.c != -1) {
                bl3 = true;
            } else {
                throw new CRMFException("POPOPrivKey Data is not set.");
            }
            ChoiceContainer choiceContainer = new ChoiceContainer(this.d, 0);
            BitStringContainer bitStringContainer = new BitStringContainer(0x800000, bl2, 0, byArray, 0, n2);
            IntegerContainer integerContainer = new IntegerContainer(0x800001, bl3, 0, this.c);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, bitStringContainer, integerContainer, endContainer};
            this.a = new ASN1Template(aSN1ContainerArray);
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            POPOPrivKey pOPOPrivKey = new POPOPrivKey();
            pOPOPrivKey.e = this.e;
            pOPOPrivKey.c = this.c;
            if (this.b != null) {
                pOPOPrivKey.b = (EncryptedValue)this.b.clone();
            }
            if (this.f != null) {
                pOPOPrivKey.setEnvironment(this.f, this.g, this.h);
            }
            if (this.a != null) {
                pOPOPrivKey.a();
            }
            pOPOPrivKey.d = this.d;
            return pOPOPrivKey;
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof POPOPrivKey)) {
            return false;
        }
        POPOPrivKey pOPOPrivKey = (POPOPrivKey)object;
        if (this.e != pOPOPrivKey.e) {
            return false;
        }
        if (this.b != null ? !this.b.equals(pOPOPrivKey.b) : pOPOPrivKey.b != null) {
            return false;
        }
        return pOPOPrivKey.c == this.c;
    }
}

