/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class QCStatements
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector[] a = this.a();
    ASN1Template b;

    public QCStatements() {
        this.extensionTypeFlag = 123;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    public QCStatements(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, boolean bl2) throws CertificateException {
        this.addQCStatement(byArray, n2, n3, byArray2, n4, n5);
        this.extensionTypeFlag = 123;
        this.criticality = bl2;
        this.setSpecialOID(X509V3Extension.QC_STATEMENTS_OID);
        this.extensionTypeString = "QC_Statements";
    }

    private Vector[] a() {
        Vector[] vectorArray = new Vector[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            vectorArray[i2] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null || n2 < 0) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                EncodedContainer encodedContainer = new EncodedContainer(130816);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
                ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray2);
                if (encodedContainer.dataPresent) {
                    this.addQCStatement(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                    continue;
                }
                this.addQCStatement(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, null, 0, 0);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode QCStatements extension. " + aSN_Exception.getMessage());
        }
    }

    public void addQCStatement(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws CertificateException {
        if (byArray != null && n3 > 0 && n2 >= 0 && byArray.length >= n3 + n2) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            this.a[0].addElement(byArray3);
            if (byArray2 != null && n5 > 0 && n4 >= 0 && byArray2.length >= n5 + n4) {
                byte[] byArray4 = new byte[n5];
                System.arraycopy(byArray2, n4, byArray4, 0, n5);
                this.a[1].addElement(byArray4);
            } else {
                this.a[1].addElement(null);
            }
        } else {
            if (byArray == null) {
                throw new CertificateException("Statement ID cannot be null.");
            }
            throw new CertificateException("Invalid parameter");
        }
    }

    public byte[] getQCStatementID(int n2) throws CertificateException {
        if (this.a[0].size() <= n2) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[0].elementAt(n2);
    }

    public byte[] getQCStatementInfo(int n2) throws CertificateException {
        if (this.a[1].size() <= n2) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.a[1].elementAt(n2);
    }

    public int getQCStatementCount() {
        return this.a[0].size();
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, new EncodedContainer(12288));
            EndContainer endContainer = new EndContainer();
            vector.addElement(ofContainer);
            for (int i2 = 0; i2 < this.a[0].size(); ++i2) {
                byte[] byArray = (byte[])this.a[0].elementAt(i2);
                byte[] byArray2 = i2 < this.a[1].size() ? (byte[])this.a[1].elementAt(i2) : null;
                try {
                    SequenceContainer sequenceContainer = new SequenceContainer(0);
                    EndContainer endContainer2 = new EndContainer();
                    OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, byArray.length);
                    EncodedContainer encodedContainer = null;
                    encodedContainer = byArray2 != null ? new EncodedContainer(130816, true, 0, byArray2, 0, byArray2.length) : new EncodedContainer(130816, false, 0, null, 0, 0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer2};
                    this.asn1Template = new ASN1Template(aSN1ContainerArray);
                    int n2 = this.asn1Template.derEncodeInit();
                    byte[] byArray3 = new byte[n2];
                    n2 = this.asn1Template.derEncode(byArray3, 0);
                    EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray3, 0, n2);
                    ofContainer.addContainer(encodedContainer2);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        QCStatements qCStatements = new QCStatements();
        for (n2 = 0; n2 < this.a[0].size(); ++n2) {
            qCStatements.a[0].addElement(((byte[])this.a[0].elementAt(n2)).clone());
        }
        for (n2 = 0; n2 < this.a[1].size(); ++n2) {
            if (this.a[1].elementAt(n2) == null) {
                qCStatements.a[1].addElement(null);
                continue;
            }
            qCStatements.a[1].addElement(((byte[])this.a[1].elementAt(n2)).clone());
        }
        if (this.b != null) {
            qCStatements.derEncodeValueInit();
        }
        super.copyValues(qCStatements);
        return qCStatements;
    }

    protected void reset() {
        super.reset();
        this.a = this.a();
        this.b = null;
    }
}

