/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class EDIPartyName
implements Cloneable,
Serializable {
    private static final int a = 0xA10000;
    private static final int b = 0xA00001;
    private String c;
    private int d;
    private String e;
    private int f;
    protected static int special;
    private ASN1Template g;

    public EDIPartyName(byte[] byArray, int n2, int n3) throws NameException {
        block18: {
            this.c = null;
            this.d = 0;
            this.e = null;
            this.f = 0;
            this.g = null;
            if (byArray == null) {
                throw new NameException("Encoding is null.");
            }
            try {
                SequenceContainer sequenceContainer = new SequenceContainer(n3);
                EndContainer endContainer = new EndContainer();
                ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                BMPStringContainer bMPStringContainer = new BMPStringContainer(0);
                ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA00001);
                TeletexStringContainer teletexStringContainer2 = new TeletexStringContainer(0);
                PrintStringContainer printStringContainer2 = new PrintStringContainer(0);
                UniversalStringContainer universalStringContainer2 = new UniversalStringContainer(0);
                UTF8StringContainer uTF8StringContainer2 = new UTF8StringContainer(0);
                BMPStringContainer bMPStringContainer2 = new BMPStringContainer(0);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, teletexStringContainer, printStringContainer, universalStringContainer, uTF8StringContainer, bMPStringContainer, endContainer, choiceContainer2, teletexStringContainer2, printStringContainer2, universalStringContainer2, uTF8StringContainer2, bMPStringContainer2, endContainer, endContainer};
                ASN1.berDecode(byArray, n2, aSN1ContainerArray);
                if (choiceContainer.dataPresent) {
                    if (teletexStringContainer.dataPresent) {
                        this.c = teletexStringContainer.getValueAsString();
                        this.d = 5120;
                    } else if (printStringContainer.dataPresent) {
                        this.c = printStringContainer.getValueAsString();
                        this.d = 4864;
                    } else if (universalStringContainer.dataPresent) {
                        this.c = universalStringContainer.getValueAsString();
                        this.d = 7168;
                    } else if (uTF8StringContainer.dataPresent) {
                        this.c = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        this.d = 3072;
                    } else if (bMPStringContainer.dataPresent) {
                        this.c = bMPStringContainer.getValueAsString();
                        this.d = 7680;
                    }
                }
                if (teletexStringContainer2.dataPresent) {
                    this.e = teletexStringContainer2.getValueAsString();
                    this.f = 5120;
                    break block18;
                }
                if (printStringContainer2.dataPresent) {
                    this.e = printStringContainer2.getValueAsString();
                    this.f = 4864;
                    break block18;
                }
                if (universalStringContainer2.dataPresent) {
                    this.e = universalStringContainer2.getValueAsString();
                    this.f = 7168;
                    break block18;
                }
                if (uTF8StringContainer2.dataPresent) {
                    this.e = new String(uTF8StringContainer2.data, uTF8StringContainer2.dataOffset, uTF8StringContainer2.dataLen);
                    this.f = 3072;
                    break block18;
                }
                if (bMPStringContainer2.dataPresent) {
                    this.e = bMPStringContainer2.getValueAsString();
                    this.f = 7680;
                    break block18;
                }
                throw new NameException("Party Name field must be set!");
            }
            catch (ASN_Exception aSN_Exception) {
                throw new NameException("Cannot decode the BER of the name.");
            }
        }
    }

    public EDIPartyName() {
        this.c = null;
        this.d = 0;
        this.e = null;
        this.f = 0;
        this.g = null;
    }

    public void addNameAssigner(String string, int n2) {
        if (string != null) {
            this.c = string;
            this.d = n2 == 0 ? 7168 : n2;
        }
    }

    public void addPartyName(String string, int n2) {
        if (string != null) {
            this.e = string;
            this.f = n2 == 0 ? 7168 : n2;
        }
    }

    public String getNameAssigner() {
        return this.c;
    }

    public String getPartyName() {
        return this.e;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append(this.c);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.e);
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            block8: {
                int n4;
                block7: {
                    n4 = 0;
                    if (this.g == null) break block7;
                    if (n3 == special) break block8;
                }
                if ((n4 = this.getDERLen(n3)) == 0) {
                    throw new NameException("Unable to encode EDI Party Name.");
                }
            }
            int n5 = this.g.derEncode(byArray, n2);
            this.g = null;
            return n5;
        }
        catch (ASN_Exception aSN_Exception) {
            this.g = null;
            throw new NameException("Unable to encode EDI Party Name.");
        }
    }

    private int a() throws NameException {
        Object[] objectArray;
        SequenceContainer sequenceContainer = new SequenceContainer(special, true, 0);
        ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000, 0);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA00001, 0);
        EndContainer endContainer = new EndContainer();
        ASN1Container aSN1Container = null;
        ASN1Container aSN1Container2 = null;
        int n2 = Short.MAX_VALUE;
        if (this.e == null) {
            throw new NameException("PartyName is not set.");
        }
        try {
            switch (this.d) {
                case 5120: {
                    aSN1Container = new TeletexStringContainer(0, true, 0, this.c, 1, n2);
                    break;
                }
                case 4864: {
                    aSN1Container = new PrintStringContainer(0, true, 0, this.c, 1, n2);
                    break;
                }
                case 7168: {
                    aSN1Container = new UniversalStringContainer(0, true, 0, this.c, 1, n2);
                    break;
                }
                case 3072: {
                    if (this.c != null) {
                        objectArray = this.c.getBytes();
                        if (objectArray.length > n2) {
                            throw new NameException("Illegal name length");
                        }
                        aSN1Container = new UTF8StringContainer(0, true, 0, (byte[])objectArray, 0, objectArray.length);
                        break;
                    }
                    aSN1Container = new UTF8StringContainer(0, false, 0, null, 0, 0);
                    break;
                }
                case 7680: {
                    aSN1Container = new BMPStringContainer(0, true, 0, this.c, 1, n2);
                    break;
                }
            }
            switch (this.f) {
                case 5120: {
                    aSN1Container2 = new TeletexStringContainer(0, true, 0, this.e, 1, n2);
                    break;
                }
                case 4864: {
                    aSN1Container2 = new PrintStringContainer(0, true, 0, this.e, 1, n2);
                    break;
                }
                case 7168: {
                    aSN1Container2 = new UniversalStringContainer(0, true, 0, this.e, 1, n2);
                    break;
                }
                case 3072: {
                    objectArray = this.e.getBytes();
                    if (objectArray.length > n2) {
                        throw new NameException("Illegal name length");
                    }
                    aSN1Container2 = new UTF8StringContainer(0, true, 0, (byte[])objectArray, 0, objectArray.length);
                    break;
                }
                case 7680: {
                    aSN1Container2 = new BMPStringContainer(0, true, 0, this.e, 1, n2);
                    break;
                }
                default: {
                    throw new NameException("Illegal empty partyName value");
                }
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(aSN_Exception.getMessage());
        }
        if (aSN1Container == null) {
            objectArray = new ASN1Container[]{sequenceContainer, choiceContainer2, aSN1Container2, endContainer, endContainer};
            this.g = new ASN1Template((ASN1Container[])objectArray);
        } else {
            objectArray = new ASN1Container[]{sequenceContainer, choiceContainer, aSN1Container, endContainer, choiceContainer2, aSN1Container2, endContainer, endContainer};
            this.g = new ASN1Template((ASN1Container[])objectArray);
        }
        try {
            return this.g.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EDIPartyName)) {
            return false;
        }
        EDIPartyName eDIPartyName = (EDIPartyName)object;
        if (this.c != null ? !this.c.equals(eDIPartyName.c) : eDIPartyName.c != null) {
            return false;
        }
        return !(this.e != null ? !this.e.equals(eDIPartyName.e) : eDIPartyName.e != null);
    }

    public Object clone() throws CloneNotSupportedException {
        EDIPartyName eDIPartyName = new EDIPartyName();
        eDIPartyName.d = this.d;
        eDIPartyName.f = this.f;
        eDIPartyName.c = this.c;
        eDIPartyName.e = this.e;
        try {
            if (this.g != null) {
                eDIPartyName.a();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return eDIPartyName;
    }
}

