/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class V3ExtensionAttribute
extends X501Attribute
implements Cloneable,
Serializable {
    private X509V3Extensions a;
    ASN1Template b;

    public V3ExtensionAttribute() {
        super(2, "V3ExtensionAttribute");
    }

    public V3ExtensionAttribute(X509V3Extensions x509V3Extensions) {
        this();
        this.setV3ExtensionAttribute(x509V3Extensions);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer setContainer = new SetContainer(0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            this.a = new X509V3Extensions(encodedContainer.data, encodedContainer.dataOffset, 0, 1);
        }
        catch (ASN_Exception aSN_Exception) {
            this.reset();
            throw new AttributeException("Could not BER decode V3ExtensionAttribute.");
        }
        catch (CertificateException certificateException) {
            this.reset();
            throw new AttributeException("Could not create the attribute object: " + certificateException.getMessage());
        }
    }

    public void setV3ExtensionAttribute(X509V3Extensions x509V3Extensions) {
        try {
            if (x509V3Extensions != null) {
                this.a = (X509V3Extensions)x509V3Extensions.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.a = null;
        }
    }

    public X509V3Extensions getV3ExtensionAttribute() {
        if (this.a == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected int derEncodeValueInit() {
        this.b = null;
        if (this.a == null) {
            return 0;
        }
        int n2 = this.a.getDERLen(0);
        try {
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, encodedContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
        n3 += this.a.getDEREncoding(byArray, n2 + n3, 0);
        return n3;
    }

    public Object clone() throws CloneNotSupportedException {
        V3ExtensionAttribute v3ExtensionAttribute = new V3ExtensionAttribute();
        try {
            if (this.a != null) {
                v3ExtensionAttribute.a = (X509V3Extensions)this.a.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            v3ExtensionAttribute.a = null;
        }
        super.copyValues(v3ExtensionAttribute);
        return v3ExtensionAttribute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null || !(object instanceof V3ExtensionAttribute)) {
            return false;
        }
        V3ExtensionAttribute v3ExtensionAttribute = (V3ExtensionAttribute)object;
        if (this.a != null) {
            int n2;
            if (v3ExtensionAttribute.a == null) return false;
            int n3 = this.a.getDERLen(0);
            if (n3 != (n2 = v3ExtensionAttribute.a.getDERLen(0))) {
                return false;
            }
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n2];
            n3 = this.a.getDEREncoding(byArray, 0, 0);
            n2 = v3ExtensionAttribute.a.getDEREncoding(byArray2, 0, 0);
            if (CertJUtils.byteArraysEqual(byArray, byArray2)) return true;
            return false;
        }
        if (v3ExtensionAttribute.a == null) return true;
        return false;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

