/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertRequest;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.io.Serializable;
import java.security.SecureRandom;

public class PKCS10CertRequest
extends CertRequest
implements Cloneable,
Serializable {
    public static final int PKCS10_VERSION_1 = 0;
    private byte[] a;
    private byte[] b;
    private int c;
    private int d = 0;
    private X500Name e;
    private X501Attributes f;
    private ASN1Template g;
    protected int special;
    private ASN1Template h;
    protected int infoSpecial;

    public PKCS10CertRequest() {
    }

    public PKCS10CertRequest(CertJ certJ) {
        this.setCertJ(certJ);
    }

    public PKCS10CertRequest(byte[] byArray, int n2, int n3) throws CertificateException {
        this(byArray, n2, n3, null);
    }

    public PKCS10CertRequest(byte[] byArray, int n2, int n3, CertJ certJ) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a(byArray, n2, n3);
        this.setCertJ(certJ);
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null");
        }
        this.clearComponents();
        ASN1Container[] aSN1ContainerArray = PKCS10CertRequest.decodeRequest(byArray, n2, n3);
        this.a = new byte[aSN1ContainerArray[1].dataLen];
        System.arraycopy(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, this.a, 0, aSN1ContainerArray[1].dataLen);
        this.setCertRequestInfo(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, 0);
        this.signatureAlgorithmBER = new byte[aSN1ContainerArray[2].dataLen];
        System.arraycopy(aSN1ContainerArray[2].data, aSN1ContainerArray[2].dataOffset, this.signatureAlgorithmBER, 0, aSN1ContainerArray[2].dataLen);
        this.signature = new byte[aSN1ContainerArray[3].dataLen];
        System.arraycopy(aSN1ContainerArray[3].data, aSN1ContainerArray[3].dataOffset, this.signature, 0, aSN1ContainerArray[3].dataLen);
    }

    protected static ASN1Container[] decodeRequest(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(n3);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(768);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the request.");
        }
        return aSN1ContainerArray;
    }

    public int getDERLen(int n2) {
        return this.a(n2);
    }

    private int a(int n2) {
        this.special = n2;
        if (!this.signedByUs) {
            return 0;
        }
        if (this.b == null) {
            this.c = this.getCertRequestInfoDERLen(n2);
        }
        if (this.c == 0) {
            return 0;
        }
        if (this.signature == null || this.signatureAlgorithmBER == null) {
            return 0;
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, this.c);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer encodedContainer3 = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
            this.g = new ASN1Template(aSN1ContainerArray);
            return this.g.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Specified array is null.");
        }
        if (!this.signedByUs) {
            throw new CertificateException("Could not encode, missing data.");
        }
        int n4 = 0;
        try {
            if (this.g == null || n3 != this.special) {
                this.a(n3);
            }
            n4 += this.g.derEncode(byArray, n2);
            this.g = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.g = null;
            throw new CertificateException("Could not encode: " + aSN_Exception.getMessage());
        }
        if (this.b != null && this.c != 0 && this.infoSpecial == 0) {
            System.arraycopy(this.b, 0, byArray, n2 + n4, this.c);
            n4 += this.c;
        } else {
            int n5 = this.getCertRequestInfoDEREncoding(byArray, n2 + n4, 0);
            if (n5 == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            n4 += n5;
        }
        System.arraycopy(this.signatureAlgorithmBER, 0, byArray, n2 + n4, this.signatureAlgorithmBER.length);
        System.arraycopy(this.signature, 0, byArray, n2 + (n4 += this.signatureAlgorithmBER.length), this.signature.length);
        return n4 + this.signature.length;
    }

    public void setCertRequestInfo(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearSignature();
        this.clearTemplate();
        SequenceContainer sequenceContainer = new SequenceContainer(n3);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(8401152);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the request info.");
        }
        this.checkVersionNumber(-1, integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
        try {
            this.e = new X500Name(encodedContainer.data, encodedContainer.dataOffset, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not read the SubjectName: " + nameException.getMessage());
        }
        this.setSubjectPublicKey(encodedContainer2.data, encodedContainer2.dataOffset);
        try {
            this.f = new X501Attributes(encodedContainer3.data, encodedContainer3.dataOffset, 0x800000);
        }
        catch (AttributeException attributeException) {
            throw new CertificateException("Could not read the Attributes: " + attributeException.getMessage());
        }
    }

    protected void checkVersionNumber(int n2, byte[] byArray, int n3, int n4) throws CertificateException {
        if (n2 == -1) {
            if (byArray == null || n4 > 4) {
                throw new CertificateException("Invalid PKCS #10 Cert Request version.");
            }
            n2 = 0;
            for (int i2 = n3; i2 < n3 + n4; ++i2) {
                n2 = n2 << 8 | byArray[n3] & 0xFF;
            }
        }
        if (n2 != 0) {
            throw new CertificateException("Invalid PKCS #10 Cert Request version.");
        }
    }

    public int getCertRequestInfoDERLen(int n2) {
        return this.b(n2);
    }

    private int b(int n2) {
        this.infoSpecial = n2;
        if (this.subjectPublicKeyInfo == null || this.e == null) {
            return 0;
        }
        int n3 = this.e.getDERLen(0);
        int n4 = 2;
        if (this.f != null) {
            n4 = this.f.getDERLen(0x800000);
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.d);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, n3);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, null, 0, this.subjectPublicKeyInfo.length);
            EncodedContainer encodedContainer3 = new EncodedContainer(8401152, true, 0, null, 0, n4);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
            this.h = new ASN1Template(aSN1ContainerArray);
            return this.h.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getCertRequestInfoDEREncoding(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Specified array is null.");
        }
        if ((this.h == null || n3 != this.infoSpecial) && this.b(n3) == 0) {
            throw new CertificateException("Could not encode, missing data.");
        }
        int n4 = 0;
        try {
            n4 += this.h.derEncode(byArray, n2);
            this.h = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.h = null;
            throw new CertificateException("Could not encode Cert Request: " + aSN_Exception.getMessage());
        }
        try {
            n4 += this.e.getDEREncoding(byArray, n2 + n4, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot build Cert Request Info: " + nameException.getMessage());
        }
        System.arraycopy(this.subjectPublicKeyInfo, 0, byArray, n2 + n4, this.subjectPublicKeyInfo.length);
        n4 += this.subjectPublicKeyInfo.length;
        if (this.f == null) {
            byArray[n2 += n4] = -96;
            byArray[n2 + 1] = 0;
            n4 += 2;
        } else {
            try {
                n4 += this.f.getDEREncoding(byArray, n2 + n4, 0x800000);
            }
            catch (AttributeException attributeException) {
                throw new CertificateException("Could not encode CertRequest: " + attributeException.getMessage());
            }
        }
        return n4;
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        try {
            ASN1.berDecode(this.signature, 0, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot extract the signature.");
        }
        byte[] byArray = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, byArray, 0, bitStringContainer.dataLen);
        return byArray;
    }

    public void setVersion(int n2) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        this.checkVersionNumber(n2, null, 0, 0);
    }

    public int getVersion() {
        return this.d;
    }

    public void setSubjectName(X500Name x500Name) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (x500Name == null) {
            throw new CertificateException("Cannot set the cert with the given subjectName.");
        }
        try {
            this.e = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Cannot set the cert with the given subjectName.");
        }
    }

    public X500Name getSubjectName() {
        if (this.e == null) {
            return null;
        }
        try {
            return (X500Name)this.e.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addAttribute(X501Attribute x501Attribute) {
        if (x501Attribute != null) {
            if (this.f == null) {
                this.f = new X501Attributes();
            }
            this.f.addAttribute(x501Attribute);
        }
    }

    public void setAttributes(X501Attributes x501Attributes) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        try {
            this.f = x501Attributes != null ? (X501Attributes)x501Attributes.clone() : null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Could not set the request object with the given attributes.");
        }
    }

    public X501Attributes getAttributes() {
        if (this.f == null) {
            return null;
        }
        try {
            return (X501Attributes)this.f.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void signCertRequest(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CertificateException {
        if (string == null || string2 == null || jSAFE_PrivateKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        this.clearSignature();
        if (this.b == null) {
            this.c = this.getCertRequestInfoDERLen(0);
            this.b = new byte[this.c];
            this.c = this.getCertRequestInfoDEREncoding(this.b, 0, 0);
        }
        byte[] byArray = this.performSignature(string, string2, jSAFE_PrivateKey, secureRandom, this.b, 0, this.c);
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, byArray, 0, byArray.length, byArray.length * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.signature = ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the cert as presently set.");
        }
    }

    public boolean verifyCertRequestSignature(String string, SecureRandom secureRandom) throws CertificateException {
        if (string == null) {
            throw new CertificateException("Specified values are null.");
        }
        if (this.a == null) {
            if (this.b != null) {
                this.a = new byte[this.c];
                System.arraycopy(this.b, 0, this.a, 0, this.c);
            } else {
                throw new CertificateException("Cannot verify the signature, not all components are set.");
            }
        }
        if (this.signature == null || this.signatureAlgorithmBER == null) {
            throw new CertificateException("Cannot verify the signature, not all components are set.");
        }
        byte[] byArray = this.getSignature();
        return this.performSignatureVerification(string, secureRandom, this.a, 0, this.a.length, byArray, 0, byArray.length);
    }

    protected void clearTemplate() {
        this.g = null;
        this.h = null;
        this.b = null;
        this.c = 0;
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.a = null;
        this.d = 0;
        this.e = null;
        this.f = null;
    }
}

