/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Service;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;

public final class PKIService
extends Service {
    public PKIService(CertJ certJ) {
        super(certJ);
    }

    public PKIResponseMessage readCertificationResponseMessage(byte[] byArray, ProtectInfo protectInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (byArray == null) {
            throw new InvalidParameterException("PKIService.readCertificationResponseMessage: response cannot be null.");
        }
        try {
            return pKIInterface.readCertificationResponseMessage(byArray, protectInfo);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.readCertificationResponseMessage: Does not support this service.");
        }
    }

    public byte[] writeCertificationRequestMessage(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (pKIRequestMessage == null) {
            throw new InvalidParameterException("PKIService.writeCertificationRequestMessage: request cannot be null.");
        }
        try {
            return pKIInterface.writeCertificationRequestMessage(pKIRequestMessage, protectInfo);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.writeCertificationRequestMessage: Does not support this service.");
        }
    }

    public PKIResponseMessage requestCertification(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws InvalidParameterException, NoServiceException, PKIException {
        return this.sendRequest(pKIRequestMessage, protectInfo, databaseService);
    }

    public PKIResponseMessage sendRequest(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (pKIRequestMessage == null) {
            throw new InvalidParameterException("PKIService.sendRequest: request cannot be null.");
        }
        try {
            return pKIInterface.sendRequest(pKIRequestMessage, protectInfo, databaseService);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.sendRequest: does not support this service.");
        }
    }

    public PKIResult sendMessage(byte[] byArray) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (byArray == null) {
            throw new InvalidParameterException("PKIService.sendMessage: request cannot be null.");
        }
        try {
            return pKIInterface.sendMessage(byArray);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.sendMessage: Does not support this service.");
        }
    }

    public void generateProofOfPossession(PKIRequestMessage pKIRequestMessage, JSAFE_PrivateKey jSAFE_PrivateKey, POPGenerationInfo pOPGenerationInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (pKIRequestMessage == null) {
            throw new InvalidParameterException("PKIService.generateProofOfPossession: request cannot be null.");
        }
        try {
            pKIInterface.generateProofOfPossession(pKIRequestMessage, jSAFE_PrivateKey, pOPGenerationInfo);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.generateProofOfPossession: Does not support this service.");
        }
    }

    public boolean validateProofOfPossession(PKIMessage pKIMessage, POPValidationInfo pOPValidationInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (pKIMessage == null) {
            throw new InvalidParameterException("PKIService.validateProofOfPossession: message cannot be null.");
        }
        try {
            return pKIInterface.validateProofOfPossession(pKIMessage, pOPValidationInfo);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.validateProofOfPossession: Does not support this service.");
        }
    }

    public void provideProofOfPossession(PKIRequestMessage pKIRequestMessage, int n2, byte[] byArray) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pKIInterface = this.a();
        if (pKIRequestMessage == null) {
            throw new InvalidParameterException("PKIService.provideProofOfPossession: request cannot be null.");
        }
        try {
            pKIInterface.provideProofOfPossession(pKIRequestMessage, n2, byArray);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("PKIService.provideProofOfPossession: Does not support this service.");
        }
    }

    private PKIInterface a() throws NoServiceException {
        if (this.getProviderCount() == 0) {
            throw new NoServiceException("PKIService.getProvider: no PKI provider bound to this object.");
        }
        return (PKIInterface)((Object)this.getProviderAt(0));
    }
}

