/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator;
import java.util.HashSet;
import java.util.Set;

public class ApplicationDescriptorValidator15
extends ApplicationDescriptorValidator {
    private final ApplicationDescriptorValidator.ElementInfo ROOT_ELEMENT_INFO;
    private Set fileExtensions = new HashSet();
    private Set nameLangs = new HashSet();
    private Set descriptionLangs = new HashSet();
    private boolean transparent = false;
    private String systemChrome = "none";
    private int[] minSize;
    private int[] maxSize;

    public ApplicationDescriptorValidator15() {
        ApplicationDescriptorValidator.ElementInfo root = new ApplicationDescriptorValidator.ElementInfo("application", 1, 1);
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("id", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("version", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("filename", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("name", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("description", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("copyright", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("initialWindow", 1, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("installFolder", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("programMenuFolder", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("icon", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("customUpdateUI", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("fileTypes", 0, 1));
        root.addChild(new ApplicationDescriptorValidator.ElementInfo("allowBrowserInvocation", 0, 1));
        root.addAttribute(new ApplicationDescriptorValidator.AttributeInfo("minimumPatchLevel", false));
        ApplicationDescriptorValidator.ElementInfo temp = root.getChild("name");
        temp.contentTypeMixed = true;
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new ApplicationDescriptorValidator.AttributeInfo("xml:lang", true));
        temp = root.getChild("description");
        temp.contentTypeMixed = true;
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new ApplicationDescriptorValidator.AttributeInfo("xml:lang", true));
        temp = root.getChild("initialWindow");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("content", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("title", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("systemChrome", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("transparent", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("visible", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("minimizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("maximizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("resizable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("closeable", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("x", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("y", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("width", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("height", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("minSize", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("maxSize", 0, 1));
        temp = root.getChild("fileTypes");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("fileType", 0, -1));
        temp = temp.getChild("fileType");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("name", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("extension", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("description", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("contentType", 1, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("icon", 0, 1));
        temp = temp.getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image16x16", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image32x32", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image48x48", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image128x128", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image16x16", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image32x32", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image48x48", 0, 1));
        temp.addChild(new ApplicationDescriptorValidator.ElementInfo("image128x128", 0, 1));
        this.ROOT_ELEMENT_INFO = root;
    }

    protected ApplicationDescriptorValidator.ElementInfo getRootElementInfo() {
        return this.ROOT_ELEMENT_INFO;
    }

    protected boolean validateAttribute(String attributePath, String value) {
        if (attributePath.equals("application@minimumPatchLevel")) {
            return ApplicationDescriptorValidator.validateUnsignedIntType(value);
        }
        if (attributePath.equals("application.name.text@xml:lang")) {
            if (this.nameLangs.contains(value)) {
                this.dispatchError(108, new String[]{attributePath, value});
            } else if (ApplicationDescriptorValidator.validateLanguageType(value)) {
                this.nameLangs.add(value);
            } else {
                return false;
            }
        }
        if (attributePath.equals("application.description.text@xml:lang")) {
            if (this.descriptionLangs.contains(value)) {
                this.dispatchError(108, new String[]{attributePath, value});
            } else if (ApplicationDescriptorValidator.validateLanguageType(value)) {
                this.descriptionLangs.add(value);
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean validateElement(String elementPath, String value) {
        boolean valid = true;
        if (elementPath.equals("application.id")) {
            return ApplicationDescriptorValidator.validateAppId(value);
        }
        if (elementPath.equals("application.version")) {
            return !value.equals("");
        }
        if (elementPath.equals("application.filename")) {
            valid = ApplicationDescriptorValidator.validateName(value);
        }
        if (elementPath.equals("application.installFolder") || elementPath.equals("application.programMenuFolder")) {
            valid = ApplicationDescriptorValidator.validateFolderType(value);
        }
        if (elementPath.equals("application.initialWindow.visible") || elementPath.equals("application.initialWindow.transparent") || elementPath.equals("application.initialWindow.minimizable") || elementPath.equals("application.initialWindow.maximizable") || elementPath.equals("application.initialWindow.resizable") || elementPath.equals("application.initialWindow.closeable") || elementPath.equals("application.customUpdateUI") || elementPath.equals("application.allowBrowserInvocation")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
        }
        if (elementPath.equals("application.initialWindow.systemChrome")) {
            valid = ApplicationDescriptorValidator.validateSystemChrome(value);
        }
        if (elementPath.equals("application.initialWindow.width") || elementPath.equals("application.initialWindow.height")) {
            valid = ApplicationDescriptorValidator.validateUnsignedIntType(value);
        }
        if (elementPath.equals("application.initialWindow.x") || elementPath.equals("application.initialWindow.y")) {
            valid = ApplicationDescriptorValidator.validateSignedIntType(value);
        }
        if (elementPath.equals("application.initialWindow.minSize") || elementPath.equals("application.initialWindow.maxSize")) {
            valid = ApplicationDescriptorValidator.validateUnsignedIntPairType(value);
        }
        if (elementPath.equals("application.fileTypes.fileType.name")) {
            valid = ApplicationDescriptorValidator.validateFileTypeName(value);
        }
        if (elementPath.equals("application.fileTypes.fileType.extension") && (valid = ApplicationDescriptorValidator.validateExtension(value))) {
            valid = this.fileExtensions.add(value);
        }
        if (elementPath.equals("application.fileTypes.fileType.contentType")) {
            return value.length() >= 1;
        }
        if (elementPath.equals("application.initialWindow.content")) {
            this.validateRootContent(value);
        }
        if (valid) {
            String[] list;
            if (elementPath.equals("application.initialWindow.transparent")) {
                if (value.equals("true") || value.equals("1")) {
                    this.transparent = true;
                }
                if (this.transparent && !this.systemChrome.equals("none")) {
                    this.dispatchError(106, null);
                }
            }
            if (elementPath.equals("application.initialWindow.systemChrome")) {
                this.systemChrome = value;
                if (this.transparent && !this.systemChrome.equals("none")) {
                    this.dispatchError(106, null);
                }
            }
            if (elementPath.equals("application.initialWindow.minSize")) {
                this.minSize = new int[2];
                list = value.split("\\s+");
                this.minSize[0] = Integer.parseInt(list[0]);
                this.minSize[1] = Integer.parseInt(list[1]);
                if (this.maxSize != null && (this.minSize[0] > this.maxSize[0] || this.minSize[1] > this.maxSize[1])) {
                    this.dispatchError(107, new String[]{elementPath});
                }
            }
            if (elementPath.equals("application.initialWindow.maxSize")) {
                this.maxSize = new int[2];
                list = value.split("\\s+");
                this.maxSize[0] = Integer.parseInt(list[0]);
                this.maxSize[1] = Integer.parseInt(list[1]);
                if (this.minSize != null && (this.minSize[0] > this.maxSize[0] || this.minSize[1] > this.maxSize[1])) {
                    this.dispatchError(107, null);
                }
            }
        }
        if (elementPath.equals("application.icon.image16x16") || elementPath.equals("application.icon.image32x32") || elementPath.equals("application.icon.image48x48") || elementPath.equals("application.icon.image128x128") || elementPath.equals("application.fileTypes.fileType.icon.image16x16") || elementPath.equals("application.fileTypes.fileType.icon.image32x32") || elementPath.equals("application.fileTypes.fileType.icon.image48x48") || elementPath.equals("application.fileTypes.fileType.icon.image128x128")) {
            this.validateImage(value);
        }
        return valid;
    }

    protected int getMaximumSWFVersion() {
        return 10;
    }

    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/1.5";
    }
}

