/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.X509V3Extensions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TimestampRequest {
    private byte[] hashedMessage;
    private byte[] messageImprint;
    private byte[] reqPolicy;
    private boolean certReq;
    private X509V3Extensions extensions;
    public static final int nonceSize = 16;
    private boolean sendNonce;
    private IntegerContainer nonceDER;
    byte[] encodedReq;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TimestampRequest(byte[] messageToHash) {
        block3: {
            this.hashedMessage = null;
            this.messageImprint = null;
            this.reqPolicy = null;
            this.certReq = true;
            this.extensions = null;
            this.sendNonce = true;
            this.nonceDER = null;
            this.encodedReq = null;
            if (messageToHash != null) {
                try {
                    MessageDigest digester = MessageDigest.getInstance("SHA-1");
                    this.hashedMessage = digester.digest(messageToHash);
                }
                catch (NoSuchAlgorithmException e2) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    public byte[] getEncoded() {
        if (this.encodedReq != null) {
            return this.encodedReq;
        }
        try {
            ASN1Container[] hashAlgoDef = new ASN1Container[]{new SequenceContainer(0, true, 0), new OIDContainer(0, true, 0, "SHA1", 10), new EncodedContainer(130816, false, 5, null, 0, 0), new EndContainer()};
            byte[] hashAlgos = ASN1.derEncode(hashAlgoDef);
            ASN1Container[] messageImprintDef = new ASN1Container[]{new SequenceContainer(0, true, 0), new EncodedContainer(12288, true, 0, hashAlgos, 0, hashAlgos.length), new OctetStringContainer(0, true, 0, this.hashedMessage, 0, this.hashedMessage.length), new EndContainer()};
            this.messageImprint = ASN1.derEncode(messageImprintDef);
            OIDContainer asn1ReqPolicy = null;
            asn1ReqPolicy = this.reqPolicy != null ? new OIDContainer(65536, true, 0, this.reqPolicy, 0, this.reqPolicy.length) : new OIDContainer(65536, false, 0, null, 0, 0);
            this.nonceDER = new IntegerContainer(65536, false, 0, null, 0, 0, true);
            EncodedContainer asn1Extn = null;
            if (this.extensions != null) {
                byte[] extBytes = new byte[this.extensions.getDERLen(0x810000)];
                this.extensions.getDEREncoding(extBytes, 0, 0x810000);
                asn1Extn = new EncodedContainer(0x810000, true, 0, extBytes, 0, extBytes.length);
            } else {
                asn1Extn = new EncodedContainer(0x810000, false, 0, null, 0, 0);
            }
            ASN1Container[] tsaReqDef = new ASN1Container[]{new SequenceContainer(0, true, 0), new IntegerContainer(0, true, 0, 1), new EncodedContainer(12288, true, 0, this.messageImprint, 0, this.messageImprint.length), asn1ReqPolicy, this.nonceDER, new BooleanContainer(65536, true, 0, this.certReq), asn1Extn, new EndContainer()};
            this.encodedReq = ASN1.derEncode(tsaReqDef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.encodedReq;
    }

    public boolean isCertReq() {
        return this.certReq;
    }

    public void setCertReq(boolean certReq) {
        this.certReq = certReq;
    }

    public X509V3Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(X509V3Extensions extensions) {
        this.extensions = extensions;
    }

    public byte[] getReqPolicy() {
        return this.reqPolicy;
    }

    public void setReqPolicy(byte[] reqPolicy) {
        this.reqPolicy = reqPolicy;
    }

    public boolean isSendNonce() {
        return this.sendNonce;
    }

    public void setSendNonce(boolean sendNonce) {
        this.sendNonce = sendNonce;
    }

    public IntegerContainer getNonceDER() {
        return this.nonceDER;
    }

    public byte[] getMessageImprint() {
        return this.messageImprint;
    }

    static {
        $assertionsDisabled = !TimestampRequest.class.desiredAssertionStatus();
    }
}

