/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.VeriSignCRSFailureInfo;
import com.rsa.certj.cert.attributes.VeriSignCRSMessageType;
import com.rsa.certj.cert.attributes.VeriSignCRSPKIStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSRecipientNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSSenderNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSTransactionID;
import com.rsa.certj.cert.attributes.VeriSignCRSVersion;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.pki.Cn;
import com.rsa.certj.provider.pki.Co;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.pki.PKIDebug;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.certj.spi.pki.ProtectInfoPublicKey;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_Recode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CRS
extends Provider
implements PKIDebug {
    public static final int POP_TYPE_CSR = 1;
    private static final int a = 1;
    private static final int b = 0;
    private static final String c = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String d = "-----END NEW CERTIFICATE REQUEST-----";
    private static String e = "application/octet-stream";
    private static String f = "application/x-crs-message";
    private static final int g = 0;
    private static final int h = 19;
    private static final int i = 20;
    private static final int j = 3;
    private static final String k = "VeriSign";
    private static int l = 76;
    private static final int[] m = new int[]{256, 261, 262, 263, 264, 266, 268, 269, 272, 276, 277, 288, 293, 294, 296, 298, 306, 307, 316, 317, 325, 326, 327, 328, 330, 4101, 12353, 12359, 12380, 12384, 12385, 12393, 12420, 14593, 14594, 14595, 14596, 14597, 14598, 14599, 14600, 14601, 14602, 14603, 14604, 14605, 14606, 14607, 14608, 14609, 14610, 14611, 14612, 14613, 14614, 14615, 14617, 14619, 14620, 14623, 14624, 14625, 14626, 14627, 14628, 14629, 14630, 14631, 14632, 14633, 14634, 14639, 14640, 14641, 14642, 14643};
    private static final int[] n = new int[]{0x200000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x4000000, 0x4000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x100000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x20000000, 0x40000000, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x100000, 0x100000, 0x100000, 0x8000000, 0x8000000, 0x1000000, 0x1000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x40000000, 0x40000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x8000000, 0x8000000, 0x4000000, 0x100000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000, 0x4000000, 0x4000000, 0x4000000, 0x4000000, 0x8000000};
    private static String[] o = new String[]{"System out of memory", "Unknown attribute tag", "Unknown attribute type", "Invalid attribute value", "Attribute value too long", "BER encoding error", "Can't build or verify cert chain", "Cert encoding error", "CRL encoding error", "Unsupported data encryption algorithm", "Unknown data encryption algorithm", "I/O error (Backend system may be unavailable)", "Unsupported message digest algorithm", "Unknown message digest algorithm", "Invalid DN", "Cert, CRL or account not found", "Unsupported password-based encryption algorithm", "Unknown password-based encryption alrorithm", "Unsupported cert, CRL or message signature algorithm", "Unknown cert, CRL or message signature algorithm", "Invalid authorityKeyID extension", "Invalid keyUsage extension", "Invalid basicConstraint extension", "Invalid privateKeyUsage extension", "Invalid subjectAltName extension", "An already valid, non-expired, non-revoked certificate currently exists with the same DN.", "System configuration error.  Contact VeriSign", "System configuration error.  Contact VeriSign", "Undocumented error.  Contact VeriSign", "The certificate in question has been revoked.", "The certificate in question has been rejected.", "The challenge phrase provided was incorrect", "The jurisdictional info in the regInfo portion of the message does not match the jurisdictional info in the RA certificate used to create the message.", "Could not find any signed attributes on this CRS message.", "No messageType attribute was found.", "No transactionID attribute was found.", "Invalid encoding of attributes", "Message signature could not be verified.", "Unable to unenvelope message", "ExtensionReq attribute tag not correct.", "SenderNonce tag not correct.", "RecipientNonce tag not correct.", "No SenderNonce attribute found.", "An incorrectly encoded CRS message was encountered.", "Challenge password was required but not found", "Unknown messageType value.", "An error occurred during enrollment.", "An error occurred during cert pickup", "An error occurred during cert query", "An error occurred during crl query", "An error occurred during CertRep generation", "An error occurred while receiving an incoming CRS message", "GetCert message not encoded correctly", "GetCRL message not encoded correctly", "PKCSReq message not encoded correctly", "GetCertInitial message not encoded correctly", "Invalid DN encoding", "Unable to find cert for transactionID specified in GetCertInitial message.", "An unstructuredName attribute was required but not found.", "The certificate associated with this transactionID has been revoked.", "The certificate associated with this transactionID has been rejected.", "RevReq message not encoded correctly.", "Error during RevReq processing", "regInfo required but not found.", "An unsigned cert was required but not found.  This will only occur during proto-cert enrollment", "A corp_company name-value pair was expected in regInfo.", "A org_unit name-value pair was expected in regInfo.", "A cert_type name-value pair was expected in regInfo", "A class name-value pair was expected in regInfo", "The transactionID specified is too large.", "CRL not found for issuer.", "An application name-value pair was expected in regInfo", "An originator name-value pair was expected in regInfo.", "The keyUsage extension value specified via the extensionReq attribute was not accepted.", "A challenge name-value pair was expected in regInfo", "The certificate associated with the transactionID has expired."};
    private static final int p = 1;
    private static final int q = 16;
    private Hashtable r;

    public CRS(String string, InputStream inputStream) throws InvalidParameterException {
        super(4, string);
        if (inputStream == null) {
            throw new InvalidParameterException("CRS.CRS: configStream should not be null.");
        }
        this.r = PKICommonImplementation.loadProperties(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRS(String string, File file) throws InvalidParameterException {
        super(4, string);
        if (file == null) {
            throw new InvalidParameterException("CRS.CRS: configFile should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.r = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("CRS.CRS: " + file.toString() + " does not exist.");
            }
            Object var6_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CRS(String string, String string2) throws InvalidParameterException {
        super(4, string);
        if (string2 == null) {
            throw new InvalidParameterException("CRS.CRS: configFileName should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(new File(string2));
                this.r = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("CRS.CRS: " + string2 + " does not exist.");
            }
            Object var6_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (Exception exception) {
            throw new ProviderManagementException("CRS.instantiate: " + exception.getMessage());
        }
    }

    public void saveMessage(byte[] byArray, PKIMessage pKIMessage, ProtectInfo protectInfo) throws PKIException {
    }

    public void saveCertificate(PKIResponseMessage pKIResponseMessage) throws PKIException {
    }

    public void saveData(byte[] byArray, String string) throws PKIException {
    }

    class ResponseData {
        public byte[] recipientNonce = null;
        public byte[] senderNonce = null;

        public ResponseData(byte[] byArray, byte[] byArray2) {
            this.senderNonce = byArray;
            this.recipientNonce = byArray2;
        }
    }

    private final class Implementation
    extends PKICommonImplementation
    implements PKIInterface {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException, PKIException {
            super(certJ, string);
            this.loadConfig(CRS.this.r);
            if (this.profile == null) {
                this.profile = CRS.k;
            }
        }

        public PKIResponseMessage readCertificationResponseMessage(byte[] byArray, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            boolean bl2;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage:protectInfo should be an instance of ProtectInfoPublicKey.");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            SignedData signedData = new SignedData(this.certJ, protectInfoPublicKey.getCertPathCtx());
            try {
                bl2 = signedData.readInit(byArray, 0, byArray.length);
                if (bl2) {
                    bl2 = signedData.readFinal();
                }
            }
            catch (Exception exception) {
                if (byArray[0] == 48) {
                    throw new PKIException("CRS$Implementation.readCertificationResponseMessage:decoding response or signature verification failed(" + exception.getMessage() + ").");
                }
                String[] stringArray = new String[]{new String(byArray)};
                throw new PKITransportException("CRS$Implementation.readCertificationResponseMessage:error returned in HTML. See the value returned by thisException.getStatusInfo().getStatusStrings[0] for the contents of the HTML response." + new String(byArray) + ").", new PKIStatusInfo(2, 0x200000, stringArray, -1));
            }
            if (!bl2) {
                throw new PKIException("CRS$Implementation.readCertificationResponseMessage: Decoding of SignedData failed.");
            }
            return this.a(signedData, protectInfoPublicKey);
        }

        public byte[] writeCertificationRequestMessage(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo) throws NotSupportedException, PKIException {
            ContentInfo contentInfo;
            byte[] byArray;
            if (!(protectInfo instanceof ProtectInfoPublicKey)) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: ProtectInfo should be an instance of ProtectInfoPublicKey.");
            }
            if (pKIRequestMessage.getRegInfo() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: RegInfo of the request message should not be null.");
            }
            if (pKIRequestMessage.getSender() == null) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Sender information of the request message should not be null.");
            }
            Co co = (Co)pKIRequestMessage.getProviderData();
            if (co == null || co.pop == null || co.pop.length == 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: POP of the request message should not be null.Use generateProofOfPossession to set it.");
            }
            boolean bl2 = co.startPolling;
            int n2 = pKIRequestMessage.getWrapType();
            if (n2 != 1 && n2 != 4) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: Only WRAP_SIGN or WRAP_ENVELOPE_THEN_SIGN is supported.");
            }
            if (pKIRequestMessage.getVersion() == -1) {
                pKIRequestMessage.setVersion(0);
            } else if (pKIRequestMessage.getVersion() != 0) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: CRS version (" + pKIRequestMessage.getVersion() + ") is not the same as supported version(" + 0 + ").");
            }
            ProtectInfoPublicKey protectInfoPublicKey = (ProtectInfoPublicKey)protectInfo;
            try {
                byArray = bl2 ? this.a(pKIRequestMessage, protectInfoPublicKey.getCertPathCtx()) : co.pop;
                byte[] byArray2 = this.a(byArray, pKIRequestMessage.getRegInfo());
                Data data = new Data();
                data.setContent(byArray2, 0, byArray2.length);
                if (n2 == 4) {
                    if (pKIRequestMessage.getRecipient() == null) {
                        throw new PKIException("Implementation.writeCertificationRequestMessage: Recipent info of the request message should not be null.");
                    }
                    contentInfo = this.a(protectInfoPublicKey.getCertPathCtx(), pKIRequestMessage, data);
                } else {
                    contentInfo = data;
                }
                X501Attributes x501Attributes = pKIRequestMessage.getSender().getAuthenticatedAttrs();
                if (x501Attributes == null) {
                    x501Attributes = new X501Attributes();
                }
                if (x501Attributes.getAttributeByType(12) == null) {
                    x501Attributes.addAttribute(new VeriSignCRSVersion(pKIRequestMessage.getVersion()));
                }
                if (x501Attributes.getAttributeByType(6) == null) {
                    if (co.startPolling) {
                        x501Attributes.addAttribute(new VeriSignCRSMessageType(20));
                    } else {
                        x501Attributes.addAttribute(new VeriSignCRSMessageType(19));
                    }
                }
                if (x501Attributes.getAttributeByType(11) == null) {
                    if (pKIRequestMessage.getTransactionID() == null) {
                        pKIRequestMessage.setTransactionID(this.a(data));
                    }
                    x501Attributes.addAttribute(new VeriSignCRSTransactionID(pKIRequestMessage.getTransactionID(), 0, pKIRequestMessage.getTransactionID().length));
                }
                if (x501Attributes.getAttributeByType(9) == null) {
                    if (co.senderNonce == null) {
                        co.senderNonce = this.a();
                    }
                    x501Attributes.addAttribute(new VeriSignCRSSenderNonce(co.senderNonce, 0, co.senderNonce.length));
                }
                pKIRequestMessage.getSender().setAuthenticatedAttrs(x501Attributes);
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.writeCertificationRequestMessage: " + pKCS7Exception.getMessage());
            }
            byArray = this.a(protectInfoPublicKey.getCertPathCtx(), pKIRequestMessage, contentInfo);
            pKIRequestMessage.setMessageTime(new Date());
            return byArray;
        }

        public PKIResponseMessage sendRequest(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws NotSupportedException, PKIException {
            Object object;
            byte[] byArray = this.writeCertificationRequestMessage(pKIRequestMessage, protectInfo);
            CRS.this.saveMessage(byArray, pKIRequestMessage, protectInfo);
            PKIResult pKIResult = this.sendMessage(byArray);
            PKIStatusInfo pKIStatusInfo = pKIResult.getStatusInfo();
            if (pKIStatusInfo.getStatus() != 0) {
                return new PKIResponseMessage(pKIStatusInfo);
            }
            byte[] byArray2 = pKIResult.getEncodedResponse();
            CRS.this.saveData(byArray2, "RespTemp.ber");
            PKIResponseMessage pKIResponseMessage = this.readCertificationResponseMessage(byArray2, protectInfo);
            CRS.this.saveMessage(byArray2, pKIResponseMessage, protectInfo);
            pKIStatusInfo = pKIResponseMessage.getStatusInfo();
            int n2 = pKIStatusInfo.getStatus();
            if (n2 != 0 && n2 != 3 && (pKIStatusInfo.getFailInfo() & 0x200000) != 0) {
                return pKIResponseMessage;
            }
            if (n2 == 0 || n2 == 3) {
                if (!CertJUtils.byteArraysEqual(pKIRequestMessage.getTransactionID(), pKIResponseMessage.getTransactionID())) {
                    throw new PKIException("CRS$Implementation.sendRequest: Transaction IDs do not match.");
                }
                if (!this.a(pKIRequestMessage, pKIResponseMessage)) {
                    throw new PKIException("CRS$Implementation.sendRequest: Nonces do not match.");
                }
            }
            if (n2 == 3) {
                object = (Co)pKIRequestMessage.getProviderData();
                ((Co)object).startPolling = true;
            }
            if ((object = this.findCertificateReturned(pKIRequestMessage, pKIResponseMessage)) != null) {
                pKIResponseMessage.setCertificate((Certificate)object);
            }
            if (databaseService != null) {
                this.disperseCertsAndCRLs(pKIResponseMessage, databaseService);
            }
            CRS.this.saveCertificate(pKIResponseMessage);
            return pKIResponseMessage;
        }

        public PKIResponseMessage requestCertification(PKIRequestMessage pKIRequestMessage, ProtectInfo protectInfo, DatabaseService databaseService) throws NotSupportedException, PKIException {
            return this.sendRequest(pKIRequestMessage, protectInfo, databaseService);
        }

        public PKIResult sendMessage(byte[] byArray) throws NotSupportedException, PKIException {
            for (int i2 = 0; i2 < this.destList.length; ++i2) {
                String[] stringArray;
                String[] stringArray2;
                PKIResult pKIResult;
                URL uRL;
                String string = this.destList[i2];
                try {
                    uRL = new URL(string);
                }
                catch (Exception exception) {
                    continue;
                }
                String string2 = uRL.getProtocol();
                if (!string2.equals("http") || (pKIResult = this.sendAndReceiveHttp(uRL, stringArray2 = new String[]{"User-Agent: Cert-J/2.0", "Content-type: " + e}, this.proxyList, byArray, stringArray = new String[]{"Content-type: " + f})).getStatusInfo().getStatus() == 2 && (pKIResult.getStatusInfo().getFailInfo() & 0x200000) != 0) continue;
                return pKIResult;
            }
            throw new PKIException("CRS$Implementation.sendMessage: Unable to connect to an auto-responder.");
        }

        public void generateProofOfPossession(PKIRequestMessage pKIRequestMessage, JSAFE_PrivateKey jSAFE_PrivateKey, POPGenerationInfo pOPGenerationInfo) throws NotSupportedException, PKIException {
            Cloneable cloneable;
            if (jSAFE_PrivateKey == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: privateKey cannot be null.");
            }
            int n2 = pKIRequestMessage.getPopType();
            if (n2 == -1) {
                pKIRequestMessage.setPopType(1);
            } else if (n2 != 1) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: POP type should be signature.");
            }
            PKCS10CertRequest pKCS10CertRequest = new PKCS10CertRequest();
            X509Certificate x509Certificate = (X509Certificate)pKIRequestMessage.getCertificateTemplate();
            Co co = new Co(CRS.this);
            pKIRequestMessage.setProviderData(co);
            try {
                Object object;
                if (x509Certificate.getVersion() == -1) {
                    pKCS10CertRequest.setVersion(0);
                }
                if (x509Certificate.getSubjectName() == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: Subject name is not specified.");
                }
                pKCS10CertRequest.setSubjectName(x509Certificate.getSubjectName());
                if (x509Certificate.getSubjectPublicKey(this.certJ.getDevice()) == null) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No public key in template.");
                }
                pKCS10CertRequest.setSubjectPublicKey(x509Certificate.getSubjectPublicKey(this.certJ.getDevice()));
                cloneable = x509Certificate.getExtensions();
                if (cloneable != null) {
                    object = new X501Attributes();
                    ((X501Attributes)object).addAttribute(new V3ExtensionAttribute((X509V3Extensions)cloneable));
                    pKCS10CertRequest.setAttributes((X501Attributes)object);
                }
                try {
                    pKCS10CertRequest.signCertRequest("MD5/RSA/PKCS1Block01Pad", this.certJ.getDevice(), jSAFE_PrivateKey, this.certJ.getRandomObject());
                }
                catch (NoServiceException noServiceException) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: No Random service provider available(" + noServiceException.getMessage() + ").");
                }
                catch (RandomException randomException) {
                    throw new PKIException("CRS$Implementation.generateProofOfPossession: " + randomException.getMessage());
                }
                object = new byte[pKCS10CertRequest.getDERLen(0)];
                co.pop = (byte[])object;
                pKCS10CertRequest.getDEREncoding((byte[])object, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: " + certificateException.getMessage());
            }
            cloneable = pKIRequestMessage.getSender();
            if (cloneable == null) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: Sender is not specified.");
            }
            try {
                if (((SignerInfo)cloneable).getIssuerName().equals(x509Certificate.getSubjectName()) && CertJUtils.byteArraysEqual(((SignerInfo)cloneable).getSerialNumber(), x509Certificate.getSerialNumber())) {
                    this.a(pKIRequestMessage, jSAFE_PrivateKey);
                }
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.generateProofOfPossession: " + pKCS7Exception.getMessage());
            }
        }

        public boolean validateProofOfPossession(PKIMessage pKIMessage, POPValidationInfo pOPValidationInfo) throws NotSupportedException, PKIException {
            throw new NotSupportedException("CRS$Implementation.validateProofOfPossession: not supported.");
        }

        public void provideProofOfPossession(PKIRequestMessage pKIRequestMessage, int n2, byte[] byArray) throws PKIException {
            Object object;
            if (n2 != 1) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Unsupported POP type(" + n2 + ").");
            }
            if (byArray == null || byArray.length == 0) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP data is empty.");
            }
            int n3 = this.a(byArray, CRS.c);
            int n4 = this.b(byArray, CRS.d);
            if (n4 < n3) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: Ill-formated POP data.");
            }
            byte[] byArray2 = this.a(byArray, n3, n4);
            try {
                object = new PKCS10CertRequest(byArray2, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.provideProofOfPossession: POP is not in PKCS10 format(" + certificateException.getMessage() + ").");
            }
            object = new Co(CRS.this);
            ((Co)object).pop = byArray2;
            pKIRequestMessage.setProviderData(object);
        }

        private byte[] a(PKIRequestMessage pKIRequestMessage, CertPathCtx certPathCtx) throws PKIException {
            try {
                X500Name x500Name;
                SignerInfo signerInfo = pKIRequestMessage.getSender();
                Vector vector = new Vector();
                DatabaseService databaseService = certPathCtx.getDatabase();
                int n2 = databaseService.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), vector);
                X500Name x500Name2 = n2 == 0 ? new X500Name() : ((X509Certificate)vector.elementAt(0)).getSubjectName();
                RecipientInfo recipientInfo = pKIRequestMessage.getRecipient();
                if (recipientInfo == null) {
                    x500Name = new X500Name();
                } else {
                    vector = new Vector();
                    n2 = databaseService.selectCertificateByIssuerAndSerialNumber(recipientInfo.getIssuerName(), recipientInfo.getSerialNumber(), vector);
                    x500Name = n2 == 0 ? new X500Name() : ((X509Certificate)vector.elementAt(0)).getSubjectName();
                }
                byte[] byArray = new byte[x500Name.getDERLen(0)];
                x500Name.getDEREncoding(byArray, 0, 0);
                byte[] byArray2 = new byte[x500Name2.getDERLen(0)];
                x500Name2.getDEREncoding(byArray2, 0, 0);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
                EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, byArray2.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
                byte[] byArray3 = ASN1.derEncode(aSN1ContainerArray);
                return byArray3;
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + aSN_Exception.getMessage());
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + certJException.getMessage());
            }
            catch (NameException nameException) {
                throw new PKIException("CRS$Implementation.createCertInitialBodyDER: " + nameException.getMessage());
            }
        }

        private byte[] a(byte[] byArray, Properties properties) throws PKIException {
            try {
                String string = this.urlEncodeRegInfo(properties);
                byte[] byArray2 = string.getBytes();
                OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, byArray2, 0, byArray2.length);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
                return ASN1.derEncode(aSN1ContainerArray);
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.createCertReqBodyDER: " + aSN_Exception.getMessage());
            }
        }

        private boolean a(PKIRequestMessage pKIRequestMessage, PKIResponseMessage pKIResponseMessage) {
            Co co = (Co)pKIRequestMessage.getProviderData();
            ResponseData responseData = (ResponseData)pKIResponseMessage.getProviderData();
            return CertJUtils.byteArraysEqual(co.senderNonce, responseData.recipientNonce);
        }

        private byte[] a(CertPathCtx certPathCtx, PKIRequestMessage pKIRequestMessage, ContentInfo contentInfo) throws PKIException {
            Co co = (Co)pKIRequestMessage.getProviderData();
            DatabaseService databaseService = certPathCtx.getDatabase();
            X509Certificate x509Certificate = co.selfSignedCert;
            if (x509Certificate != null) {
                try {
                    databaseService.insertCertificate(x509Certificate);
                    databaseService.insertPrivateKeyByCertificate(x509Certificate, co.privateKey);
                }
                catch (Exception exception) {
                    throw new PKIException("CRS$Implementation.signMessage: Storing EE signing key failed(" + exception.getMessage() + ").");
                }
            }
            try {
                Object object;
                CRL[] cRLArray;
                SignedData signedData = new SignedData(this.certJ, certPathCtx);
                signedData.setVersionNumber(1);
                SignerInfo signerInfo = pKIRequestMessage.getSender();
                signedData.addSignerInfo(signerInfo);
                signedData.setContentInfo(contentInfo);
                Certificate[] certificateArray = pKIRequestMessage.getExtraCerts();
                if (certificateArray != null) {
                    for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                        signedData.addCertificate((X509Certificate)certificateArray[i2]);
                    }
                }
                if ((cRLArray = pKIRequestMessage.getExtraCRLs()) != null) {
                    for (int i3 = 0; i3 < cRLArray.length; ++i3) {
                        signedData.addCRL((X509CRL)cRLArray[i3]);
                    }
                }
                DatabaseService databaseService2 = certPathCtx.getDatabase();
                Vector vector = new Vector();
                int n2 = databaseService2.selectCertificateByIssuerAndSerialNumber(signerInfo.getIssuerName(), signerInfo.getSerialNumber(), vector);
                if (n2 > 0) {
                    object = (Certificate)vector.elementAt(0);
                    boolean bl2 = this.certJ.buildCertPath(certPathCtx, object, vector, null, null, null);
                    for (int i4 = 0; i4 < vector.size(); ++i4) {
                        signedData.addCertificate((X509Certificate)vector.elementAt(i4));
                    }
                }
                n2 = signedData.getContentInfoDERLen();
                object = new byte[n2];
                signedData.writeMessage((byte[])object, 0);
                return object;
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.signMessage: " + certJException.getMessage());
            }
        }

        private EnvelopedData a(CertPathCtx certPathCtx, PKIRequestMessage pKIRequestMessage, Data data) throws PKIException {
            try {
                EnvelopedData envelopedData = new EnvelopedData(this.certJ, certPathCtx);
                envelopedData.setVersionNumber(0);
                int[] nArray = pKIRequestMessage.getEncryptionParams();
                envelopedData.setEncryptionAlgorithm(pKIRequestMessage.getEncryptionName(), nArray == null ? -1 : nArray[0]);
                envelopedData.setContentInfo(data);
                envelopedData.addRecipientInfo(pKIRequestMessage.getRecipient());
                return envelopedData;
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.envelopeMessage: " + pKCS7Exception.getMessage());
            }
        }

        private byte[] a(Data data) throws PKIException {
            try {
                byte[] byArray = new byte[data.getContentInfoDERLen()];
                data.writeMessage(byArray, 0);
                JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance("MD5", this.certJ.getDevice());
                byte[] byArray2 = jSAFE_MessageDigest.getDERAlgorithmID();
                byte[] byArray3 = new byte[jSAFE_MessageDigest.getDigestSize()];
                jSAFE_MessageDigest.digestInit();
                jSAFE_MessageDigest.digestUpdate(byArray, 0, byArray.length);
                int n2 = jSAFE_MessageDigest.digestFinal(byArray3, 0);
                if ((byArray3[0] & 0x80) == 0) {
                    return byArray3;
                }
                byte[] byArray4 = new byte[byArray3.length + 1];
                System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
                byArray4[0] = 0;
                return byArray4;
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.createTransactionID: " + pKCS7Exception.getMessage());
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKIException("CRS$Implementation.createTransactionID: " + jSAFE_Exception.getMessage());
            }
        }

        private byte[] a() throws PKIException {
            try {
                return this.certJ.getRandomObject().generateRandomBytes(16);
            }
            catch (NoServiceException noServiceException) {
                throw new PKIException("CRS$Implementation.createNonce: No random provider available(" + noServiceException.getMessage() + ").");
            }
            catch (RandomException randomException) {
                throw new PKIException("CRS$Implementation.createNonce: " + randomException.getMessage());
            }
        }

        private PKIResponseMessage a(SignedData signedData, ProtectInfoPublicKey protectInfoPublicKey) throws PKIException {
            X501Attributes x501Attributes;
            Cloneable cloneable;
            Vector vector;
            byte[] byArray;
            int n2;
            ContentInfo contentInfo = signedData.getContent();
            RecipientInfo recipientInfo = null;
            switch (contentInfo.getContentType()) {
                case 1: {
                    n2 = 1;
                    byArray = ((Data)contentInfo).getData();
                    break;
                }
                case 3: {
                    n2 = 4;
                    vector = ((EnvelopedData)contentInfo).getRecipientInfos();
                    if (vector == null || vector.size() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Only one recipient is expected.");
                    }
                    recipientInfo = (RecipientInfo)vector.elementAt(0);
                    cloneable = contentInfo.getContent();
                    if (((ContentInfo)cloneable).getContentType() != 1) {
                        throw new PKIException("CRS$Implementation.readSignedResponse: Content of EnvelopedData should be Data.");
                    }
                    byArray = ((Data)cloneable).getData();
                    break;
                }
                default: {
                    throw new PKIException("CRS$Implementation.readSignedResponse: Invalid response message foramt(" + contentInfo.getContentType() + "). Valid formats are DATA and ENVELOPED_DATA.");
                }
            }
            vector = new Vector();
            cloneable = new Vector();
            Properties properties = this.a(byArray, protectInfoPublicKey, vector, (Vector)cloneable);
            SignerInfo signerInfo = this.a(signedData);
            try {
                x501Attributes = signerInfo.getAuthenticatedAttrs();
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.readSignedResponse: " + pKCS7Exception.getMessage());
            }
            int n3 = -1;
            if (x501Attributes == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: No authenticated attributes included.");
            }
            X501Attribute x501Attribute = x501Attributes.getAttributeByType(12);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Version attribute not found.");
            }
            n3 = ((VeriSignCRSVersion)x501Attribute).getVersion();
            x501Attribute = x501Attributes.getAttributeByType(6);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type attribute not found.");
            }
            int n4 = ((VeriSignCRSMessageType)x501Attribute).getMessageType();
            if (n4 != 3) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Message Type CertResponse (3) is expected.");
            }
            x501Attribute = x501Attributes.getAttributeByType(9);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Sender nonce attribute not found.");
            }
            byte[] byArray2 = ((VeriSignCRSSenderNonce)x501Attribute).getSenderNonce();
            x501Attribute = x501Attributes.getAttributeByType(10);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.readSignedResponse: Recipient nonce attribute not found.");
            }
            byte[] byArray3 = ((VeriSignCRSRecipientNonce)x501Attribute).getRecipientNonce();
            Object[] objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = new CRL[((Vector)cloneable).size()];
            ((Vector)cloneable).copyInto(objectArray2);
            PKIResponseMessage pKIResponseMessage = new PKIResponseMessage(this.b(x501Attributes));
            ResponseData responseData = new ResponseData(byArray2, byArray3);
            pKIResponseMessage.setProviderData(responseData);
            pKIResponseMessage.setVersion(n3);
            pKIResponseMessage.setWrapInfo(n2, signerInfo, recipientInfo, null, null);
            pKIResponseMessage.setTransactionID(this.a(x501Attributes));
            pKIResponseMessage.setExtraCerts((Certificate[])objectArray);
            pKIResponseMessage.setExtraCRLs((CRL[])objectArray2);
            return pKIResponseMessage;
        }

        private void a(PKIRequestMessage pKIRequestMessage, JSAFE_PrivateKey jSAFE_PrivateKey) throws PKIException {
            String string = "MD5/RSA/PKCS1Block01Pad";
            X509Certificate x509Certificate = (X509Certificate)pKIRequestMessage.getCertificateTemplate();
            try {
                Date date;
                if (x509Certificate.getIssuerName() == null) {
                    x509Certificate.setIssuerName(x509Certificate.getSubjectName());
                }
                long l2 = System.currentTimeMillis();
                Date date2 = x509Certificate.getStartDate();
                long l3 = 3600000L;
                if (date2 == null) {
                    date2 = new Date(l2 - 720L * l3);
                }
                if ((date = x509Certificate.getEndDate()) == null) {
                    date = new Date(l2 + 8760L * l3);
                }
                x509Certificate.setValidity(date2, date);
                X509Certificate x509Certificate2 = x509Certificate;
                x509Certificate2.signCertificate(string, this.certJ.getDevice(), jSAFE_PrivateKey, this.certJ.getRandomObject());
                Co co = (Co)pKIRequestMessage.getProviderData();
                co.privateKey = jSAFE_PrivateKey;
                co.selfSignedCert = x509Certificate2;
                Certificate[] certificateArray = pKIRequestMessage.getExtraCerts();
                int n2 = certificateArray == null ? 0 : certificateArray.length;
                Certificate[] certificateArray2 = new Certificate[n2 + 1];
                if (certificateArray != null) {
                    System.arraycopy(certificateArray, 0, certificateArray2, 0, n2);
                }
                certificateArray2[n2] = x509Certificate2;
                pKIRequestMessage.setExtraCerts(certificateArray2);
            }
            catch (CertificateException certificateException) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: " + certificateException.getMessage());
            }
            catch (CertJException certJException) {
                throw new PKIException("CRS$Implementation.storeSelfSignedInfo: " + certJException.getMessage());
            }
        }

        private SignerInfo a(SignedData signedData) throws PKIException {
            Vector vector = signedData.getSignerInfos();
            if (vector == null || vector.size() > 2 || vector.size() == 0) {
                throw new PKIException("CRS$Implementation.getSender: Expected exactly one signer.");
            }
            return (SignerInfo)vector.elementAt(0);
        }

        private byte[] a(X501Attributes x501Attributes) throws PKIException {
            VeriSignCRSTransactionID veriSignCRSTransactionID = (VeriSignCRSTransactionID)x501Attributes.getAttributeByType(11);
            if (veriSignCRSTransactionID == null) {
                throw new PKIException("CRS$Implementation.extractTransactionID: Transaction ID attribute not found.");
            }
            return veriSignCRSTransactionID.getTransactionID();
        }

        private PKIStatusInfo b(X501Attributes x501Attributes) throws PKIException {
            X501Attribute x501Attribute = x501Attributes.getAttributeByType(7);
            if (x501Attribute == null) {
                throw new PKIException("CRS$Implementation.extractStatusInfo: No status attribute found.");
            }
            int n2 = ((VeriSignCRSPKIStatus)x501Attribute).getPKIStatus();
            n2 = this.a(n2);
            int n3 = -1;
            int n4 = -1;
            if (n2 == 2) {
                x501Attribute = x501Attributes.getAttributeByType(8);
                if (x501Attribute == null) {
                    throw new PKIException("CRS$Implementation.extractStatusInfo: No Failure Info attribute found.");
                }
                n3 = ((VeriSignCRSFailureInfo)x501Attribute).getFailureInfo();
                n4 = this.b(n3);
            }
            return new PKIStatusInfo(n2, n4, null, n3);
        }

        private int a(int n2) throws PKIException {
            switch (n2) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
            throw new PKIException("CRS$Implementation.mapStatusInfo: Status value(" + n2 + ") is not valid. Valid values are 0, 1, and 2.");
        }

        private int b(int n2) {
            if (this.profile.equals(CRS.k)) {
                for (int i2 = 0; i2 < l; ++i2) {
                    if (m[i2] != n2) continue;
                    return n[i2];
                }
            }
            return 0x20000000;
        }

        private Properties a(byte[] byArray, ProtectInfoPublicKey protectInfoPublicKey, Vector vector, Vector vector2) throws PKIException {
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            try {
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(77824);
                OctetStringContainer octetStringContainer = new OctetStringContainer(0);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, endContainer};
                ASN1.berDecode(byArray, 0, aSN1ContainerArray);
                if (encodedContainer.dataLen != 0) {
                    int n2;
                    SignedData signedData = new SignedData(this.certJ, protectInfoPublicKey.getCertPathCtx());
                    boolean bl2 = signedData.readInit(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                    if (bl2) {
                        bl2 = signedData.readFinal();
                    }
                    if (!bl2) {
                        throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerate PKCS7.");
                    }
                    Vector vector3 = signedData.getCertificates();
                    if (vector3 != null) {
                        for (n2 = 0; n2 < vector3.size(); ++n2) {
                            vector.addElement(vector3.elementAt(n2));
                        }
                    }
                    if ((vector3 = signedData.getCRLs()) != null) {
                        for (n2 = 0; n2 < vector3.size(); ++n2) {
                            vector2.addElement(vector3.elementAt(n2));
                        }
                    }
                }
                return this.urlDecodeRegInfo(new String(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen));
            }
            catch (ASN_Exception aSN_Exception) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode innerDER(" + aSN_Exception.getMessage() + ").");
            }
            catch (PKCS7Exception pKCS7Exception) {
                throw new PKIException("CRS$Implementation.processResponseBody: Unable to decode degenerated PKCS7(" + pKCS7Exception.getMessage() + ").");
            }
        }

        private int a(byte[] byArray, String string) {
            int n2;
            int n3 = byArray.length - string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                if (!this.a(byArray, n2, string)) continue;
                n2 += string.length();
                break;
            }
            if (n2 == n3) {
                return 0;
            }
            if (!(byArray[n2] != 13 && byArray[n2] != 10 || byArray[++n2] != 13 && byArray[n2] != 10)) {
                ++n2;
            }
            return n2;
        }

        private int b(byte[] byArray, String string) {
            int n2;
            int n3 = byArray.length - string.length();
            for (n2 = 0; n2 < n3 && !this.a(byArray, n2, string); ++n2) {
            }
            if (n2 == n3) {
                return byArray.length;
            }
            return n2;
        }

        private boolean a(byte[] byArray, int n2, String string) {
            if (byArray.length - n2 < string.length()) {
                return false;
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (byArray[n2 + i2] == (byte)string.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        private byte[] a(byte[] byArray, int n2, int n3) throws PKIException {
            try {
                JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance("Base64-76", this.certJ.getDevice());
                jSAFE_Recode.decodeInit();
                int n4 = jSAFE_Recode.getOutputBufferSize(n3);
                byte[] byArray2 = new byte[n4];
                int n5 = jSAFE_Recode.decodeUpdate(byArray, n2, n3, byArray2, 0);
                int n6 = jSAFE_Recode.decodeFinal(byArray2, n5);
                int n7 = n5 + n6;
                if (n7 != n4) {
                    byte[] byArray3 = new byte[n7];
                    System.arraycopy(byArray2, 0, byArray3, 0, n7);
                    return byArray3;
                }
                return byArray2;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKIException("CRS$Implementation.base64Decode: " + jSAFE_Exception.getMessage());
            }
        }

        public String toString() {
            return "CRS provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cn cn) throws InvalidParameterException, PKIException {
            this(certJ, string);
        }
    }
}

