/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class HoldInstructionCode
extends X509V3Extension
implements Cloneable,
Serializable,
CRLEntryExtension,
OCSPSingleExtension {
    private byte[] a;
    private int b;
    private int c;
    ASN1Template d;

    public HoldInstructionCode() {
        this.extensionTypeFlag = 23;
        this.criticality = false;
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public HoldInstructionCode(byte[] byArray, int n2, int n3, boolean bl2) {
        this.extensionTypeFlag = 23;
        this.criticality = bl2;
        if (byArray != null && n3 != 0) {
            this.setCode(byArray, n2, n3);
        }
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public void setCode(byte[] byArray, int n2, int n3) {
        if (byArray == null || n3 == 0) {
            return;
        }
        try {
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, byArray, n2, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            this.a = ASN1.derEncode(aSN1ContainerArray);
            this.b = 1 + ASN1Lengths.determineLengthLen(this.a, 1);
            this.c = this.a.length - this.b;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            this.b = 0;
            this.c = 0;
            return;
        }
    }

    public void decodeValue(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OIDContainer oIDContainer = new OIDContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CertificateException("Could not decode HoldInstructionCode extension.");
        }
        this.setCode(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen);
    }

    public byte[] getCode() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.a, this.b, byArray, 0, this.c);
        return byArray;
    }

    public int derEncodeValueInit() {
        try {
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, this.a, this.b, this.c);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.d == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.d.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HoldInstructionCode holdInstructionCode = new HoldInstructionCode();
        if (this.a != null) {
            holdInstructionCode.a = (byte[])this.a.clone();
            holdInstructionCode.b = this.b;
            holdInstructionCode.c = this.c;
        }
        super.copyValues(holdInstructionCode);
        return holdInstructionCode;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.c = 0;
        this.b = 0;
    }
}

