/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

public class X509CRL
extends CRL
implements Cloneable,
Serializable {
    public static final int X509_VERSION_1 = 0;
    public static final int X509_VERSION_2 = 1;
    private byte[] a;
    private int b;
    private int c = 0;
    private X500Name d;
    private RevokedCertificates e;
    private boolean f = false;
    private Date g;
    private Date h;
    private X509V3Extensions i;
    protected int special;
    private ASN1Template j;
    protected int innerSpecial;
    private ASN1Template k;

    public X509CRL() {
    }

    public X509CRL(CertJ certJ) {
        this.setCertJ(certJ);
    }

    public X509CRL(byte[] byArray, int n2, int n3) throws CertificateException {
        this(byArray, n2, n3, null);
    }

    public X509CRL(byte[] byArray, int n2, int n3, CertJ certJ) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a(byArray, n2, n3);
        this.setCertJ(certJ);
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CertificateException {
        try {
            if (byArray == null) {
                throw new CertificateException("Encoding is null.");
            }
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws CertificateException {
        this.clearComponents();
        ASN1Container[] aSN1ContainerArray = X509CRL.decodeCRL(byArray, n2, n3);
        this.setInnerDER(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset);
        this.signature = new byte[aSN1ContainerArray[3].dataLen];
        System.arraycopy(aSN1ContainerArray[3].data, aSN1ContainerArray[3].dataOffset, this.signature, 0, aSN1ContainerArray[3].dataLen);
        if (!this.b(aSN1ContainerArray[2].data, aSN1ContainerArray[2].dataOffset, aSN1ContainerArray[2].dataLen)) {
            throw new CertificateException("Unknown or invalid signature algorithm.");
        }
    }

    protected static ASN1Container[] decodeCRL(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(n3);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(768);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the CRL.");
        }
        return aSN1ContainerArray;
    }

    public int getDERLen(int n2) {
        return this.a(n2);
    }

    private int a(int n2) {
        this.special = n2;
        if (this.a == null) {
            this.b = this.getInnerDERLen();
        }
        if (this.b == 0) {
            return 0;
        }
        if (this.signatureAlgorithmBER == null || this.signature == null) {
            return 0;
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, this.b);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer encodedContainer3 = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
            this.j = new ASN1Template(aSN1ContainerArray);
            return this.j.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Specified array is null.");
        }
        int n4 = 0;
        try {
            if (this.j == null || n3 != this.special) {
                this.a(n3);
            }
            n4 += this.j.derEncode(byArray, n2);
            this.j = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.j = null;
            throw new CertificateException("Could not encode: " + aSN_Exception.getMessage());
        }
        if (this.a != null && this.b != 0 && this.innerSpecial == 0) {
            System.arraycopy(this.a, 0, byArray, n2 + n4, this.b);
            n4 += this.b;
        } else {
            int n5 = this.getInnerDER(byArray, n2 + n4);
            if (n5 == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            n4 += n5;
        }
        System.arraycopy(this.signatureAlgorithmBER, 0, byArray, n2 + n4, this.signatureAlgorithmBER.length);
        System.arraycopy(this.signature, 0, byArray, n2 + (n4 += this.signatureAlgorithmBER.length), this.signature.length);
        return n4 + this.signature.length;
    }

    public void setInnerDER(byte[] byArray, int n2) throws CertificateException {
        Cloneable cloneable;
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearSignature();
        this.clearTemplate();
        SequenceContainer sequenceContainer = new SequenceContainer(this.special);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(65536);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        UTCTimeContainer uTCTimeContainer = new UTCTimeContainer(0);
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(65536);
        UTCTimeContainer uTCTimeContainer2 = new UTCTimeContainer(0);
        GenTimeContainer genTimeContainer2 = new GenTimeContainer(0);
        EncodedContainer encodedContainer3 = new EncodedContainer(77824);
        EncodedContainer encodedContainer4 = new EncodedContainer(10563584);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, choiceContainer, uTCTimeContainer, genTimeContainer, endContainer, choiceContainer2, uTCTimeContainer2, genTimeContainer2, endContainer, encodedContainer3, encodedContainer4, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the CRL info.");
        }
        if (integerContainer.dataPresent) {
            this.checkVersionNumber(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
        }
        if (!this.b(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen)) {
            throw new CertificateException("Unknown or invalid signature algorithm.");
        }
        try {
            cloneable = new X500Name(encodedContainer2.data, encodedContainer2.dataOffset, 0);
            this.setIssuerName((X500Name)cloneable);
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid issuer name: " + nameException.getMessage());
        }
        this.g = uTCTimeContainer.dataPresent ? uTCTimeContainer.theTime : genTimeContainer.theTime;
        if (uTCTimeContainer2.dataPresent) {
            this.h = uTCTimeContainer2.theTime;
        } else if (genTimeContainer2.dataPresent) {
            this.h = genTimeContainer2.theTime;
        }
        if (encodedContainer3.dataPresent) {
            this.e = new RevokedCertificates(encodedContainer3.data, encodedContainer3.dataOffset, 0);
        }
        if (encodedContainer4.dataPresent) {
            cloneable = new X509V3Extensions(encodedContainer4.data, encodedContainer4.dataOffset, 0xA00000, 2);
            this.setExtensions((X509V3Extensions)cloneable);
        }
        this.b = X509CRL.getNextBEROffset(byArray, n2) - n2;
        this.a = new byte[this.b];
        System.arraycopy(byArray, n2, this.a, 0, this.b);
    }

    protected void checkVersionNumber(int n2) throws CertificateException {
        if (n2 != 1) {
            throw new CertificateException("Invalid X.509 CRL version.");
        }
        this.c = n2;
    }

    protected void checkVersionNumber(byte[] byArray, int n2, int n3) throws CertificateException {
        if (byArray == null || n3 > 4) {
            throw new CertificateException("Invalid X.509 Certificate version.");
        }
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n4 = n4 << 8 | byArray[n2] & 0xFF;
        }
        if (n4 != 1) {
            throw new CertificateException("Invalid X.509 CRL version.");
        }
        this.c = n4;
    }

    private boolean b(byte[] byArray, int n2, int n3) {
        if (byArray == null || n3 == 0) {
            return false;
        }
        try {
            if (this.signatureAlgorithmBER == null) {
                this.signatureAlgorithmBER = new byte[n3];
                System.arraycopy(byArray, n2, this.signatureAlgorithmBER, 0, n3);
                String string = AlgorithmID.berDecodeAlgID(byArray, n2, 1, null);
                return string != null;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            return false;
        }
        if (n3 != this.signatureAlgorithmBER.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n2] != this.signatureAlgorithmBER[n4]) {
                return false;
            }
            ++n4;
            ++n2;
        }
        return true;
    }

    public int getInnerDERLen() {
        return this.a();
    }

    private int a() {
        this.innerSpecial = this.special;
        if (this.g == null || this.signatureAlgorithmBER == null) {
            return 0;
        }
        if (this.d == null && !this.b(18)) {
            return 0;
        }
        SequenceContainer sequenceContainer = new SequenceContainer(this.special, true, 0);
        EndContainer endContainer = new EndContainer();
        boolean bl2 = true;
        if (this.c == 0) {
            bl2 = false;
        }
        IntegerContainer integerContainer = new IntegerContainer(65536, bl2, 0, this.c);
        EncodedContainer encodedContainer = null;
        try {
            encodedContainer = new EncodedContainer(12288, true, 0, this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        GenTimeContainer genTimeContainer = null;
        genTimeContainer = this.f ? new GenTimeContainer(0, true, 0, this.g) : new UTCTimeContainer(0, true, 0, this.g);
        bl2 = false;
        if (this.h != null) {
            bl2 = true;
        }
        GenTimeContainer genTimeContainer2 = null;
        genTimeContainer2 = this.f ? new GenTimeContainer(65536, bl2, 0, this.h) : new UTCTimeContainer(65536, bl2, 0, this.h);
        bl2 = false;
        int n2 = 0;
        try {
            if (this.e != null) {
                n2 = this.e.getDERLen(65536);
                bl2 = true;
            }
        }
        catch (CertificateException certificateException) {
            return 0;
        }
        try {
            EncodedContainer encodedContainer2 = new EncodedContainer(77824, bl2, 0, null, 0, n2);
            byte[] byArray = null;
            try {
                if (this.d != null) {
                    n2 = this.d.getDERLen(0);
                    byArray = new byte[n2];
                    this.d.getDEREncoding(byArray, 0, 0);
                } else {
                    n2 = 2;
                    byArray = new byte[n2];
                    byArray[0] = 48;
                    byArray[1] = 0;
                }
            }
            catch (NameException nameException) {
                return 0;
            }
            EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            bl2 = false;
            n2 = 0;
            if (this.c == 1 && this.i != null && (n2 = this.i.getDERLen(0xA10000)) != 0) {
                bl2 = true;
            }
            EncodedContainer encodedContainer4 = new EncodedContainer(10563584, bl2, 0, null, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer3, genTimeContainer, genTimeContainer2, encodedContainer2, encodedContainer4, endContainer};
            this.k = new ASN1Template(aSN1ContainerArray);
            return this.k.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getInnerDER(byte[] byArray, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Passed array is null.");
        }
        int n3 = 0;
        try {
            int n4;
            if (this.k == null && (n4 = this.a()) == 0) {
                throw new CertificateException("Cannot encode innerDER, information missing.");
            }
            n3 += this.k.derEncode(byArray, n2);
            this.k = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.k = null;
            throw new CertificateException("Could not encode: " + aSN_Exception.getMessage());
        }
        if (this.e != null) {
            n3 += this.e.getDEREncoding(byArray, n2 + n3, 65536, this.f);
        }
        if (this.c == 1 && this.i != null) {
            n3 += this.i.getDEREncoding(byArray, n2 + n3, 0xA10000);
        }
        return n3;
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        try {
            ASN1.berDecode(this.signature, 0, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot extract the signature.");
        }
        byte[] byArray = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, byArray, 0, bitStringContainer.dataLen);
        return byArray;
    }

    public void setVersion(int n2) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        this.c = n2;
        if (n2 == 0 || n2 == 1) {
            return;
        }
        this.c = 0;
        throw new CertificateException("Invalid CRL version: " + n2);
    }

    public int getVersion() {
        return this.c;
    }

    public void setIssuerName(X500Name x500Name) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (x500Name == null) {
            if (!this.b(18)) {
                throw new CertificateException("Cannot set the CRL with null issuerName.");
            }
        } else {
            try {
                this.d = (X500Name)x500Name.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CertificateException("Cannot set the CRL with the given issuerName.");
            }
        }
    }

    public X500Name getIssuerName() {
        if (this.d == null) {
            return null;
        }
        try {
            return (X500Name)this.d.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setNextUpdate(Date date) {
        this.clearSignature();
        this.clearTemplate();
        if (date != null) {
            this.h = new Date(date.getTime());
        }
    }

    public Date getNextUpdate() {
        if (this.h == null) {
            return null;
        }
        return new Date(this.h.getTime());
    }

    public void setThisUpdate(Date date) {
        this.clearSignature();
        this.clearTemplate();
        if (date != null) {
            this.g = new Date(date.getTime());
        }
    }

    public Date getThisUpdate() {
        if (this.g == null) {
            return null;
        }
        return new Date(this.g.getTime());
    }

    public void setRevokedCertificates(RevokedCertificates revokedCertificates) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (revokedCertificates != null) {
            try {
                this.e = (RevokedCertificates)revokedCertificates.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CertificateException("Cannot set the CRL with the given revoked Certs.");
            }
        }
    }

    public RevokedCertificates getRevokedCertificates() {
        if (this.e == null) {
            return null;
        }
        try {
            return (RevokedCertificates)this.e.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean compareIssuerName(X500Name x500Name) {
        if (this.d == null || x500Name == null) {
            return false;
        }
        return this.d.equals(x500Name);
    }

    public void setTimeType(boolean bl2) {
        this.f = bl2;
    }

    public void setExtensions(X509V3Extensions x509V3Extensions) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (x509V3Extensions == null) {
            throw new CertificateException("CRL extensions are null.");
        }
        if (x509V3Extensions.getExtensionsType() != 2) {
            throw new CertificateException("Wrong extensions type: should be CRL extensions.");
        }
        if (this.c == 0) {
            X509V3Extension x509V3Extension = null;
            for (int i2 = 0; i2 < x509V3Extensions.getExtensionCount(); ++i2) {
                x509V3Extension = x509V3Extensions.getExtensionByIndex(i2);
                if (!x509V3Extension.getCriticality()) continue;
                throw new CertificateException("Cannot set critical extensions on a version 1 CRL.");
            }
        }
        try {
            this.i = (X509V3Extensions)x509V3Extensions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Cannot set the CRL with the given extensions.");
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.i == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.i.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void signCRL(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CertificateException {
        Object object;
        this.clearSignature();
        this.clearTemplate();
        if (string == null || string2 == null || jSAFE_PrivateKey == null) {
            throw new CertificateException("Cannot sign, specified values are null.");
        }
        try {
            object = this.getSignatureFormat();
            this.signatureAlgorithmBER = object == null ? AlgorithmID.derEncodeAlgID(string, 1, null, 0, 0) : AlgorithmID.derEncodeAlgID((String)object, 1, null, 0, 0);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot sign, unknown algorithm.(" + aSN_Exception.getMessage() + ")");
        }
        this.b = this.getInnerDERLen();
        if (this.b == 0) {
            throw new CertificateException("Cannot sign CRL, values not set.");
        }
        this.a = new byte[this.b];
        this.b = this.getInnerDER(this.a, 0);
        object = this.performSignature(string, string2, jSAFE_PrivateKey, secureRandom, this.a, 0, this.b);
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, (byte[])object, 0, ((Object)object).length, ((Object)object).length * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.signature = ASN1.derEncode(aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the CRL as presently set.");
        }
    }

    public boolean verifyCRLSignature(String string, JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws CertificateException {
        if (this.a == null) {
            throw new CertificateException("Cannot verify CRL, values not set.");
        }
        if (string == null || jSAFE_PublicKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        byte[] byArray = this.getSignature();
        return this.performSignatureVerification(string, jSAFE_PublicKey, secureRandom, this.a, 0, this.b, byArray, 0, byArray.length);
    }

    private boolean b(int n2) {
        if (this.c == 1 && this.i != null) {
            Vector vector = this.i.theExtensions;
            X509V3Extension x509V3Extension = null;
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                x509V3Extension = (X509V3Extension)vector.elementAt(i2);
                if (x509V3Extension.getExtensionType() != n2 || !x509V3Extension.getCriticality()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)object;
        try {
            int n2 = this.getDERLen(0);
            int n3 = x509CRL.getDERLen(0);
            if (n2 != n3) {
                return false;
            }
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n3];
            n2 = this.getDEREncoding(byArray, 0, 0);
            if (n2 != (n3 = x509CRL.getDEREncoding(byArray2, 0, 0))) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        catch (CertificateException certificateException) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        X509CRL x509CRL = (X509CRL)super.clone();
        if (this.signatureAlgorithmBER != null) {
            x509CRL.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        x509CRL.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        if (this.signature != null) {
            x509CRL.signature = (byte[])this.signature.clone();
        }
        if (this.theDevice != null) {
            x509CRL.theDevice = new String(this.theDevice);
        }
        if (this.theDeviceList != null) {
            x509CRL.theDeviceList = (String[])this.theDeviceList.clone();
        }
        if (this.a != null) {
            x509CRL.a = (byte[])this.a.clone();
        }
        x509CRL.b = this.b;
        x509CRL.c = this.c;
        if (this.d != null) {
            x509CRL.d = (X500Name)this.d.clone();
        }
        if (this.e != null) {
            x509CRL.e = (RevokedCertificates)this.e.clone();
        }
        if (this.g != null) {
            x509CRL.g = new Date(this.g.getTime());
        }
        if (this.h != null) {
            x509CRL.h = new Date(this.h.getTime());
        }
        if (this.i != null) {
            x509CRL.i = (X509V3Extensions)this.i.clone();
        }
        x509CRL.special = this.special;
        x509CRL.innerSpecial = this.innerSpecial;
        if (this.j != null) {
            x509CRL.a(this.special);
        }
        if (this.k != null) {
            x509CRL.a();
        }
        return x509CRL;
    }

    protected void clearTemplate() {
        this.j = null;
        this.k = null;
        this.a = null;
        this.b = 0;
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.a = null;
        this.b = 0;
        this.c = 0;
        this.d = null;
        this.e = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.f = false;
    }
}

