/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;

public class X500Name
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;
    private Vector b = new Vector();
    private static final char[] c = new char[]{',', '=', '+', '<', '>', '#', ';', '\"', '\\'};

    public X500Name(byte[] byArray, int n2, int n3) throws NameException, RuntimeException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(12544));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                RDN rDN = new RDN(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(rDN);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the name." + aSN_Exception.getMessage());
        }
    }

    public X500Name() throws RuntimeException {
    }

    public X500Name(String string) throws NameException, RuntimeException {
        int n2;
        Object object;
        if (string == null) {
            throw new NameException("The string is null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\,;", true);
        int n3 = stringTokenizer.countTokens();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        String string2 = new String();
        for (int i2 = 0; i2 < n3; ++i2) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("\\")) {
                stringBuffer.append(string2);
                stringBuffer.append(stringTokenizer.nextToken());
                ++i2;
                continue;
            }
            if (!string2.equals(",") && !string2.equals(";")) {
                stringBuffer.append(string2);
                continue;
            }
            object = stringTokenizer.nextToken();
            ++i2;
            if (((String)object).indexOf("=") == -1) {
                stringBuffer.append(",");
                stringBuffer.append((String)object);
                continue;
            }
            n2 = 0;
            while (((String)object).substring(n2).startsWith(" ")) {
                ++n2;
            }
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer((String)object);
        }
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        RDN rDN = new RDN();
        object = null;
        for (n2 = vector.size() - 1; n2 >= 0; --n2) {
            CharSequence charSequence;
            int n4;
            string2 = (String)vector.elementAt(n2);
            stringTokenizer = new StringTokenizer(string2, "\\+", true);
            int n5 = stringTokenizer.countTokens();
            Vector<String> vector2 = new Vector<String>();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n4 = 0; n4 < n5; ++n4) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("\\")) {
                    charSequence = new StringBuffer(stringTokenizer.nextToken());
                    this.a((StringBuffer)charSequence);
                    stringBuffer2.append(((StringBuffer)charSequence).toString());
                    ++n4;
                    continue;
                }
                stringBuffer2.append(this.a());
                if (!string3.equals("+")) {
                    stringBuffer2.append(string3);
                    continue;
                }
                vector2.addElement(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer2.append(this.a());
            if (stringBuffer2.length() != 0) {
                vector2.addElement(stringBuffer2.toString());
            }
            rDN = new RDN();
            for (n4 = 0; n4 < vector2.size(); ++n4) {
                int n6;
                charSequence = (String)vector2.elementAt(n4);
                int n7 = ((String)charSequence).indexOf(61);
                if (n7 == -1) {
                    throw new NameException("AVA representation is invalid, should be 'type=value'");
                }
                for (int i3 = n6 = 0; i3 < n7; ++i3) {
                    if (((String)charSequence).substring(i3, i3 + 1).equals(" ")) continue;
                    n6 = i3;
                    break;
                }
                String string4 = ((String)charSequence).substring(n6, n7);
                n6 = n7 + 1;
                int n8 = AttributeValueAssertion.findAttributeType(string4);
                if (n8 == -1) {
                    byte[] byArray = this.b(string4);
                    byte[] byArray2 = this.a(((String)charSequence).substring(n6));
                    object = new AttributeValueAssertion(byArray, byArray2);
                } else {
                    object = new AttributeValueAssertion(n8, AttributeValueAssertion.getAttributeOID(n8), 0, ((String)charSequence).substring(n6));
                }
                rDN.addNameAVA((AttributeValueAssertion)object);
            }
            this.a.addElement(rDN);
        }
    }

    private void a(StringBuffer stringBuffer) throws NameException {
        if (X500Name.b(stringBuffer)) {
            return;
        }
        byte by2 = X500Name.c(stringBuffer);
        this.b.addElement(new Byte(by2));
        if (stringBuffer.length() > 2) {
            stringBuffer.reverse();
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.reverse();
            stringBuffer.insert(0, this.a());
            return;
        }
        stringBuffer.setLength(0);
    }

    private String a() {
        int n2 = this.b.size();
        if (n2 == 0) {
            return new String();
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (Byte)this.b.elementAt(i2);
        }
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.b.removeAllElements();
        return string;
    }

    private static boolean b(StringBuffer stringBuffer) {
        int n2;
        char c2 = Character.toUpperCase(stringBuffer.charAt(0));
        for (n2 = 0; n2 < c.length && c2 != c[n2]; ++n2) {
        }
        return n2 != c.length;
    }

    private static byte c(StringBuffer stringBuffer) throws NameException {
        if (stringBuffer.length() < 2) {
            throw new NameException("Invalid UTF-8 escape sequence: Two characters per hex byte required");
        }
        try {
            String string = stringBuffer.toString().substring(0, 2);
            int n2 = Integer.parseInt(string, 16);
            return (byte)(n2 & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NameException("Invalid UTF-8 escape sequence: Escaped hex byte invalid");
        }
    }

    private byte[] a(String string) throws NameException {
        String string2 = string.startsWith("#") ? string.substring(1) : string;
        int n2 = string2.length();
        byte[] byArray = null;
        byArray = n2 % 2 == 0 ? new byte[n2 / 2] : new byte[n2 / 2 + 1];
        int n3 = byArray.length - 1;
        int n4 = n2;
        while (n3 >= 0) {
            byArray[n3] = n4 == 1 ? (byte)Integer.parseInt(string2.substring(n4 - 1, n4), 16) : (n4 == n2 ? (byte)Integer.parseInt(string2.substring(n4 - 2), 16) : (byte)Integer.parseInt(string2.substring(n4 - 2, n4), 16));
            --n3;
            n4 -= 2;
        }
        return byArray;
    }

    private byte[] b(String string) throws NameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.countTokens();
        if (n2 < 2) {
            throw new NameException("Invalid OID: should be the dotted-decimal encoding with at least 2 components.");
        }
        Integer[] integerArray = new Integer[n2];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringTokenizer.nextToken();
                integerArray[i2] = new Integer(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NameException("Cannot convert String to int. " + numberFormatException.getMessage());
        }
        byte[] byArray = new byte[]{(byte)(integerArray[0] * 40 + integerArray[1])};
        for (int i3 = 2; i3 < n2; ++i3) {
            byte[] byArray2 = new byte[5];
            int n3 = 4;
            for (int i4 = integerArray[i3].intValue(); i4 != 0; i4 >>>= 7) {
                byArray2[n3] = (byte)(i4 & 0x7F);
                int n4 = n3--;
                byArray2[n4] = (byte)(byArray2[n4] | 0x80);
            }
            byArray2[4] = (byte)(byArray2[4] & 0x7F);
            byte[] byArray3 = new byte[5 - (n3 + 1)];
            System.arraycopy(byArray2, n3 + 1, byArray3, 0, byArray3.length);
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = new byte[byArray.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        }
        return byArray;
    }

    public Object clone() throws CloneNotSupportedException {
        X500Name x500Name = new X500Name();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            x500Name.a.addElement(rDN.clone());
        }
        x500Name.special = this.special;
        if (this.asn1Template != null) {
            x500Name.b();
        }
        return x500Name;
    }

    private String a(boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.size() == 0) {
            return "";
        }
        if (bl2) {
            for (int i2 = this.a.size() - 1; i2 >= 1; --i2) {
                RDN rDN = (RDN)this.a.elementAt(i2);
                stringBuffer.append(rDN.toString(bl3));
                stringBuffer.append(",");
            }
            RDN rDN = (RDN)this.a.elementAt(0);
            stringBuffer.append(rDN.toString(bl3));
        } else {
            for (int i3 = 0; i3 < this.a.size() - 1; ++i3) {
                RDN rDN = (RDN)this.a.elementAt(i3);
                stringBuffer.append(rDN.toString(bl3));
                stringBuffer.append(",");
            }
            RDN rDN = (RDN)this.a.elementAt(this.a.size() - 1);
            stringBuffer.append(rDN.toString(bl3));
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl2) {
        return this.a(bl2, false);
    }

    public String toString() {
        return this.a(true, true);
    }

    public String toStringRFC2253() {
        return this.a(true, false);
    }

    public int getRDNCount() {
        return this.a.size();
    }

    public int getAttributeCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            n2 += ((RDN)this.a.elementAt(i2)).getAttributeCount();
        }
        return n2;
    }

    public RDN getRDN(int n2) throws NameException {
        int n3 = this.a.size();
        if (n2 >= 0 && n3 > n2) {
            return (RDN)this.a.elementAt(n2);
        }
        throw new NameException("Invalid Index.");
    }

    public void removeRDN(int n2) throws NameException {
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.removeElementAt(n2);
    }

    public void addRDN(RDN rDN, int n2) throws NameException {
        if (rDN == null) {
            throw new NameException("Specified RDN is null.");
        }
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(rDN, n2);
    }

    public AttributeValueAssertion getAttribute(int n2) {
        int n3 = this.a.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            AttributeValueAssertion attributeValueAssertion = rDN.getAttribute(n2);
            if (attributeValueAssertion == null) continue;
            return attributeValueAssertion;
        }
        return null;
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) {
        this.special = n2;
        return this.b();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n3 != this.special) {
                this.getDERLen(n3);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode X500Name.");
                }
            }
            int n4 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode X500Name." + aSN_Exception.getMessage());
        }
    }

    private int b() {
        try {
            OfContainer ofContainer;
            int n2 = this.a.size();
            if (n2 == 0) {
                ofContainer = new OfContainer(this.special, false, 0, 12288, new EncodedContainer(12544));
            } else {
                ofContainer = new OfContainer(this.special, true, 0, 12288, new EncodedContainer(12544));
                for (int i2 = 0; i2 < n2; ++i2) {
                    RDN rDN = (RDN)this.a.elementAt(i2);
                    byte[] byArray = new byte[rDN.getDERLen(0)];
                    int n3 = rDN.getDEREncoding(byArray, 0, 0);
                    EncodedContainer encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n3);
                    ofContainer.addContainer(encodedContainer);
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public void addRDN(RDN rDN) throws NameException {
        if (rDN == null) {
            throw new NameException("Specified RDN is null.");
        }
        this.a.addElement(rDN);
    }

    public void addRDN(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        RDN rDN = new RDN(byArray, n2, 0);
        this.a.addElement(rDN);
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null || !(object instanceof X500Name)) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        int n3 = this.getRDNCount();
        if (n3 != (n2 = x500Name.getRDNCount())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (((RDN)this.a.elementAt(i2)).equals((RDN)x500Name.a.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(X500Name x500Name) {
        if (x500Name == null) {
            return false;
        }
        int n2 = this.getRDNCount();
        int n3 = x500Name.getRDNCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            RDN rDN = (RDN)x500Name.a.elementAt(i2);
            for (n4 = 0; n4 < n2 && !rDN.equals((RDN)this.a.elementAt(n4)); ++n4) {
            }
            if (n4 >= n2) {
                return false;
            }
            if (rDN.equals((RDN)this.a.elementAt(n4))) continue;
            return false;
        }
        return true;
    }
}

